/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.wst.jsdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;

public final class JavaPairMatcher
extends DefaultCharacterPairMatcher
implements ISourceVersionDependent {
    private boolean fHighlightAngularBrackets = false;

    public JavaPairMatcher(char[] cArray) {
        super(cArray, "___java_partitioning");
    }

    public IRegion match(IDocument iDocument, int n) {
        try {
            return this.performMatch(iDocument, n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument iDocument, int n) throws BadLocationException {
        int n2;
        if (n < 0 || iDocument == null) {
            return null;
        }
        char c = iDocument.getChar(Math.max(n - 1, 0));
        if (!(c != '<' && c != '>' || this.fHighlightAngularBrackets)) {
            return null;
        }
        if (c == '<' && this.isLessThanOperator(iDocument, n - 1)) {
            return null;
        }
        IRegion iRegion = super.match(iDocument, n);
        if (iRegion == null) {
            return iRegion;
        }
        if (c == '>' && this.isLessThanOperator(iDocument, n2 = iRegion.getOffset())) {
            return null;
        }
        return iRegion;
    }

    private boolean isLessThanOperator(IDocument iDocument, int n) throws BadLocationException {
        if (n < 0) {
            return false;
        }
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument, "___java_partitioning", TextUtilities.getContentType((IDocument)iDocument, (String)"___java_partitioning", (int)n, (boolean)false));
        return !this.isTypeParameterBracket(n, iDocument, javaHeuristicScanner);
    }

    private boolean isTypeParameterBracket(int n, IDocument iDocument, JavaHeuristicScanner javaHeuristicScanner) {
        try {
            String string;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = javaHeuristicScanner.previousToken(n - 1, iRegion.getOffset());
            int n3 = javaHeuristicScanner.getPosition() + 1;
            String string2 = string = n2 == -1 ? null : iDocument.get(n3, n - n3).trim();
            return n2 == 1 || n2 == 2 || n2 == 7 || n2 == 1022 || n2 == 1019 || n2 == 2000 && this.isTypeParameterIntroducer(string) || n2 == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String string) {
        return string.length() > 0 && (Character.isUpperCase(string.charAt(0)) || string.startsWith("final") || string.startsWith("public") || string.startsWith("public") || string.startsWith("protected") || string.startsWith("private"));
    }

    public void setSourceVersion(String string) {
        this.fHighlightAngularBrackets = "1.5".compareTo(string) <= 0;
    }
}

