/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;

public class SequenceCharacterIterator
implements CharacterIterator {
    private int fIndex = -1;
    private final CharSequence fSequence;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
        Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
    }

    public SequenceCharacterIterator(CharSequence charSequence) {
        this(charSequence, 0);
    }

    public SequenceCharacterIterator(CharSequence charSequence, int n) throws IllegalArgumentException {
        this(charSequence, n, charSequence.length());
    }

    public SequenceCharacterIterator(CharSequence charSequence, int n, int n2) throws IllegalArgumentException {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException();
        }
        if (n2 > charSequence.length()) {
            throw new IllegalArgumentException();
        }
        this.fSequence = charSequence;
        this.fFirst = n;
        this.fLast = n2;
        this.fIndex = n;
        this.invariant();
    }

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            return this.fSequence.charAt(this.fIndex);
        }
        return '\uffff';
    }

    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    public char setIndex(int n) {
        if (n < this.getBeginIndex() || n > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = n;
        this.invariant();
        return this.current();
    }

    public int getBeginIndex() {
        return this.fFirst;
    }

    public int getEndIndex() {
        return this.fLast;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

