/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;

public class NewDefiningMethodProposal
extends AbstractMethodCompletionProposal {
    private final IMethodBinding fMethod;
    private final String[] fParamNames;

    public NewDefiningMethodProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, ITypeBinding iTypeBinding, IMethodBinding iMethodBinding, String[] stringArray, int n) {
        super(string, iCompilationUnit, aSTNode, iTypeBinding, n, null);
        this.fMethod = iMethodBinding;
        this.fParamNames = stringArray;
        ImageDescriptor imageDescriptor = JavaElementImageProvider.getMethodImageDescriptor(iTypeBinding.isInterface() || iTypeBinding.isAnnotation(), iMethodBinding.getModifiers());
        this.setImage(JavaPlugin.getImageDescriptorRegistry().get(imageDescriptor));
    }

    protected boolean isConstructor() {
        return this.fMethod.isConstructor();
    }

    protected void addNewParameters(ASTRewrite aSTRewrite, List list, List list2) throws CoreException {
        AST aST = aSTRewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] iTypeBindingArray = this.fMethod.getParameterTypes();
        IJavaProject iJavaProject = this.getCompilationUnit().getJavaProject();
        String[][] stringArray = StubUtility.suggestArgumentNamesWithProposals(iJavaProject, this.fParamNames);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            String[] stringArray2 = stringArray[n];
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            singleVariableDeclaration.setType(importRewrite.addImport(iTypeBinding, aST));
            singleVariableDeclaration.setName(aST.newSimpleName(stringArray2[0]));
            list2.add(singleVariableDeclaration);
            String string = "arg_name_" + n;
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getName()), false, string);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                this.addLinkedPositionProposal(string, stringArray2[n2], null);
                ++n2;
            }
            ++n;
        }
    }

    protected SimpleName getNewName(ASTRewrite aSTRewrite) {
        AST aST = aSTRewrite.getAST();
        SimpleName simpleName = aST.newSimpleName(this.fMethod.getName());
        return simpleName;
    }

    private int evaluateModifiers() {
        if (this.getSenderBinding().isInterface()) {
            return 0;
        }
        int n = this.fMethod.getModifiers();
        if (Modifier.isPrivate((int)n)) {
            n |= 4;
        }
        return n & 0xC05;
    }

    protected void addNewModifiers(ASTRewrite aSTRewrite, ASTNode aSTNode, List list) {
        list.addAll(aSTRewrite.getAST().newModifiers(this.evaluateModifiers()));
    }

    protected Type getNewMethodType(ASTRewrite aSTRewrite) throws CoreException {
        return this.getImportRewrite().addImport(this.fMethod.getReturnType(), aSTRewrite.getAST());
    }

    protected void addNewExceptions(ASTRewrite aSTRewrite, List list) throws CoreException {
        AST aST = aSTRewrite.getAST();
        ImportRewrite importRewrite = this.getImportRewrite();
        ITypeBinding[] iTypeBindingArray = this.fMethod.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            String string = importRewrite.addImport(iTypeBindingArray[n]);
            Name name = ASTNodeFactory.newName(aST, string);
            list.add(name);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)name), false, "exc_type_" + n);
            ++n;
        }
    }

    protected void addNewTypeParameters(ASTRewrite aSTRewrite, List list, List list2) throws CoreException {
    }
}

