/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;

public class NewMethodCompletionProposal
extends AbstractMethodCompletionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private List fArguments;

    public NewMethodCompletionProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, List list, ITypeBinding iTypeBinding, int n, Image image) {
        super(string, iCompilationUnit, aSTNode, iTypeBinding, n, image);
        this.fArguments = list;
    }

    private int evaluateModifiers(ASTNode aSTNode) {
        if (this.getSenderBinding().isAnnotation()) {
            return 0;
        }
        if (this.getSenderBinding().isInterface()) {
            MethodDeclaration[] methodDeclarationArray = ((TypeDeclaration)aSTNode).getMethods();
            if (methodDeclarationArray.length > 0) {
                return methodDeclarationArray[0].getModifiers();
            }
            return 0;
        }
        ASTNode aSTNode2 = this.getInvocationNode();
        if (aSTNode2 instanceof MethodInvocation) {
            ASTNode aSTNode3;
            int n = 0;
            Expression expression = ((MethodInvocation)aSTNode2).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    n |= 8;
                }
            } else if (ASTResolving.isInStaticContext(aSTNode2)) {
                n |= 8;
            }
            if (aSTNode.equals((Object)(aSTNode3 = ASTResolving.findParentType(aSTNode2)))) {
                n |= 2;
            } else if (aSTNode3 instanceof AnonymousClassDeclaration && ASTNodes.isParent(aSTNode3, aSTNode)) {
                n |= 4;
                if (ASTResolving.isInStaticContext(aSTNode3)) {
                    n |= 8;
                }
            } else {
                n |= 1;
            }
            return n;
        }
        return 1;
    }

    protected void addNewModifiers(ASTRewrite aSTRewrite, ASTNode aSTNode, List list) {
        list.addAll(aSTRewrite.getAST().newModifiers(this.evaluateModifiers(aSTNode)));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), aSTRewrite, list, this.getSenderBinding().isInterface());
    }

    protected boolean isConstructor() {
        ASTNode aSTNode = this.getInvocationNode();
        return aSTNode.getNodeType() != 32 && aSTNode.getNodeType() != 48;
    }

    protected SimpleName getNewName(ASTRewrite aSTRewrite) {
        ASTNode aSTNode = this.getInvocationNode();
        String string = aSTNode instanceof MethodInvocation ? ((MethodInvocation)aSTNode).getName().getIdentifier() : (aSTNode instanceof SuperMethodInvocation ? ((SuperMethodInvocation)aSTNode).getName().getIdentifier() : this.getSenderBinding().getName());
        AST aST = aSTRewrite.getAST();
        SimpleName simpleName = aST.newSimpleName(string);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), false, KEY_NAME);
        ASTNode aSTNode2 = this.getInvocationNameNode();
        if (aSTNode2 != null && aSTNode2.getAST() == aST) {
            this.addLinkedPosition(aSTRewrite.track(aSTNode2), true, KEY_NAME);
        }
        return simpleName;
    }

    private ASTNode getInvocationNameNode() {
        ASTNode aSTNode = this.getInvocationNode();
        if (aSTNode instanceof MethodInvocation) {
            return ((MethodInvocation)aSTNode).getName();
        }
        if (aSTNode instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)aSTNode).getName();
        }
        if (aSTNode instanceof ClassInstanceCreation) {
            Type type = ((ClassInstanceCreation)aSTNode).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getType();
            }
            return type;
        }
        return null;
    }

    protected Type getNewMethodType(ASTRewrite aSTRewrite) throws CoreException {
        ITypeBinding[] iTypeBindingArray;
        MethodInvocation methodInvocation;
        ASTNode aSTNode = this.getInvocationNode();
        AST aST = aSTRewrite.getAST();
        Type type = null;
        ITypeBinding[] iTypeBindingArray2 = null;
        if (aSTNode.getParent() instanceof MethodInvocation && (methodInvocation = (MethodInvocation)aSTNode.getParent()).getExpression() == aSTNode && (iTypeBindingArray = ASTResolving.getQualifierGuess(aSTNode.getRoot(), methodInvocation.getName().getIdentifier(), methodInvocation.arguments(), (IBinding)this.getSenderBinding())).length > 0) {
            type = this.getImportRewrite().addImport(iTypeBindingArray[0], aST);
            iTypeBindingArray2 = iTypeBindingArray;
        }
        if (type == null) {
            methodInvocation = ASTResolving.guessBindingForReference(aSTNode);
            if (methodInvocation != null && methodInvocation.isWildcardType()) {
                methodInvocation = ASTResolving.normalizeWildcardType((ITypeBinding)methodInvocation, false, aST);
            }
            if (methodInvocation != null) {
                type = this.getImportRewrite().addImport((ITypeBinding)methodInvocation, aST);
            } else {
                iTypeBindingArray = aSTNode.getParent();
                if (iTypeBindingArray instanceof ExpressionStatement) {
                    return null;
                }
                type = ASTResolving.guessTypeForReference(aST, aSTNode);
                if (type == null) {
                    type = aST.newSimpleType((Name)aST.newSimpleName("Object"));
                }
            }
        }
        this.addLinkedPosition(aSTRewrite.track(type), false, KEY_TYPE);
        if (iTypeBindingArray2 != null) {
            int n = 0;
            while (n < iTypeBindingArray2.length) {
                this.addLinkedPositionProposal(KEY_TYPE, iTypeBindingArray2[n]);
                ++n;
            }
        }
        return type;
    }

    protected void addNewParameters(ASTRewrite aSTRewrite, List list, List list2) throws CoreException {
        AST aST = aSTRewrite.getAST();
        List list3 = this.fArguments;
        int n = 0;
        while (n < list3.size()) {
            Expression expression = (Expression)list3.get(n);
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            String string = "arg_type_" + n;
            Type type = this.evaluateParameterType(aST, expression, string);
            singleVariableDeclaration.setType(type);
            String string2 = "arg_name_" + n;
            String string3 = this.evaluateParameterName(list, expression, type, string2);
            singleVariableDeclaration.setName(aST.newSimpleName(string3));
            list2.add(singleVariableDeclaration);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getType()), false, string);
            this.addLinkedPosition(aSTRewrite.track((ASTNode)singleVariableDeclaration.getName()), false, string2);
            ++n;
        }
    }

    private Type evaluateParameterType(AST aST, Expression expression, String string) throws CoreException {
        ITypeBinding iTypeBinding = Bindings.normalizeTypeBinding(expression.resolveTypeBinding());
        if (iTypeBinding != null && iTypeBinding.isWildcardType()) {
            iTypeBinding = ASTResolving.normalizeWildcardType(iTypeBinding, true, aST);
        }
        if (iTypeBinding != null) {
            ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, iTypeBinding);
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.addLinkedPositionProposal(string, iTypeBindingArray[n]);
                ++n;
            }
            return this.getImportRewrite().addImport(iTypeBinding, aST);
        }
        return aST.newSimpleType((Name)aST.newSimpleName("Object"));
    }

    private String evaluateParameterName(List list, Expression expression, Type type, String string) {
        IJavaProject iJavaProject = this.getCompilationUnit().getJavaProject();
        String[] stringArray = StubUtility.getVariableNameSuggestions(4, iJavaProject, type, expression, (Collection)list);
        int n = 0;
        while (n < stringArray.length) {
            this.addLinkedPositionProposal(string, stringArray[n], null);
            ++n;
        }
        String string2 = stringArray[0];
        list.add(string2);
        return string2;
    }

    protected void addNewExceptions(ASTRewrite aSTRewrite, List list) throws CoreException {
    }

    protected void addNewTypeParameters(ASTRewrite aSTRewrite, List list, List list2) throws CoreException {
    }
}

