/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class ImportCompletionProposal
extends AbstractJavaCompletionProposal {
    private final ICompilationUnit fCompilationUnit;
    private final int fParentProposalKind;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;
    private final CompletionProposal fProposal;
    private boolean fReplacementStringComputed;

    public ImportCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext, int n) {
        super(javaContentAssistInvocationContext);
        this.fProposal = completionProposal;
        this.fParentProposalKind = n;
        this.fCompilationUnit = javaContentAssistInvocationContext.getCompilationUnit();
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    private String computeReplacementString() {
        int n = this.fProposal.getKind();
        String string = null;
        char[] cArray = null;
        if (n == 23) {
            cArray = this.fProposal.getSignature();
            string = String.valueOf(Signature.toCharArray((char[])cArray));
        } else if (n == 22 || n == 21) {
            cArray = this.fProposal.getDeclarationSignature();
            string = String.valueOf(Signature.toCharArray((char[])cArray));
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fImportRewrite = this.createImportRewrite();
        if (this.fImportRewrite != null) {
            if (n == 23) {
                String string2 = this.fImportRewrite.addImport(string, (ImportRewrite.ImportRewriteContext)this.fImportContext);
                if (this.fParentProposalKind == 6) {
                    return String.valueOf(string2) + ".";
                }
            } else {
                this.fImportRewrite.addStaticImport(string, String.valueOf(this.fProposal.getName()), n == 21, (ImportRewrite.ImportRewriteContext)this.fImportContext);
            }
            return "";
        }
        if (this.fCompilationUnit != null && JavaModelUtil.isImplicitImport(Signature.getQualifier((String)string), this.fCompilationUnit)) {
            if (this.fProposal.getKind() == 23 && this.fParentProposalKind == 2) {
                return "";
            }
            string = String.valueOf(Signature.getSignatureSimpleName((char[])cArray));
        }
        return String.valueOf(string) + ".";
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            super.apply(iDocument, c, n);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int n2 = iDocument.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(iDocument, 2);
                this.setReplacementOffset(this.getReplacementOffset() + iDocument.getLength() - n2);
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.shouldAddImports()) {
            try {
                CompilationUnit compilationUnit = this.getASTRoot(this.fCompilationUnit);
                if (compilationUnit == null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return importRewrite;
                }
                ImportRewrite importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(compilationUnit, this.fInvocationContext.getInvocationOffset(), importRewrite);
                return importRewrite;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        return null;
    }

    private CompilationUnit getASTRoot(ICompilationUnit iCompilationUnit) {
        return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    private boolean shouldAddImports() {
        if (this.isInJavadoc() && !this.isJavadocProcessingEnabled()) {
            return false;
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject iJavaProject = this.fCompilationUnit.getJavaProject();
        boolean bl = iJavaProject == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.doc.comment.support")) : "enabled".equals(iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", true));
        return bl;
    }
}

