/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class LazyGenericTypeProposal
extends LazyJavaTypeCompletionProposal {
    private static final char[] GENERIC_TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', '<', ' '};
    private IRegion fSelectedRegion;
    private TypeArgumentProposal[] fTypeArgumentProposals;

    public LazyGenericTypeProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(completionProposal, javaContentAssistInvocationContext);
    }

    public void apply(IDocument iDocument, char c, int n) {
        if (this.shouldAppendArguments(iDocument, n, c)) {
            try {
                TypeArgumentProposal[] typeArgumentProposalArray = this.computeTypeArgumentProposals();
                if (typeArgumentProposalArray.length > 0) {
                    boolean bl;
                    int[] nArray = new int[typeArgumentProposalArray.length];
                    int[] nArray2 = new int[typeArgumentProposalArray.length];
                    StringBuffer stringBuffer = this.createParameterList(typeArgumentProposalArray, nArray, nArray2);
                    boolean bl2 = bl = c == '(' && this.autocloseBrackets();
                    if (bl) {
                        this.updateReplacementWithParentheses(stringBuffer);
                    }
                    super.setReplacementString(stringBuffer.toString());
                    super.apply(iDocument, '\u0000', n);
                    if (this.getTextViewer() != null) {
                        if (this.hasAmbiguousProposals(typeArgumentProposalArray)) {
                            this.adaptOffsets(nArray, stringBuffer);
                            this.installLinkedMode(iDocument, nArray, nArray2, typeArgumentProposalArray, bl);
                        } else if (bl) {
                            this.setUpLinkedMode(iDocument, ')');
                        } else {
                            this.fSelectedRegion = new Region(this.getReplacementOffset() + this.getReplacementString().length(), 0);
                        }
                    }
                    return;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        super.apply(iDocument, c, n);
    }

    protected char[] computeTriggerCharacters() {
        return GENERIC_TYPE_TRIGGERS;
    }

    private void adaptOffsets(int[] nArray, StringBuffer stringBuffer) {
        String string = this.getReplacementString();
        int n = stringBuffer.length() - string.length();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] - n;
        }
    }

    private TypeArgumentProposal[] computeTypeArgumentProposals() throws JavaModelException {
        if (this.fTypeArgumentProposals == null) {
            IType iType = (IType)this.getJavaElement();
            if (iType == null) {
                return new TypeArgumentProposal[0];
            }
            ITypeParameter[] iTypeParameterArray = iType.getTypeParameters();
            if (iTypeParameterArray.length == 0) {
                return new TypeArgumentProposal[0];
            }
            TypeArgumentProposal[] typeArgumentProposalArray = new TypeArgumentProposal[iTypeParameterArray.length];
            ITypeBinding iTypeBinding = this.getExpectedType();
            if (iTypeBinding != null && iTypeBinding.isParameterizedType()) {
                IType iType2 = (IType)iTypeBinding.getJavaElement();
                IType[] iTypeArray = this.computeInheritancePath(iType, iType2);
                if (iTypeArray == null) {
                    return new TypeArgumentProposal[0];
                }
                int[] nArray = new int[iTypeParameterArray.length];
                int n = 0;
                while (n < iTypeParameterArray.length) {
                    nArray[n] = this.mapTypeParameterIndex(iTypeArray, iTypeArray.length - 1, n);
                    ++n;
                }
                ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
                int n2 = 0;
                while (n2 < iTypeParameterArray.length) {
                    if (nArray[n2] != -1) {
                        ITypeBinding iTypeBinding2 = iTypeBindingArray[nArray[n2]];
                        typeArgumentProposalArray[n2] = this.computeTypeProposal(iTypeBinding2, iTypeParameterArray[n2]);
                    }
                    ++n2;
                }
            }
            int n = 0;
            while (n < typeArgumentProposalArray.length) {
                if (typeArgumentProposalArray[n] == null) {
                    typeArgumentProposalArray[n] = this.computeTypeProposal(iTypeParameterArray[n]);
                }
                ++n;
            }
            this.fTypeArgumentProposals = typeArgumentProposalArray;
        }
        return this.fTypeArgumentProposals;
    }

    private TypeArgumentProposal computeTypeProposal(ITypeParameter iTypeParameter) throws JavaModelException {
        String[] stringArray = iTypeParameter.getBounds();
        String string = iTypeParameter.getElementName();
        String string2 = this.computeTypeParameterDisplayName(iTypeParameter, stringArray);
        if (stringArray.length == 1 && !"java.lang.Object".equals(stringArray[0])) {
            return new TypeArgumentProposal(Signature.getSimpleName((String)stringArray[0]), true, string2);
        }
        return new TypeArgumentProposal(string, true, string2);
    }

    private String computeTypeParameterDisplayName(ITypeParameter iTypeParameter, String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length == 1 && "java.lang.Object".equals(stringArray[0])) {
            return iTypeParameter.getElementName();
        }
        StringBuffer stringBuffer = new StringBuffer(iTypeParameter.getElementName());
        stringBuffer.append(" extends ");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(Signature.getSimpleName((String)stringArray[n]));
            if (n < stringArray.length - 1) {
                stringBuffer.append(" & ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private TypeArgumentProposal computeTypeProposal(ITypeBinding iTypeBinding, ITypeParameter iTypeParameter) throws JavaModelException {
        String string = iTypeBinding.getName();
        if (iTypeBinding.isWildcardType()) {
            if (iTypeBinding.isUpperbound()) {
                String string2 = string.replaceFirst("\\?", iTypeParameter.getElementName());
                return new TypeArgumentProposal(iTypeBinding.getBound().getName(), true, string2);
            }
            return this.computeTypeProposal(iTypeParameter);
        }
        return new TypeArgumentProposal(string, false, string);
    }

    private IType[] computeInheritancePath(IType iType, IType iType2) throws JavaModelException {
        if (iType2 == null) {
            return null;
        }
        if (iType2.equals(iType)) {
            return new IType[]{iType};
        }
        ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy((IProgressMonitor)this.getProgressMonitor());
        if (!iTypeHierarchy.contains(iType2)) {
            return null;
        }
        LinkedList<IType> linkedList = new LinkedList<IType>();
        linkedList.add(iType2);
        do {
            iType2 = iTypeHierarchy.getSubtypes(iType2)[0];
            linkedList.add(iType2);
        } while (!iType2.equals(iType));
        return linkedList.toArray(new IType[linkedList.size()]);
    }

    private NullProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private int mapTypeParameterIndex(IType[] iTypeArray, int n, int n2) throws JavaModelException, ArrayIndexOutOfBoundsException {
        ITypeParameter iTypeParameter;
        if (n == 0) {
            return n2;
        }
        IType iType = iTypeArray[n];
        IType iType2 = iTypeArray[n - 1];
        String string = this.findMatchingSuperTypeSignature(iType, iType2);
        int n3 = this.findMatchingTypeArgumentIndex(string, (iTypeParameter = iType.getTypeParameters()[n2]).getElementName());
        if (n3 == -1) {
            return -1;
        }
        return this.mapTypeParameterIndex(iTypeArray, n - 1, n3);
    }

    private String findMatchingSuperTypeSignature(IType iType, IType iType2) throws JavaModelException {
        String[] stringArray = this.getSuperTypeSignatures(iType, iType2);
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2 = stringArray[n];
            String string3 = SignatureUtil.qualifySignature(string2, iType);
            String string4 = SignatureUtil.stripSignatureToFQN(string3);
            if (string4.equals(string = iType2.getFullyQualifiedName())) {
                return string2;
            }
            ++n;
        }
        throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal hierarchy", null)));
    }

    private int findMatchingTypeArgumentIndex(String string, String string2) {
        String[] stringArray = Signature.getTypeArguments((String)string);
        int n = 0;
        while (n < stringArray.length) {
            if (Signature.getSignatureSimpleName((String)stringArray[n]).equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String[] getSuperTypeSignatures(IType iType, IType iType2) throws JavaModelException {
        if (iType2.isInterface()) {
            return iType.getSuperInterfaceTypeSignatures();
        }
        return new String[]{iType.getSuperclassTypeSignature()};
    }

    private ITypeBinding getExpectedType() {
        char[][] cArray = this.fInvocationContext.getCoreContext().getExpectedTypesKeys();
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[cArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(cArray[0]);
            ++n;
        }
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setProject(this.fCompilationUnit.getJavaProject());
        aSTParser.setResolveBindings(true);
        final HashMap hashMap = new HashMap();
        ASTRequestor aSTRequestor = new ASTRequestor(){

            public void acceptBinding(String string, IBinding iBinding) {
                hashMap.put(string, iBinding);
            }
        };
        aSTParser.createASTs(new ICompilationUnit[0], stringArray, aSTRequestor, null);
        if (hashMap.size() > 0) {
            return (ITypeBinding)hashMap.get(stringArray[0]);
        }
        return null;
    }

    private boolean shouldAppendArguments(IDocument iDocument, int n, char c) {
        int n2;
        String string;
        block6: {
            if (c != '\u0000' && c != '<' && c != '(') {
                return false;
            }
            char[] cArray = this.fProposal.getCompletion();
            if (cArray.length == 0) {
                return false;
            }
            try {
                IRegion iRegion = iDocument.getLineInformationOfOffset(n);
                string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                n2 = n - iRegion.getOffset();
                while (n2 != string.length() && Character.isUnicodeIdentifierPart(string.charAt(n2))) {
                    ++n2;
                }
                if (n2 != string.length()) break block6;
                return true;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }
        char c2 = string.charAt(n2);
        return c2 != '<';
    }

    private StringBuffer createParameterList(TypeArgumentProposal[] typeArgumentProposalArray, int[] nArray, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getReplacementString());
        LazyJavaCompletionProposal.FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        if (formatterPrefs.beforeOpeningBracket) {
            stringBuffer.append(" ");
        }
        stringBuffer.append('<');
        if (formatterPrefs.afterOpeningBracket) {
            stringBuffer.append(" ");
        }
        StringBuffer stringBuffer2 = new StringBuffer(3);
        if (formatterPrefs.beforeTypeArgumentComma) {
            stringBuffer2.append(" ");
        }
        stringBuffer2.append(",");
        if (formatterPrefs.afterTypeArgumentComma) {
            stringBuffer2.append(" ");
        }
        int n = 0;
        while (n != typeArgumentProposalArray.length) {
            if (n != 0) {
                stringBuffer.append(stringBuffer2);
            }
            nArray[n] = stringBuffer.length();
            stringBuffer.append(typeArgumentProposalArray[n]);
            nArray2[n] = stringBuffer.length() - nArray[n];
            ++n;
        }
        if (formatterPrefs.beforeClosingBracket) {
            stringBuffer.append(" ");
        }
        stringBuffer.append('>');
        return stringBuffer;
    }

    private void installLinkedMode(IDocument iDocument, int[] nArray, int[] nArray2, TypeArgumentProposal[] typeArgumentProposalArray, boolean bl) {
        int n = this.getReplacementOffset();
        String string = this.getReplacementString();
        try {
            LinkedPositionGroup linkedPositionGroup;
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            int n2 = 0;
            while (n2 != nArray.length) {
                if (typeArgumentProposalArray[n2].isAmbiguous()) {
                    linkedPositionGroup = new LinkedPositionGroup();
                    linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n + nArray[n2], nArray2[n2]));
                    linkedModeModel.addGroup(linkedPositionGroup);
                }
                ++n2;
            }
            if (bl) {
                LinkedPositionGroup linkedPositionGroup2 = new LinkedPositionGroup();
                linkedPositionGroup2.addPosition(new LinkedPosition(iDocument, n + this.getCursorPosition(), 0));
                linkedModeModel.addGroup(linkedPositionGroup2);
            }
            linkedModeModel.forceInstall();
            JavaEditor javaEditor = this.getJavaEditor();
            if (javaEditor != null) {
                linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(javaEditor));
            }
            linkedPositionGroup = new EditorLinkedModeUI(linkedModeModel, this.getTextViewer());
            linkedPositionGroup.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(bl ? (char)')' : '>', iDocument));
            linkedPositionGroup.setExitPosition(this.getTextViewer(), n + string.length(), 0, Integer.MAX_VALUE);
            linkedPositionGroup.setDoContextInfo(true);
            linkedPositionGroup.enter();
            this.fSelectedRegion = linkedPositionGroup.getSelectedRegion();
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            this.openErrorDialog(badLocationException);
        }
    }

    private boolean hasAmbiguousProposals(TypeArgumentProposal[] typeArgumentProposalArray) {
        boolean bl = false;
        int n = 0;
        while (n < typeArgumentProposalArray.length) {
            if (typeArgumentProposalArray[n].isAmbiguous()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private JavaEditor getJavaEditor() {
        IEditorPart iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof JavaEditor) {
            return (JavaEditor)iEditorPart;
        }
        return null;
    }

    public Point getSelection(IDocument iDocument) {
        if (this.fSelectedRegion == null) {
            return super.getSelection(iDocument);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException badLocationException) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.FilledArgumentNamesMethodProposal_error_msg, (String)badLocationException.getMessage());
    }

    protected IContextInformation computeContextInformation() {
        try {
            TypeArgumentProposal[] typeArgumentProposalArray;
            if (this.hasParameters() && this.hasAmbiguousProposals(typeArgumentProposalArray = this.computeTypeArgumentProposals())) {
                return new ContextInformation(this);
            }
        }
        catch (JavaModelException javaModelException) {}
        return super.computeContextInformation();
    }

    protected int computeCursorPosition() {
        if (this.fSelectedRegion != null) {
            return this.fSelectedRegion.getOffset() - this.getReplacementOffset();
        }
        return super.computeCursorPosition();
    }

    private boolean hasParameters() {
        IType iType;
        block3: {
            try {
                iType = (IType)this.getJavaElement();
                if (iType != null) break block3;
                return false;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return iType.getTypeParameters().length > 0;
    }

    private static class ContextInformation
    implements IContextInformation,
    IContextInformationExtension {
        private final String fInformationDisplayString;
        private final String fContextDisplayString;
        private final Image fImage;
        private final int fPosition;

        ContextInformation(LazyGenericTypeProposal lazyGenericTypeProposal) {
            this.fContextDisplayString = lazyGenericTypeProposal.getDisplayString();
            this.fInformationDisplayString = this.computeContextString(lazyGenericTypeProposal);
            this.fImage = lazyGenericTypeProposal.getImage();
            this.fPosition = lazyGenericTypeProposal.getReplacementOffset() + lazyGenericTypeProposal.getReplacementString().indexOf(60) + 1;
        }

        public String getContextDisplayString() {
            return this.fContextDisplayString;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getInformationDisplayString() {
            return this.fInformationDisplayString;
        }

        private String computeContextString(LazyGenericTypeProposal lazyGenericTypeProposal) {
            TypeArgumentProposal[] typeArgumentProposalArray;
            block5: {
                typeArgumentProposalArray = lazyGenericTypeProposal.computeTypeArgumentProposals();
                if (typeArgumentProposalArray.length != 0) break block5;
                return null;
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < typeArgumentProposalArray.length) {
                    stringBuffer.append(typeArgumentProposalArray[n].getDisplayName());
                    if (n < typeArgumentProposalArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformation) {
                ContextInformation contextInformation = (ContextInformation)object;
                return this.getContextInformationPosition() == contextInformation.getContextInformationPosition() && this.getInformationDisplayString().equals(contextInformation.getInformationDisplayString());
            }
            return false;
        }
    }

    private static final class TypeArgumentProposal {
        private final boolean fIsAmbiguous;
        private final String fProposal;
        private final String fTypeDisplayName;

        TypeArgumentProposal(String string, boolean bl, String string2) {
            this.fIsAmbiguous = bl;
            this.fProposal = string;
            this.fTypeDisplayName = string2;
        }

        public String getDisplayName() {
            return this.fTypeDisplayName;
        }

        boolean isAmbiguous() {
            return this.fIsAmbiguous;
        }

        String getProposals() {
            return this.fProposal;
        }

        public String toString() {
            return this.fProposal;
        }
    }
}

