/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class ParameterGuessingProposal
extends JavaMethodCompletionProposal {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;

    public ParameterGuessingProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(completionProposal, javaContentAssistInvocationContext);
    }

    public void apply(IDocument iDocument, char c, int n) {
        try {
            super.apply(iDocument, c, n);
            int n2 = this.getReplacementOffset();
            String string = this.getReplacementString();
            if (this.fPositions != null && this.getTextViewer() != null) {
                LinkedPositionGroup linkedPositionGroup;
                LinkedModeModel linkedModeModel = new LinkedModeModel();
                int n3 = 0;
                while (n3 < this.fPositions.length) {
                    linkedPositionGroup = new LinkedPositionGroup();
                    int n4 = this.fPositions[n3].getOffset();
                    int n5 = this.fPositions[n3].getLength();
                    if (this.fChoices[n3].length < 2) {
                        linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n4, n5, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(iDocument, linkedModeModel);
                        iDocument.addPosition(this.getCategory(), this.fPositions[n3]);
                        linkedPositionGroup.addPosition((LinkedPosition)new ProposalPosition(iDocument, n4, n5, -1, this.fChoices[n3]));
                    }
                    linkedModeModel.addGroup(linkedPositionGroup);
                    ++n3;
                }
                linkedModeModel.forceInstall();
                JavaEditor javaEditor = this.getJavaEditor();
                if (javaEditor != null) {
                    linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(javaEditor));
                }
                linkedPositionGroup = new EditorLinkedModeUI(linkedModeModel, this.getTextViewer());
                linkedPositionGroup.setExitPosition(this.getTextViewer(), n2 + string.length(), 0, Integer.MAX_VALUE);
                linkedPositionGroup.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', iDocument));
                linkedPositionGroup.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                linkedPositionGroup.setDoContextInfo(true);
                linkedPositionGroup.enter();
                this.fSelectedRegion = linkedPositionGroup.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(n2 + string.length(), 0);
            }
        }
        catch (BadLocationException badLocationException) {
            this.ensurePositionCategoryRemoved(iDocument);
            JavaPlugin.log(badLocationException);
            this.openErrorDialog((Exception)((Object)badLocationException));
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            this.ensurePositionCategoryRemoved(iDocument);
            JavaPlugin.log(badPositionCategoryException);
            this.openErrorDialog((Exception)((Object)badPositionCategoryException));
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        String string;
        if (!this.hasParameters() || !this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        long l = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            string = this.computeGuessingCompletion();
        }
        catch (JavaModelException javaModelException) {
            this.fPositions = null;
            this.fChoices = null;
            JavaPlugin.log(javaModelException);
            this.openErrorDialog((Exception)((Object)javaModelException));
            return super.computeReplacementString();
        }
        if (DEBUG) {
            System.err.println("Parameter Guessing: " + (System.currentTimeMillis() - l));
        }
        return string;
    }

    private String computeGuessingCompletion() throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.fProposal.getName()));
        LazyJavaCompletionProposal.FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        if (formatterPrefs.beforeOpeningParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("(");
        this.setCursorPosition(stringBuffer.length());
        if (formatterPrefs.afterOpeningParen) {
            stringBuffer.append(" ");
        }
        this.fChoices = this.guessParameters();
        int n = this.fChoices.length;
        int n2 = this.getReplacementOffset();
        int n3 = 0;
        while (n3 < n) {
            if (n3 != 0) {
                if (formatterPrefs.beforeComma) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(",");
                if (formatterPrefs.afterComma) {
                    stringBuffer.append(" ");
                }
            }
            ICompletionProposal iCompletionProposal = this.fChoices[n3][0];
            String string = iCompletionProposal.getDisplayString();
            Position position = this.fPositions[n3];
            position.setOffset(n2 + stringBuffer.length());
            position.setLength(string.length());
            if (iCompletionProposal instanceof JavaCompletionProposal) {
                ((JavaCompletionProposal)iCompletionProposal).setReplacementOffset(n2 + stringBuffer.length());
            }
            stringBuffer.append(string);
            ++n3;
        }
        if (formatterPrefs.beforeClosingParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof JavaEditor) {
            return (JavaEditor)iEditorPart;
        }
        return null;
    }

    private ICompletionProposal[][] guessParameters() throws JavaModelException {
        char[][] cArray = this.fProposal.findParameterNames(null);
        int n = cArray.length;
        this.fPositions = new Position[n];
        this.fChoices = new ICompletionProposal[n][];
        IDocument iDocument = this.fInvocationContext.getDocument();
        ICompilationUnit iCompilationUnit = this.fInvocationContext.getCompilationUnit();
        JavaModelUtil.reconcile(iCompilationUnit);
        String[][] stringArray = this.getParameterSignatures();
        ParameterGuesser parameterGuesser = new ParameterGuesser(this.fProposal.getCompletionLocation() + 1, iCompilationUnit);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = new String(cArray[n2]);
            Position position = new Position(0, 0);
            ICompletionProposal[] iCompletionProposalArray = parameterGuesser.parameterProposals(stringArray[n2][0], stringArray[n2][1], string, position, iDocument);
            if (iCompletionProposalArray.length == 0) {
                iCompletionProposalArray = new ICompletionProposal[]{new JavaCompletionProposal(string, 0, string.length(), null, string, 0)};
            }
            this.fPositions[n2] = position;
            this.fChoices[n2] = iCompletionProposalArray;
            --n2;
        }
        return this.fChoices;
    }

    private String[][] getParameterSignatures() {
        char[] cArray = SignatureUtil.fix83600(this.fProposal.getSignature());
        char[][] cArray2 = Signature.getParameterTypes((char[])cArray);
        String[][] stringArray = new String[cArray2.length][2];
        int n = 0;
        while (n < cArray2.length) {
            char[] cArray3 = SignatureUtil.getLowerBound(cArray2[n]);
            stringArray[n][0] = String.valueOf(Signature.getSignatureQualifier((char[])cArray3));
            stringArray[n][1] = String.valueOf(Signature.getSignatureSimpleName((char[])cArray3));
            ++n;
        }
        return stringArray;
    }

    public Point getSelection(IDocument iDocument) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception exception) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.ParameterGuessingProposal_error_msg, (String)exception.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument iDocument, LinkedModeModel linkedModeModel) {
        if (!iDocument.containsPositionCategory(this.getCategory())) {
            iDocument.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            iDocument.addPositionUpdater(this.fUpdater);
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel linkedModeModel, int n) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(iDocument);
                }

                public void suspend(LinkedModeModel linkedModeModel) {
                }

                public void resume(LinkedModeModel linkedModeModel, int n) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument iDocument) {
        if (iDocument.containsPositionCategory(this.getCategory())) {
            try {
                iDocument.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            iDocument.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }
}

