/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AnnotationExpansionControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    protected AnnotationHoverInput fInput;
    private Shell fShell;
    protected Composite fComposite;
    private Cursor fHandCursor;
    private Item fSelection;
    private HoverManager fHoverManager;
    private IAnnotationAccessExtension fAnnotationAccessExtension;
    private final MyPaintListener fPaintListener = new MyPaintListener();
    private final MyMouseTrackListener fMouseTrackListener = new MyMouseTrackListener();
    private final MyMouseListener fMouseListener = new MyMouseListener();
    private final MyMenuDetectListener fMenuDetectListener = new MyMenuDetectListener();
    private final DisposeListener fDisposeListener = new MyDisposeListener();
    private final IViewportListener fViewportListener = new IViewportListener(){

        public void viewportChanged(int n) {
            AnnotationExpansionControl.this.dispose();
        }
    };
    private LinearLayouter fLayouter = new LinearLayouter();

    public AnnotationExpansionControl(Shell shell, int n, IAnnotationAccess iAnnotationAccess) {
        if (iAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.fAnnotationAccessExtension = (IAnnotationAccessExtension)iAnnotationAccess;
        }
        this.fShell = new Shell(shell, n | 0x80000 | 0x4000);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 0x180008);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fShell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.fLayouter.getAnnotationSize() + 2 * this.fLayouter.getBorderWidth() + 4;
        this.fComposite.setLayoutData((Object)gridData);
        this.fComposite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                if (AnnotationExpansionControl.this.fComposite == null) {
                    return;
                }
                Control[] controlArray = AnnotationExpansionControl.this.fComposite.getChildren();
                Rectangle rectangle = null;
                int n = 0;
                while (n < controlArray.length) {
                    if (rectangle == null) {
                        rectangle = controlArray[n].getBounds();
                    } else {
                        rectangle.add(controlArray[n].getBounds());
                    }
                    if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                        return;
                    }
                    ++n;
                }
                AnnotationExpansionControl.this.dispose();
            }
        });
        this.fHandCursor = new Cursor((Device)display, 21);
        this.fShell.setCursor(this.fHandCursor);
        this.fComposite.setCursor(this.fHandCursor);
        this.setInfoSystemColor();
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    public void setInformation(String string) {
        this.setInput(null);
    }

    public void setInput(Object object) {
        if (this.fInput != null && this.fInput.fViewer != null) {
            this.fInput.fViewer.removeViewportListener(this.fViewportListener);
        }
        this.fInput = object instanceof AnnotationHoverInput ? (AnnotationHoverInput)object : null;
        this.inputChanged(this.fInput, null);
    }

    protected void inputChanged(Object object, Object object2) {
        this.refresh();
    }

    protected void refresh() {
        this.adjustItemNumber();
        if (this.fInput == null) {
            return;
        }
        if (this.fInput.fAnnotations == null) {
            return;
        }
        if (this.fInput.fViewer != null) {
            this.fInput.fViewer.addViewportListener(this.fViewportListener);
        }
        this.fShell.setRegion(this.fLayouter.getShellRegion(this.fInput.fAnnotations.length));
        Layout layout = this.fLayouter.getLayout(this.fInput.fAnnotations.length);
        this.fComposite.setLayout(layout);
        Control[] controlArray = this.fComposite.getChildren();
        int n = 0;
        while (n < this.fInput.fAnnotations.length) {
            Canvas canvas = (Canvas)controlArray[n];
            Item item = new Item();
            item.canvas = canvas;
            item.fAnnotation = this.fInput.fAnnotations[n];
            canvas.setData((Object)item);
            canvas.redraw();
            ++n;
        }
    }

    protected void adjustItemNumber() {
        Object object;
        if (this.fComposite == null) {
            return;
        }
        Control[] controlArray = this.fComposite.getChildren();
        int n = controlArray.length;
        int n2 = this.fInput == null ? 0 : this.fInput.fAnnotations.length;
        Display display = this.fShell.getDisplay();
        int n3 = n;
        while (n3 < n2) {
            object = new Canvas(this.fComposite, 0);
            Object object2 = this.fLayouter.getLayoutData();
            object.setLayoutData(object2);
            object.setBackground(display.getSystemColor(29));
            object.addPaintListener((PaintListener)this.fPaintListener);
            object.addMouseTrackListener((MouseTrackListener)this.fMouseTrackListener);
            object.addMouseListener((MouseListener)this.fMouseListener);
            object.addListener(35, (Listener)this.fMenuDetectListener);
            object.addDisposeListener(this.fDisposeListener);
            ++n3;
        }
        n3 = n;
        while (n3 > n2) {
            object = (Item)controlArray[n3 - 1].getData();
            ((Item)object).deselect();
            controlArray[n3 - 1].dispose();
            --n3;
        }
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fComposite = null;
            if (this.fHandCursor != null) {
                this.fHandCursor.dispose();
            }
            this.fHandCursor = null;
            if (this.fHoverManager != null) {
                this.fHoverManager.dispose();
            }
            this.fHoverManager = null;
            this.fSelection = null;
        }
    }

    public boolean hasContents() {
        return this.fInput.fAnnotations != null && this.fInput.fAnnotations.length > 0;
    }

    public void setSizeConstraints(int n, int n2) {
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    public void setSize(int n, int n2) {
        this.fShell.setSize(n, n2);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fComposite.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fComposite.setBackground(color);
    }

    public boolean isFocusControl() {
        if (this.fComposite.isFocusControl()) {
            return true;
        }
        Control[] controlArray = this.fComposite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n].isFocusControl()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setFocus() {
        this.fShell.forceFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fShell.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fShell.removeFocusListener(focusListener);
    }

    private StyleRange[] setViewerBackground(Annotation annotation) {
        StyleRange styleRange;
        StyledText styledText = this.fInput.fViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return null;
        }
        Display display = styledText.getDisplay();
        Position position = this.fInput.model.getPosition(annotation);
        if (position == null) {
            return null;
        }
        IRegion iRegion = ((TextViewer)this.fInput.fViewer).modelRange2WidgetRange((IRegion)new org.eclipse.jface.text.Region(position.offset, position.length));
        if (iRegion == null) {
            return null;
        }
        StyleRange[] styleRangeArray = styledText.getStyleRanges(iRegion.getOffset(), iRegion.getLength());
        ArrayList<Object> arrayList = new ArrayList<Object>(styleRangeArray.length);
        int n = 0;
        while (n < styleRangeArray.length) {
            arrayList.add(styleRangeArray[n].clone());
            ++n;
        }
        n = iRegion.getOffset();
        StyleRange styleRange2 = arrayList.size() > 0 ? (StyleRange)arrayList.get(0) : null;
        int n2 = styleRange2 != null ? styleRange2.start : iRegion.getOffset() + iRegion.getLength();
        int n3 = styleRange2 != null ? styleRange2.start + styleRange2.length : -1;
        int n4 = 0;
        while (n3 < iRegion.getOffset() + iRegion.getLength()) {
            if (n2 > n) {
                styleRange = new StyleRange(n, n2 - n, null, null);
                arrayList.add(n4, styleRange);
                ++n4;
            }
            if (++n4 < arrayList.size()) {
                n = n3;
                styleRange2 = (StyleRange)arrayList.get(n4);
                n2 = styleRange2.start;
                n3 = styleRange2.start + styleRange2.length;
                continue;
            }
            if (n4 == arrayList.size()) {
                n = n3;
                styleRange2 = null;
                n2 = iRegion.getOffset() + iRegion.getLength();
                n3 = -1;
                continue;
            }
            n3 = iRegion.getOffset() + iRegion.getLength();
        }
        styleRange = new ArrayList(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            StyleRange styleRange3 = (StyleRange)((StyleRange)iterator.next()).clone();
            styleRange.add(styleRange3);
            styleRange3.background = this.getHighlightColor(display);
        }
        iterator = styleRange.iterator();
        while (iterator.hasNext()) {
            styledText.setStyleRange((StyleRange)iterator.next());
        }
        return arrayList.toArray(arrayList.toArray(new StyleRange[0]));
    }

    private void resetViewerBackground(StyleRange[] styleRangeArray) {
        if (styleRangeArray == null) {
            return;
        }
        if (this.fInput == null) {
            return;
        }
        StyledText styledText = this.fInput.fViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = 0;
        while (n < styleRangeArray.length) {
            styledText.setStyleRange(styleRangeArray[n]);
            ++n;
        }
    }

    private Color getHighlightColor(Display display) {
        return display.getSystemColor(15);
    }

    private Color getSelectionColor(Display display) {
        return display.getSystemColor(15);
    }

    public static class AnnotationHoverInput {
        public Annotation[] fAnnotations;
        public ISourceViewer fViewer;
        public IVerticalRulerInfo fRulerInfo;
        public IVerticalRulerListener fAnnotationListener;
        public IDoubleClickListener fDoubleClickListener;
        public ICallback redoAction;
        public IAnnotationModel model;
    }

    private final class HoverManager
    extends AbstractInformationControlManager {
        public HoverManager() {
            super(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new DefaultInformationControl(shell);
                }
            });
            this.setMargins(5, 10);
            this.setAnchor(ANCHOR_BOTTOM);
            this.setFallbackAnchors(new AbstractInformationControlManager.Anchor[]{ANCHOR_BOTTOM, ANCHOR_LEFT, ANCHOR_RIGHT});
        }

        protected void computeInformation() {
            if (AnnotationExpansionControl.this.fSelection != null) {
                Rectangle rectangle = ((AnnotationExpansionControl)AnnotationExpansionControl.this).fSelection.canvas.getBounds();
                Annotation annotation = ((AnnotationExpansionControl)AnnotationExpansionControl.this).fSelection.fAnnotation;
                String string = annotation != null ? annotation.getText() : null;
                this.setInformation(string, rectangle);
            }
        }
    }

    public static interface ICallback {
        public void run(IInformationControlExtension2 var1);
    }

    private final class Item {
        Annotation fAnnotation;
        Canvas canvas;
        StyleRange[] oldStyles;

        private Item() {
        }

        public void selected() {
            Display display = AnnotationExpansionControl.this.fShell.getDisplay();
            this.canvas.setCursor(AnnotationExpansionControl.this.fHandCursor);
            this.canvas.setBackground(AnnotationExpansionControl.this.getSelectionColor(display));
            this.oldStyles = AnnotationExpansionControl.this.setViewerBackground(this.fAnnotation);
            AnnotationExpansionControl.this.fSelection = this;
            if (AnnotationExpansionControl.this.fHoverManager != null) {
                AnnotationExpansionControl.this.fHoverManager.showInformation();
            }
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent verticalRulerEvent = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationSelected(verticalRulerEvent);
            }
        }

        public void defaultSelected() {
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent verticalRulerEvent = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationDefaultSelected(verticalRulerEvent);
            }
            AnnotationExpansionControl.this.dispose();
        }

        public void showContextMenu(Menu menu) {
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent verticalRulerEvent = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationContextMenuAboutToShow(verticalRulerEvent, menu);
            }
        }

        public void deselect() {
            AnnotationExpansionControl.this.fSelection = null;
            AnnotationExpansionControl.this.resetViewerBackground(this.oldStyles);
            this.oldStyles = null;
            Display display = AnnotationExpansionControl.this.fShell.getDisplay();
            this.canvas.setCursor(null);
            this.canvas.setBackground(display.getSystemColor(29));
        }
    }

    public class LinearLayouter {
        private static final int ANNOTATION_SIZE = 14;
        private static final int BORDER_WIDTH = 2;

        public Layout getLayout(int n) {
            GridLayout gridLayout = new GridLayout(n, true);
            gridLayout.horizontalSpacing = 1;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginHeight = 1;
            gridLayout.marginWidth = 1;
            return gridLayout;
        }

        public Object getLayoutData() {
            GridData gridData = new GridData(18, 18);
            gridData.horizontalAlignment = 2;
            gridData.verticalAlignment = 2;
            return gridData;
        }

        public int getAnnotationSize() {
            return 14;
        }

        public int getBorderWidth() {
            return 2;
        }

        public Region getShellRegion(int n) {
            return null;
        }
    }

    private static final class MyDisposeListener
    implements DisposeListener {
        private MyDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            Item item = (Item)((Widget)disposeEvent.getSource()).getData();
            item.deselect();
            item.canvas = null;
            item.fAnnotation = null;
            item.oldStyles = null;
            ((Widget)disposeEvent.getSource()).setData(null);
        }
    }

    private final class MyMenuDetectListener
    implements Listener {
        private MyMenuDetectListener() {
        }

        public void handleEvent(Event event) {
            Menu menu;
            Control control;
            if (event.type == 35 && AnnotationExpansionControl.this.fInput != null && (control = AnnotationExpansionControl.this.fInput.fRulerInfo.getControl()) != null && !control.isDisposed() && (menu = control.getMenu()) != null && !menu.isDisposed()) {
                menu.setLocation(event.x, event.y);
                menu.addMenuListener(new MenuListener(this){
                    final /* synthetic */ MyMenuDetectListener this$1;
                    {
                        this.this$1 = myMenuDetectListener;
                    }

                    public void menuHidden(MenuEvent menuEvent) {
                        MyMenuDetectListener.access$1(this.this$1).dispose();
                    }

                    public void menuShown(MenuEvent menuEvent) {
                    }
                });
                menu.setVisible(true);
            }
        }

        static /* synthetic */ AnnotationExpansionControl access$1(MyMenuDetectListener myMenuDetectListener) {
            return myMenuDetectListener.AnnotationExpansionControl.this;
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            Item item = (Item)((Widget)mouseEvent.getSource()).getData();
            if (mouseEvent.button == 1 && item.fAnnotation == AnnotationExpansionControl.this.fInput.fAnnotations[0] && AnnotationExpansionControl.this.fInput.fDoubleClickListener != null) {
                AnnotationExpansionControl.this.fInput.fDoubleClickListener.doubleClick(null);
                if (AnnotationExpansionControl.this.fInput.redoAction != null) {
                    AnnotationExpansionControl.this.fInput.redoAction.run(AnnotationExpansionControl.this);
                }
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Item item = (Item)((Widget)mouseEvent.getSource()).getData();
            if (item != null && mouseEvent.button == 1) {
                item.defaultSelected();
            }
        }
    }

    private final class MyMouseTrackListener
    implements MouseTrackListener {
        private MyMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            Item item = (Item)((Widget)mouseEvent.getSource()).getData();
            if (item != null) {
                item.selected();
            }
        }

        public void mouseExit(MouseEvent mouseEvent) {
            Item item = (Item)((Widget)mouseEvent.getSource()).getData();
            if (item != null) {
                item.deselect();
            }
            Region region = AnnotationExpansionControl.this.fShell.getRegion();
            Canvas canvas = (Canvas)mouseEvent.getSource();
            Point point = canvas.toDisplay(mouseEvent.x, mouseEvent.y);
            if (region == null) {
                Rectangle rectangle = AnnotationExpansionControl.this.fShell.getBounds();
                if (!rectangle.contains(point)) {
                    AnnotationExpansionControl.this.dispose();
                }
            } else {
                point = AnnotationExpansionControl.this.fShell.toControl(point);
                if (!region.contains(point)) {
                    AnnotationExpansionControl.this.dispose();
                }
            }
        }

        public void mouseHover(MouseEvent mouseEvent) {
            if (AnnotationExpansionControl.this.fHoverManager == null) {
                AnnotationExpansionControl.this.fHoverManager = new HoverManager();
                AnnotationExpansionControl.this.fHoverManager.takesFocusWhenVisible(false);
                AnnotationExpansionControl.this.fHoverManager.install((Control)AnnotationExpansionControl.this.fComposite);
                AnnotationExpansionControl.this.fHoverManager.showInformation();
            }
        }
    }

    private final class MyPaintListener
    implements PaintListener {
        private MyPaintListener() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Canvas canvas = (Canvas)paintEvent.getSource();
            Annotation annotation = ((Item)canvas.getData()).fAnnotation;
            if (annotation != null) {
                Rectangle rectangle = new Rectangle(AnnotationExpansionControl.this.fLayouter.getBorderWidth(), AnnotationExpansionControl.this.fLayouter.getBorderWidth(), AnnotationExpansionControl.this.fLayouter.getAnnotationSize(), AnnotationExpansionControl.this.fLayouter.getAnnotationSize());
                if (AnnotationExpansionControl.this.fAnnotationAccessExtension != null) {
                    AnnotationExpansionControl.this.fAnnotationAccessExtension.paint(annotation, paintEvent.gc, canvas, rectangle);
                }
            }
        }
    }
}

