/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavadocContentAccess;

public class JavadocHover
extends AbstractJavaEditorTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_FLAGS = this.LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator();
        }
        return this.fHoverControlCreator;
    }

    protected String getHoverInfo(IJavaElement[] iJavaElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = iJavaElementArray.length;
        if (n == 0) {
            return null;
        }
        boolean bl = false;
        if (n > 1) {
            int n2 = 0;
            while (n2 < iJavaElementArray.length) {
                HTMLPrinter.startBulletList((StringBuffer)stringBuffer);
                IJavaElement iJavaElement = iJavaElementArray[n2];
                if (iJavaElement instanceof IMember || iJavaElement.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuffer)stringBuffer, (String)this.getInfoText(iJavaElement));
                    bl = true;
                }
                HTMLPrinter.endBulletList((StringBuffer)stringBuffer);
                ++n2;
            }
        } else {
            IJavaElement iJavaElement = iJavaElementArray[0];
            if (iJavaElement instanceof IMember) {
                Reader reader;
                IMember iMember = (IMember)iJavaElement;
                HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)this.getInfoText((IJavaElement)iMember));
                try {
                    reader = JavadocContentAccess.getHTMLContentReader(iMember, true, true);
                    if (reader == null && iMember.isBinary()) {
                        boolean bl2;
                        boolean bl3 = JavaDocLocations.getJavadocBaseLocation((IJavaElement)iMember) != null;
                        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iMember.getAncestor(3);
                        boolean bl4 = iPackageFragmentRoot != null && iPackageFragmentRoot.getSourceAttachmentPath() != null;
                        IOpenable iOpenable = iMember.getOpenable();
                        boolean bl5 = bl2 = iOpenable.getBuffer() != null;
                        if (!bl4 && !bl3) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachments);
                        } else if (!bl3 && !bl2) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedJavadoc);
                        } else if (!bl4) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedSource);
                        } else if (!bl2) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noInformation);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    reader = new StringReader(JavaHoverMessages.JavadocHover_error_gettingJavadoc);
                    JavaPlugin.log(javaModelException.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)stringBuffer, (Reader)reader);
                }
                bl = true;
            } else if (iJavaElement.getElementType() == 14 || iJavaElement.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuffer)stringBuffer, (String)this.getInfoText(iJavaElement));
                bl = true;
            }
        }
        if (!bl) {
            return null;
        }
        if (stringBuffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0, (String)JavadocHover.getStyleSheet());
            HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
            return stringBuffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement iJavaElement) {
        long l = iJavaElement.getElementType() == 14 ? this.LOCAL_VARIABLE_FLAGS : this.LABEL_FLAGS;
        String string = JavaElementLabels.getElementLabel(iJavaElement, l);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private HoverControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                return new BrowserInformationControl(shell, 12, 0, EditorsUI.getTooltipAffordanceString());
            }
            return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
        }

        public boolean canReuse(IInformationControl iInformationControl) {
            if (!super.canReuse(iInformationControl)) {
                return false;
            }
            if (iInformationControl instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)iInformationControl).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            int n = 20;
            int n2 = 768;
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                return new BrowserInformationControl(shell, n, n2);
            }
            return new DefaultInformationControl(shell, n, n2, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }
}

