/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaSpellingEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaSpellingProblem;

public class JavaSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    protected ISpellingEngine spellingEngine = new JavaSpellingEngine();
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IProblemRequestor fRequestor;
    private ISourceViewer fViewer;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private SpellingService fSpellingService;
    private ISpellingProblemCollector fSpellingProblemCollector;
    private SpellingContext fSpellingContext;

    public JavaSpellingReconcileStrategy(ISourceViewer iSourceViewer, ITextEditor iTextEditor) {
        Assert.isNotNull((Object)iSourceViewer);
        this.fViewer = iSourceViewer;
        this.fSpellingContext = new SpellingContext();
        this.fEditor = iTextEditor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(IRegion iRegion) {
        if (this.fRequestor == null) return;
        if (!this.isSpellingEnabled()) return;
        if (this.getAnnotationModel() == null) return;
        if (this.fSpellingProblemCollector == null) {
            return;
        }
        try {
            this.fSpellingProblemCollector.beginCollecting();
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    JavaSpellingReconcileStrategy.this.spellingEngine.check(JavaSpellingReconcileStrategy.this.fDocument, new IRegion[]{new Region(0, JavaSpellingReconcileStrategy.this.fDocument.getLength())}, JavaSpellingReconcileStrategy.this.fSpellingContext, JavaSpellingReconcileStrategy.this.fSpellingProblemCollector, JavaSpellingReconcileStrategy.this.fProgressMonitor);
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fSpellingProblemCollector.endCollecting();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fSpellingProblemCollector.endCollecting();
    }

    public void setDocument(IDocument iDocument) {
        this.fDocument = iDocument;
        this.fSpellingProblemCollector = this.createSpellingProblemCollector();
        this.updateProblemRequester();
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        return new SpellingProblemCollector();
    }

    private void updateProblemRequester() {
        IAnnotationModel iAnnotationModel = this.getAnnotationModel();
        this.fRequestor = iAnnotationModel instanceof IProblemRequestor ? (IProblemRequestor)iAnnotationModel : null;
    }

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
        if (iDocumentProvider == null) {
            return null;
        }
        return iDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion iRegion) {
        this.reconcile(iRegion);
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem spellingProblem) {
            IProblemRequestor iProblemRequestor = JavaSpellingReconcileStrategy.this.fRequestor;
            if (iProblemRequestor != null) {
                try {
                    IEditorInput iEditorInput;
                    int n = JavaSpellingReconcileStrategy.this.fDocument.getLineOfOffset(spellingProblem.getOffset()) + 1;
                    String string = JavaSpellingReconcileStrategy.this.fDocument.get(spellingProblem.getOffset(), spellingProblem.getLength());
                    boolean bl = false;
                    boolean bl2 = false;
                    if (spellingProblem instanceof JavaSpellingProblem) {
                        bl = ((JavaSpellingProblem)spellingProblem).isDictionaryMatch();
                        bl2 = ((JavaSpellingProblem)spellingProblem).isSentenceStart();
                    }
                    if ((iEditorInput = JavaSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem coreSpellingProblem = new CoreSpellingProblem(spellingProblem.getOffset(), spellingProblem.getOffset() + spellingProblem.getLength() - 1, n, spellingProblem.getMessage(), string, bl, bl2, JavaSpellingReconcileStrategy.this.fDocument, iEditorInput.getName());
                        iProblemRequestor.acceptProblem((IProblem)coreSpellingProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

