/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import com.ibm.icu.text.BreakIterator;
import java.util.LinkedList;
import java.util.Locale;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.IHtmlTagConstants;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.IJavaDocTagConstants;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckIterator;

public class SpellCheckIterator
implements ISpellCheckIterator {
    protected final String fContent;
    private final String fDelimiter;
    protected String fLastToken = null;
    protected int fNext = 1;
    protected final int fOffset;
    private int fPredecessor;
    protected int fPrevious = 0;
    private final LinkedList fSentenceBreaks = new LinkedList();
    private boolean fStartsSentence = false;
    protected int fSuccessor;
    private final BreakIterator fWordIterator;
    private boolean fIsIgnoringSingleLetters;

    public SpellCheckIterator(IDocument iDocument, IRegion iRegion, Locale locale) {
        this(iDocument, iRegion, locale, BreakIterator.getWordInstance((Locale)locale));
    }

    public SpellCheckIterator(IDocument iDocument, IRegion iRegion, Locale locale, BreakIterator breakIterator) {
        String string;
        this.fOffset = iRegion.getOffset();
        this.fWordIterator = breakIterator;
        this.fDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        try {
            string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            if (string.startsWith("//$NON-NLS-")) {
                string = "";
            }
        }
        catch (Exception exception) {
            string = "";
        }
        this.fContent = string;
        this.fWordIterator.setText(string);
        this.fPredecessor = this.fWordIterator.first();
        this.fSuccessor = this.fWordIterator.next();
        BreakIterator breakIterator2 = BreakIterator.getSentenceInstance((Locale)locale);
        breakIterator2.setText(string);
        int n = breakIterator2.current();
        while (n != -1) {
            this.fSentenceBreaks.add(new Integer(n));
            n = breakIterator2.next();
        }
    }

    public void setIgnoreSingleLetters(boolean bl) {
        this.fIsIgnoringSingleLetters = bl;
    }

    public final int getBegin() {
        return this.fPrevious + this.fOffset;
    }

    public final int getEnd() {
        return this.fNext + this.fOffset - 1;
    }

    public final boolean hasNext() {
        return this.fSuccessor != -1;
    }

    protected final boolean isAlphaNumeric(int n, int n2) {
        char c = '\u0000';
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            c = this.fContent.charAt(n3);
            if (Character.isLetter(c)) {
                bl = true;
            }
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n3;
        }
        return bl;
    }

    protected final boolean isToken(String[] stringArray) {
        return this.isToken(this.fLastToken, stringArray);
    }

    protected final boolean isToken(String string, String[] stringArray) {
        if (string != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected final boolean isSingleLetter(int n) {
        if (!Character.isLetter(this.fContent.charAt(n))) {
            return false;
        }
        if (n > 0 && !Character.isWhitespace(this.fContent.charAt(n - 1))) {
            return false;
        }
        return n >= this.fContent.length() - 1 || Character.isWhitespace(this.fContent.charAt(n + 1));
    }

    protected final boolean isUrlToken(int n) {
        int n2 = 0;
        while (n2 < DefaultSpellChecker.URL_PREFIXES.length) {
            if (this.fContent.startsWith(DefaultSpellChecker.URL_PREFIXES[n2], n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final boolean isWhitespace(int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (!Character.isWhitespace(this.fContent.charAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public Object next() {
        String string = this.nextToken();
        while (string == null && this.fSuccessor != -1) {
            string = this.nextToken();
        }
        this.fLastToken = string;
        return string;
    }

    protected final void nextBreak() {
        this.fNext = this.fSuccessor;
        this.fPredecessor = this.fSuccessor;
        this.fSuccessor = this.fWordIterator.next();
    }

    protected final int nextSentence() {
        return (Integer)this.fSentenceBreaks.getFirst();
    }

    protected String nextToken() {
        String string = null;
        this.fPrevious = this.fPredecessor;
        this.fStartsSentence = false;
        this.nextBreak();
        boolean bl = false;
        if (this.fNext - this.fPrevious > 0) {
            if (this.fSuccessor != -1 && this.fContent.charAt(this.fPrevious) == '@') {
                this.nextBreak();
                if (Character.isLetter(this.fContent.charAt(this.fPrevious + 1))) {
                    bl = true;
                    string = this.fContent.substring(this.fPrevious, this.fNext);
                } else {
                    this.fPredecessor = this.fNext;
                }
            } else if (this.fSuccessor != -1 && this.fContent.charAt(this.fPrevious) == '<' && (Character.isLetter(this.fContent.charAt(this.fNext)) || this.fContent.charAt(this.fNext) == '/')) {
                if (this.fContent.startsWith("</", this.fPrevious)) {
                    this.nextBreak();
                }
                this.nextBreak();
                if (this.fSuccessor != -1 && this.fContent.charAt(this.fNext) == '>') {
                    this.nextBreak();
                    if (this.fSuccessor != -1) {
                        bl = true;
                        string = this.fContent.substring(this.fPrevious, this.fNext);
                    }
                }
            } else if (this.fSuccessor != -1 && this.fContent.charAt(this.fPrevious) == '&' && Character.isLetter(this.fContent.charAt(this.fNext))) {
                this.nextBreak();
                if (this.fSuccessor != -1 && this.fContent.charAt(this.fNext) == ';') {
                    this.nextBreak();
                    if (this.isToken(this.fContent.substring(this.fPrevious, this.fNext), IHtmlTagConstants.HTML_ENTITY_CODES)) {
                        this.skipTokens(this.fPrevious, ';');
                        bl = true;
                    } else {
                        string = this.fContent.substring(this.fPrevious, this.fNext);
                    }
                } else {
                    string = this.fContent.substring(this.fPrevious, this.fNext);
                }
                bl = true;
            } else if (!this.isWhitespace(this.fPrevious, this.fNext) && this.isAlphaNumeric(this.fPrevious, this.fNext)) {
                if (this.isUrlToken(this.fPrevious)) {
                    this.skipTokens(this.fPrevious, ' ');
                } else if (this.isToken(IJavaDocTagConstants.JAVADOC_PARAM_TAGS)) {
                    this.fLastToken = null;
                } else if (this.isToken(IJavaDocTagConstants.JAVADOC_REFERENCE_TAGS)) {
                    this.fLastToken = null;
                    this.skipTokens(this.fPrevious, this.fDelimiter.charAt(0));
                } else if (this.fNext - this.fPrevious > 1 || this.isSingleLetter(this.fPrevious) && !this.fIsIgnoringSingleLetters) {
                    string = this.fContent.substring(this.fPrevious, this.fNext);
                }
                bl = true;
            }
        }
        if (bl && this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
            while (this.fSentenceBreaks.size() > 0 && this.fPrevious >= this.nextSentence()) {
                this.fSentenceBreaks.removeFirst();
            }
            this.fStartsSentence = this.fLastToken == null || string != null;
        }
        return string;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected final void skipTokens(int n, char c) {
        int n2 = n;
        while (n2 < this.fContent.length() && this.fContent.charAt(n2) != c) {
            ++n2;
        }
        if (n2 < this.fContent.length()) {
            this.fPredecessor = this.fNext = n2;
            this.fSuccessor = this.fWordIterator.following(this.fNext);
        } else {
            this.fSuccessor = -1;
        }
    }

    public final boolean startsSentence() {
        return this.fStartsSentence;
    }
}

