/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;

public abstract class AbstractHierarchyViewerSorter
extends ViewerComparator {
    private static final int OTHER = 1;
    private static final int CLASS = 2;
    private static final int INTERFACE = 3;
    private static final int ANONYM = 4;
    private JavaElementComparator fNormalSorter = new JavaElementComparator();
    private SourcePositionComparator fSourcePositonSorter = new SourcePositionComparator();

    protected abstract ITypeHierarchy getHierarchy(IType var1);

    public abstract boolean isSortByDefiningType();

    public abstract boolean isSortAlphabetically();

    protected int getTypeFlags(IType iType) throws JavaModelException {
        return iType.getFlags();
    }

    public int category(Object object) {
        if (object instanceof IType) {
            IType iType = (IType)object;
            if (iType.getElementName().length() == 0) {
                return 4;
            }
            try {
                int n = this.getTypeFlags(iType);
                if (Flags.isInterface((int)n)) {
                    return 3;
                }
                return 2;
            }
            catch (JavaModelException javaModelException) {}
        }
        return 1;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n;
        if (!this.isSortAlphabetically() && !this.isSortByDefiningType()) {
            return this.fSourcePositonSorter.compare(viewer, object, object2);
        }
        int n2 = this.category(object);
        if (n2 != (n = this.category(object2))) {
            return n2 - n;
        }
        if (n2 == 1) {
            block14: {
                if (this.isSortByDefiningType()) {
                    IType iType;
                    block13: {
                        try {
                            IType iType2 = object instanceof IMethod ? this.getDefiningType((IMethod)object) : null;
                            IType iType3 = iType = object2 instanceof IMethod ? this.getDefiningType((IMethod)object2) : null;
                            if (iType2 == null) break block13;
                            if (iType != null) {
                                if (!iType.equals(iType2)) {
                                    return this.compareInHierarchy(iType2, iType);
                                }
                                break block14;
                            }
                            return -1;
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    if (iType != null) {
                        return 1;
                    }
                }
            }
            if (this.isSortAlphabetically()) {
                return this.fNormalSorter.compare(viewer, object, object2);
            }
            return 0;
        }
        if (n2 == 4) {
            return 0;
        }
        if (this.isSortAlphabetically()) {
            String string = ((IType)object).getElementName();
            String string2 = ((IType)object2).getElementName();
            return this.getComparator().compare(string, string2);
        }
        return 0;
    }

    private IType getDefiningType(IMethod iMethod) throws JavaModelException {
        MethodOverrideTester methodOverrideTester;
        IMethod iMethod2;
        int n = iMethod.getFlags();
        if (Flags.isPrivate((int)n) || Flags.isStatic((int)n) || iMethod.isConstructor()) {
            return null;
        }
        IType iType = iMethod.getDeclaringType();
        ITypeHierarchy iTypeHierarchy = this.getHierarchy(iType);
        if (iTypeHierarchy != null && (iMethod2 = (methodOverrideTester = new MethodOverrideTester(iType, iTypeHierarchy)).findDeclaringMethod(iMethod, true)) != null) {
            return iMethod2.getDeclaringType();
        }
        return null;
    }

    private int compareInHierarchy(IType iType, IType iType2) {
        block8: {
            int n;
            block7: {
                if (JavaModelUtil.isSuperType(this.getHierarchy(iType), iType2, iType)) {
                    return 1;
                }
                if (JavaModelUtil.isSuperType(this.getHierarchy(iType2), iType, iType2)) {
                    return -1;
                }
                try {
                    int n2 = this.getTypeFlags(iType);
                    n = this.getTypeFlags(iType2);
                    if (!Flags.isInterface((int)n2)) break block7;
                    if (!Flags.isInterface((int)n)) {
                        return 1;
                    }
                    break block8;
                }
                catch (JavaModelException javaModelException) {}
            }
            if (Flags.isInterface((int)n)) {
                return -1;
            }
        }
        String string = iType.getElementName();
        String string2 = iType2.getElementName();
        return this.getComparator().compare(string, string2);
    }
}

