/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(IJavaElement iJavaElement, IWorkbenchWindow iWorkbenchWindow) {
        IJavaElement[] iJavaElementArray = OpenTypeHierarchyUtil.getCandidates(iJavaElement);
        if (iJavaElementArray != null) {
            return OpenTypeHierarchyUtil.open(iJavaElementArray, iWorkbenchWindow);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(IJavaElement[] iJavaElementArray, IWorkbenchWindow iWorkbenchWindow) {
        Assert.isTrue((iJavaElementArray != null && iJavaElementArray.length != 0 ? 1 : 0) != 0);
        IJavaElement iJavaElement = null;
        if (iJavaElementArray.length > 1) {
            String string = JavaUIMessages.OpenTypeHierarchyUtil_selectionDialog_title;
            String string2 = JavaUIMessages.OpenTypeHierarchyUtil_selectionDialog_message;
            iJavaElement = SelectionConverter.selectJavaElement(iJavaElementArray, iWorkbenchWindow.getShell(), string, string2);
        } else {
            iJavaElement = iJavaElementArray[0];
        }
        if (iJavaElement == null) {
            return null;
        }
        try {
            if ("perspective".equals(PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.openTypeHierarchy"))) {
                return OpenTypeHierarchyUtil.openInPerspective(iWorkbenchWindow, iJavaElement);
            }
            return OpenTypeHierarchyUtil.openInViewPart(iWorkbenchWindow, iJavaElement);
        }
        catch (WorkbenchException workbenchException) {
            ExceptionHandler.handle((CoreException)((Object)workbenchException), iWorkbenchWindow.getShell(), JavaUIMessages.OpenTypeHierarchyUtil_error_open_perspective, workbenchException.getMessage());
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), iWorkbenchWindow.getShell(), JavaUIMessages.OpenTypeHierarchyUtil_error_open_editor, javaModelException.getMessage());
        }
        return null;
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow iWorkbenchWindow, IJavaElement iJavaElement) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        try {
            TypeHierarchyViewPart typeHierarchyViewPart = (TypeHierarchyViewPart)iWorkbenchPage.findView("org.eclipse.wst.jsdt.ui.TypeHierarchy");
            if (typeHierarchyViewPart != null) {
                typeHierarchyViewPart.clearNeededRefresh();
            }
            typeHierarchyViewPart = (TypeHierarchyViewPart)iWorkbenchPage.showView("org.eclipse.wst.jsdt.ui.TypeHierarchy");
            typeHierarchyViewPart.setInputElement(iJavaElement);
            return typeHierarchyViewPart;
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, iWorkbenchWindow.getShell(), JavaUIMessages.OpenTypeHierarchyUtil_error_open_view, coreException.getMessage());
            return null;
        }
    }

    private static TypeHierarchyViewPart openInPerspective(IWorkbenchWindow iWorkbenchWindow, IJavaElement iJavaElement) throws WorkbenchException, JavaModelException {
        TypeHierarchyViewPart typeHierarchyViewPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbench iWorkbench = JavaPlugin.getDefault().getWorkbench();
        Object object = iJavaElement;
        if (iJavaElement instanceof IMember) {
            object = iJavaElement.getElementType() != 7 ? ((iWorkbenchPage = (IMember)iJavaElement).getDeclaringType() != null ? iWorkbenchPage.getDeclaringType() : iWorkbenchPage.getCompilationUnit()) : iJavaElement;
        }
        if ((typeHierarchyViewPart = (TypeHierarchyViewPart)(iWorkbenchPage = iWorkbench.showPerspective("org.eclipse.wst.jsdt.ui.JavaHierarchyPerspective", iWorkbenchWindow, (IAdaptable)object)).findView("org.eclipse.wst.jsdt.ui.TypeHierarchy")) != null) {
            typeHierarchyViewPart.clearNeededRefresh();
        }
        typeHierarchyViewPart = (TypeHierarchyViewPart)iWorkbenchPage.showView("org.eclipse.wst.jsdt.ui.TypeHierarchy");
        typeHierarchyViewPart.setInputElement(iJavaElement);
        if (iJavaElement instanceof IMember && iWorkbenchPage.getEditorReferences().length == 0) {
            JavaUI.openInEditor(iJavaElement, false, false);
        }
        return typeHierarchyViewPart;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaElement[] getCandidates(Object object) {
        if (!(object instanceof IJavaElement)) {
            return null;
        }
        try {
            Object object2 = (IJavaElement)object;
            switch (object2.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return new IJavaElement[]{object2};
                }
                case 4: {
                    if (!((IPackageFragment)object2).containsJavaResources()) return null;
                    return new IJavaElement[]{object2};
                }
                case 11: {
                    return new IJavaElement[]{object2.getAncestor(4)};
                }
                case 13: {
                    IImportDeclaration iImportDeclaration = (IImportDeclaration)object2;
                    object2 = iImportDeclaration.isOnDemand() ? JavaModelUtil.findTypeContainer(object2.getJavaProject(), Signature.getQualifier((String)object2.getElementName())) : object2.getJavaProject().findType(object2.getElementName());
                    if (object2 == null) {
                        return null;
                    }
                    return new IJavaElement[]{object2};
                }
                case 6: {
                    return new IJavaElement[]{((IClassFile)object).getType()};
                }
                case 5: {
                    ICompilationUnit iCompilationUnit = (ICompilationUnit)object2.getAncestor(5);
                    if (iCompilationUnit == null) return null;
                    IType[] iTypeArray = iCompilationUnit.getTypes();
                    if (iTypeArray.length <= 0) return null;
                    return iTypeArray;
                }
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }
}

