/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;
import org.eclipse.wst.jsdt.ui.ProblemsLabelDecorator;

public class ProblemTreeViewer
extends TreeViewer
implements ResourceToItemsMapper.IContentViewerAccessor {
    protected ResourceToItemsMapper fResourceToItemsMapper;

    public ProblemTreeViewer(Composite composite) {
        super(composite);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite composite, int n) {
        super(composite, n);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    public void doUpdateItem(Widget widget) {
        this.doUpdateItem(widget, widget.getData(), true);
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper(this);
    }

    protected void mapElement(Object object, Widget widget) {
        super.mapElement(object, widget);
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.addToMap(object, (Item)widget);
        }
    }

    protected void unmapElement(Object object, Widget widget) {
        if (widget instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(object, (Item)widget);
        }
        super.unmapElement(object, widget);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (viewerFilter instanceof JavaViewerFilter) {
            ((JavaViewerFilter)viewerFilter).filteringStart();
        }
        super.addFilter(viewerFilter);
    }

    public void removeFilter(ViewerFilter viewerFilter) {
        super.removeFilter(viewerFilter);
        if (viewerFilter instanceof JavaViewerFilter) {
            ((JavaViewerFilter)viewerFilter).filteringEnd();
        }
    }

    public void setFilters(ViewerFilter[] viewerFilterArray) {
        ViewerFilter[] viewerFilterArray2 = this.getFilters();
        int n = 0;
        while (n < viewerFilterArray.length) {
            ViewerFilter viewerFilter = viewerFilterArray[n];
            if (viewerFilter instanceof JavaViewerFilter && !this.findAndRemove(viewerFilterArray2, viewerFilter)) {
                ((JavaViewerFilter)viewerFilter).filteringStart();
            }
            ++n;
        }
        this.endFilterSessions(viewerFilterArray2);
        super.setFilters(viewerFilterArray);
    }

    public void resetFilters() {
        this.endFilterSessions(this.getFilters());
        super.resetFilters();
    }

    private boolean findAndRemove(ViewerFilter[] viewerFilterArray, ViewerFilter viewerFilter) {
        int n = 0;
        while (n < viewerFilterArray.length) {
            if (viewerFilterArray[n] == viewerFilter) {
                viewerFilterArray[n] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    private void endFilterSessions(ViewerFilter[] viewerFilterArray) {
        int n = 0;
        while (n < viewerFilterArray.length) {
            ViewerFilter viewerFilter = viewerFilterArray[n];
            if (viewerFilter instanceof JavaViewerFilter) {
                ((JavaViewerFilter)viewerFilter).filteringEnd();
            }
            ++n;
        }
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        this.endFilterSessions(this.getFilters());
        super.handleDispose(disposeEvent);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray;
        if (labelProviderChangedEvent instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && !(objectArray = (Object[])labelProviderChangedEvent).isMarkerChange() && this.canIgnoreChangesFromAnnotionModel()) {
            return;
        }
        objectArray = this.addAditionalProblemParents(labelProviderChangedEvent.getElements());
        if (objectArray != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)object);
                } else {
                    arrayList.add(object);
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)labelProviderChangedEvent.getSource(), arrayList.toArray());
        } else if (labelProviderChangedEvent.getElements() != objectArray) {
            labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)labelProviderChangedEvent.getSource(), objectArray);
        }
        super.handleLabelProviderChanged(labelProviderChangedEvent);
    }

    private boolean canIgnoreChangesFromAnnotionModel() {
        IContentProvider iContentProvider = this.getContentProvider();
        return iContentProvider instanceof IWorkingCopyProvider && !((IWorkingCopyProvider)iContentProvider).providesWorkingCopies();
    }

    protected boolean evaluateExpandableWithFilters(Object object) {
        return object instanceof IMember;
    }

    public boolean isExpandable(Object object) {
        if (this.hasFilters() && this.evaluateExpandableWithFilters(object)) {
            return this.hasFilteredChildren(object);
        }
        return super.isExpandable(object);
    }

    protected final boolean hasFilteredChildren(Object object) {
        Object[] objectArray = this.getRawChildren(object);
        return this.containsNonFiltered(objectArray, object);
    }

    protected final Object[] getFilteredChildren(Object object) {
        return this.filter(this.getRawChildren(object), object);
    }

    private Object[] filter(Object[] objectArray, Object object) {
        if (!this.hasFilters() || objectArray.length == 0) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (!this.isFiltered(object2, object, viewerFilterArray)) {
                arrayList.add(object2);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private boolean containsNonFiltered(Object[] objectArray, Object object) {
        if (objectArray.length == 0) {
            return false;
        }
        if (!this.hasFilters()) {
            return true;
        }
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (!this.isFiltered(object2, object, viewerFilterArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isFiltered(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
        int n = 0;
        while (n < viewerFilterArray.length) {
            ViewerFilter viewerFilter = viewerFilterArray[n];
            if (!viewerFilter.select((Viewer)this, object2, object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final Object[] filter(Object[] objectArray) {
        return this.filter(objectArray, this.getRoot());
    }

    protected Object[] addAditionalProblemParents(Object[] objectArray) {
        return objectArray;
    }

    public boolean isFiltered(Object object, Object object2) {
        return this.isFiltered(object, object2, this.getFilters());
    }
}

