/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.io.File;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private LayoutGroup fLayoutGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.JavaProjectWizardFirstPage_page_pageName;
    private WorkingSetGroup fWorkingSetGroup;
    private IWorkingSet[] fInitWorkingSets;

    public JavaProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.JavaProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.JavaProjectWizardFirstPage_page_description);
        this.fInitialName = "";
        this.initializeDefaultVM();
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    public void setName(String string) {
        this.fInitialName = string;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(string);
        }
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite2.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite2, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite2);
        this.fLayoutGroup = new LayoutGroup(composite2);
        this.fWorkingSetGroup = new WorkingSetGroup(composite2, this.fInitWorkingSets);
        this.fDetectGroup = new DetectGroup(composite2);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        String string = this.fLocationGroup.getLocation().toOSString();
        IPath iPath = Path.fromOSString((String)string);
        return Platform.getLocation().isPrefixOf(iPath);
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrcBin() {
        return this.fLayoutGroup.isSrcBin();
    }

    public IPath getJREContainerPath() {
        return null;
    }

    public String getCompilerCompliance() {
        return null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout gridLayout, boolean bl) {
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (bl) {
            gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        return gridLayout;
    }

    public void setWorkingSets(IWorkingSet[] iWorkingSetArray) {
        this.fInitWorkingSets = iWorkingSetArray;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSetGroup.getSelectedWorkingSets();
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private Label fIcon;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.horizontalSpacing = 10;
            composite2.setLayout((Layout)gridLayout);
            this.fIcon = new Label(composite2, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite2, 64);
            this.fHintText.setFont(composite2.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = JavaProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = JavaProjectWizardFirstPage.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
        }

        public void update(Observable observable, Object object) {
            if (observable instanceof LocationGroup) {
                boolean bl = this.fDetect;
                if (JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    this.fDetect = false;
                } else {
                    File file = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = file.isDirectory();
                }
                if (bl != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.JavaProjectWizardFirstPage_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetDefaultSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";
            String string2 = "org.eclipse.wst.jsdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String string3 = "JRE".equals(selectionEvent.text) ? string : string2;
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)string3, (String[])new String[]{string, string2}, hashMap).open();
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio;
        private final SelectionButtonDialogField fSrcBinRadio;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_title);
            this.fStdRadio = new SelectionButtonDialogField(16);
            this.fStdRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_option_separateFolders);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.JavaProjectWizardFirstPage_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(bl);
            this.fStdRadio.setSelection(!bl);
        }

        public void update(Observable observable, Object object) {
            boolean bl = JavaProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!bl);
            this.fSrcBinRadio.setEnabled(!bl);
            this.fPreferenceLink.setEnabled(!bl);
            this.fGroup.setEnabled(!bl);
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetDefaultSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = "org.eclipse.wst.jsdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)JavaProjectWizardFirstPage.this.getShell(), (String)string, (String[])new String[]{string}, null).open();
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.wst.jsdt.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.JavaProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String string) {
            IPath iPath = Platform.getLocation().append(string);
            return iPath.toOSString();
        }

        public void update(Observable observable, Object object) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField dialogField) {
            Object object;
            DirectoryDialog directoryDialog = new DirectoryDialog(JavaProjectWizardFirstPage.this.getShell());
            directoryDialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String string = this.fLocation.getText().trim();
            if (string.length() == 0 && (object = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                string = object;
            }
            if (string.length() > 0 && ((File)(object = new File(string))).exists()) {
                directoryDialog.setFilterPath(string);
            }
            if ((object = directoryDialog.open()) != null) {
                this.fLocation.setText((String)object);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, (String)object);
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
            if (dialogField == this.fWorkspaceRadio) {
                boolean bl = this.fWorkspaceRadio.isSelected();
                if (bl) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(JavaProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String string) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            composite2.setLayout((Layout)JavaProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            composite2.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.JavaProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(string);
            this.fNameField.doFillIntoGrid(composite2, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(JavaProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String string) {
            this.fNameField.setText(string);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable observable, Object object) {
            IWorkspace iWorkspace = JavaPlugin.getWorkspace();
            String string = JavaProjectWizardFirstPage.this.fNameGroup.getName();
            if (string.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterProjectName);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus iStatus = iWorkspace.validateName(string, 4);
            if (!iStatus.isOK()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(iStatus.getMessage());
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject iProject = JavaProjectWizardFirstPage.this.getProjectHandle();
            if (iProject.exists()) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_projectAlreadyExists);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String string2 = JavaProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (string2.length() == 0) {
                JavaProjectWizardFirstPage.this.setErrorMessage(null);
                JavaProjectWizardFirstPage.this.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_enterLocation);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(string2)) {
                JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidDirectory);
                JavaProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath iPath = Path.fromOSString((String)string2);
            if (!JavaProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                if (!this.canCreate(iPath.toFile())) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_cannotCreateAtExternalLocation);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
                if (!Platform.getLocation().equals((Object)iPath) && Platform.getLocation().isPrefixOf(iPath)) {
                    if (!Platform.getLocation().equals((Object)iPath.removeLastSegments(1))) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    if (!iPath.toFile().exists()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_notExisingProjectOnWorkspaceRoot);
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                    String string3 = iPath.lastSegment();
                    if (!string3.equals(JavaProjectWizardFirstPage.this.fNameGroup.getName())) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(Messages.format(NewWizardMessages.JavaProjectWizardFirstPage_Message_invalidProjectNameForWorkspaceRoot, string3));
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                } else {
                    IStatus iStatus2 = iWorkspace.validateProjectLocation(iProject, iPath);
                    if (!iStatus2.isOK()) {
                        JavaProjectWizardFirstPage.this.setErrorMessage(iStatus2.getMessage());
                        JavaProjectWizardFirstPage.this.setPageComplete(false);
                        return;
                    }
                }
            } else {
                IPath iPath2 = iPath.append(JavaProjectWizardFirstPage.this.fNameGroup.getName());
                if (iPath2.toFile().exists()) {
                    JavaProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.JavaProjectWizardFirstPage_Message_existingFolderInWorkspace);
                    JavaProjectWizardFirstPage.this.setPageComplete(false);
                    return;
                }
            }
            JavaProjectWizardFirstPage.this.setPageComplete(true);
            JavaProjectWizardFirstPage.this.setErrorMessage(null);
            JavaProjectWizardFirstPage.this.setMessage(null);
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }
    }

    private final class WorkingSetGroup {
        private WorkingSetConfigurationBlock fWorkingSetBlock;

        public WorkingSetGroup(Composite composite, IWorkingSet[] iWorkingSetArray) {
            Group group = new Group(composite, 0);
            group.setFont(composite.getFont());
            group.setText(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSets_group);
            group.setLayoutData((Object)new GridData(4, 128, true, false));
            group.setLayout((Layout)new GridLayout(1, false));
            String[] stringArray = new String[]{"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
            this.fWorkingSetBlock = new WorkingSetConfigurationBlock(stringArray, NewWizardMessages.JavaProjectWizardFirstPage_EnableWorkingSet_button, JavaPlugin.getDefault().getDialogSettings());
            this.fWorkingSetBlock.setDialogMessage(NewWizardMessages.JavaProjectWizardFirstPage_WorkingSetSelection_message);
            this.fWorkingSetBlock.setSelection(iWorkingSetArray);
            this.fWorkingSetBlock.createContent((Composite)group);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.fWorkingSetBlock.getSelectedWorkingSets();
        }
    }
}

