/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public class NewSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private StringButtonDialogField fProjectField;
    private StatusInfo fProjectStatus;
    private StringButtonDialogField fRootDialogField;
    private StatusInfo fRootStatus;
    private SelectionButtonDialogField fExcludeInOthersFields;
    private IWorkspaceRoot fWorkspaceRoot;
    private IJavaProject fCurrJProject;
    private IClasspathEntry[] fEntries;
    private IPath fOutputLocation;
    private IClasspathEntry[] fNewEntries;
    private IPath fNewOutputLocation;
    private boolean fIsProjectAsSourceFolder;
    private IPackageFragmentRoot fCreatedRoot;
    static /* synthetic */ Class class$0;

    public NewSourceFolderWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_description);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        RootFieldAdapter rootFieldAdapter = new RootFieldAdapter();
        this.fProjectField = new StringButtonDialogField(rootFieldAdapter);
        this.fProjectField.setDialogFieldListener(rootFieldAdapter);
        this.fProjectField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_project_label);
        this.fProjectField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_project_button);
        this.fRootDialogField = new StringButtonDialogField(rootFieldAdapter);
        this.fRootDialogField.setDialogFieldListener(rootFieldAdapter);
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        this.fRootDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_root_button);
        this.fExcludeInOthersFields = new SelectionButtonDialogField(32);
        this.fExcludeInOthersFields.setDialogFieldListener(rootFieldAdapter);
        this.fExcludeInOthersFields.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fExcludeInOthersFields.setEnabled(true);
        this.fRootStatus = new StatusInfo();
        this.fProjectStatus = new StatusInfo();
    }

    public void init(IStructuredSelection iStructuredSelection) {
        String string = this.getProjectPath(iStructuredSelection);
        if (string != null) {
            this.fProjectField.setText(string);
        }
        this.fRootDialogField.setText("");
    }

    private String getProjectPath(IStructuredSelection iStructuredSelection) {
        IJavaProject iJavaProject;
        Object object = null;
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            object = EditorUtility.getActiveEditorJavaInput();
        } else if (iStructuredSelection.size() == 1) {
            object = iStructuredSelection.getFirstElement();
        }
        if (object instanceof IResource) {
            IProject iProject = ((IResource)object).getProject();
            if (iProject != null) {
                return iProject.getFullPath().makeRelative().toString();
            }
        } else if (object instanceof IJavaElement && (iJavaProject = object.getJavaProject()) != null) {
            return iJavaProject.getProject().getFullPath().makeRelative().toString();
        }
        return null;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.fProjectField.doFillIntoGrid(composite2, 3);
        this.fRootDialogField.doFillIntoGrid(composite2, 3);
        this.fExcludeInOthersFields.doFillIntoGrid(composite2, 3);
        int n = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.fProjectField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fRootDialogField.getTextControl(null), n);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.new_packageroot_wizard_page_context");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField dialogField) {
        IJavaProject iJavaProject;
        if (dialogField == this.fRootDialogField) {
            String string = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title;
            String string2 = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description;
            Path path = new Path(this.fRootDialogField.getText());
            IFolder iFolder = this.chooseFolder(string, string2, (IPath)path);
            if (iFolder != null) {
                IPath iPath = iFolder.getFullPath().removeFirstSegments(1);
                this.fRootDialogField.setText(iPath.toString());
            }
        } else if (dialogField == this.fProjectField && (iJavaProject = this.chooseProject()) != null) {
            IPath iPath = iJavaProject.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(iPath.toString());
        }
    }

    protected void packRootDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fRootDialogField) {
            this.updateRootStatus();
        } else if (dialogField == this.fProjectField) {
            this.updateProjectStatus();
            this.updateRootStatus();
        } else if (dialogField == this.fExcludeInOthersFields) {
            this.updateRootStatus();
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
    }

    private void updateProjectStatus() {
        this.fCurrJProject = null;
        this.fIsProjectAsSourceFolder = false;
        String string = this.fProjectField.getText();
        if (string.length() == 0) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_EnterProjectName);
            return;
        }
        Path path = new Path(string);
        if (path.segmentCount() != 1) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidProjectPath);
            return;
        }
        IProject iProject = this.fWorkspaceRoot.getProject(path.toString());
        if (!iProject.exists()) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_ProjectNotExists);
            return;
        }
        if (!iProject.isOpen()) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_ProjectNotOpen);
            return;
        }
        try {
            if (iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                this.fCurrJProject = JavaCore.create((IProject)iProject);
                this.fEntries = this.fCurrJProject.getRawClasspath();
                this.fOutputLocation = this.fCurrJProject.getOutputLocation();
                this.fProjectStatus.setOK();
                return;
            }
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            this.fCurrJProject = null;
        }
        this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAJavaProject);
    }

    private void updateRootStatus() {
        this.fRootDialogField.enableButton(this.fCurrJProject != null);
        this.fIsProjectAsSourceFolder = false;
        if (this.fCurrJProject == null) {
            return;
        }
        this.fRootStatus.setOK();
        IPath iPath = this.fCurrJProject.getProject().getFullPath();
        String string = this.fRootDialogField.getText();
        if (string.length() == 0) {
            this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, this.fCurrJProject.getProject().getFullPath().toString()));
        } else {
            IPath iPath2 = iPath.append(string);
            IStatus iStatus = this.fWorkspaceRoot.getWorkspace().validatePath(iPath2.toString(), 2);
            if (iStatus.matches(4)) {
                this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, iStatus.getMessage()));
            } else {
                IClasspathEntry iClasspathEntry;
                Object object;
                Serializable serializable;
                IResource iResource = this.fWorkspaceRoot.findMember(iPath2);
                if (iResource != null) {
                    if (iResource.getType() != 2) {
                        this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                        return;
                    }
                } else {
                    serializable = this.fCurrJProject.getProject().getLocationURI();
                    if (serializable != null) {
                        try {
                            IFileStore iFileStore = EFS.getStore((URI)serializable).getChild(string);
                            if (iFileStore.fetchInfo().exists()) {
                                this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                                return;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                serializable = new ArrayList(this.fEntries.length + 1);
                int n = -1;
                int n2 = 0;
                while (n2 < this.fEntries.length) {
                    object = this.fEntries[n2];
                    if (object.getEntryKind() == 3) {
                        if (iPath2.equals((Object)object.getPath())) {
                            this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                            return;
                        }
                        if (iPath.equals((Object)object.getPath())) {
                            n = n2;
                        }
                    }
                    ((ArrayList)serializable).add(object);
                    ++n2;
                }
                IClasspathEntry iClasspathEntry2 = JavaCore.newSourceEntry((IPath)iPath2);
                object = new HashSet();
                if (this.fExcludeInOthersFields.isSelected()) {
                    this.addExclusionPatterns(iClasspathEntry2, (List)((Object)serializable), (Set)object);
                    iClasspathEntry = JavaCore.newSourceEntry((IPath)iPath2);
                    this.insertAtEndOfCategory(iClasspathEntry, (List)((Object)serializable));
                } else if (n != -1) {
                    this.fIsProjectAsSourceFolder = true;
                    ((ArrayList)serializable).set(n, iClasspathEntry2);
                } else {
                    iClasspathEntry = JavaCore.newSourceEntry((IPath)iPath2);
                    this.insertAtEndOfCategory(iClasspathEntry, (List)((Object)serializable));
                }
                this.fNewEntries = ((ArrayList)serializable).toArray(new IClasspathEntry[((ArrayList)serializable).size()]);
                this.fNewOutputLocation = this.fOutputLocation;
                iClasspathEntry = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.fNewEntries, (IPath)this.fNewOutputLocation);
                if (!iClasspathEntry.isOK()) {
                    if (this.fOutputLocation.equals((Object)iPath)) {
                        this.fNewOutputLocation = iPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName"));
                        IJavaModelStatus iJavaModelStatus = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.fNewEntries, (IPath)this.fNewOutputLocation);
                        if (iJavaModelStatus.isOK()) {
                            if (this.fIsProjectAsSourceFolder) {
                                this.fRootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, this.fNewOutputLocation.makeRelative().toString()));
                            } else {
                                this.fRootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, this.fNewOutputLocation.makeRelative().toString()));
                            }
                            return;
                        }
                    }
                    this.fRootStatus.setError(iClasspathEntry.getMessage());
                    return;
                }
                if (this.fIsProjectAsSourceFolder) {
                    this.fRootStatus.setInfo(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
                    return;
                }
                if (!object.isEmpty()) {
                    this.fRootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, String.valueOf(object.size())));
                    return;
                }
            }
        }
    }

    private void insertAtEndOfCategory(IClasspathEntry iClasspathEntry, List list) {
        int n = list.size();
        IClasspathEntry[] iClasspathEntryArray = list.toArray(new IClasspathEntry[n]);
        int n2 = 0;
        while (n2 < n && iClasspathEntryArray[n2].getEntryKind() != iClasspathEntry.getEntryKind()) {
            ++n2;
        }
        if (n2 < n) {
            ++n2;
            while (n2 < n && iClasspathEntryArray[n2].getEntryKind() == iClasspathEntry.getEntryKind()) {
                ++n2;
            }
            list.add(n2, iClasspathEntry);
            return;
        }
        switch (iClasspathEntry.getEntryKind()) {
            case 3: {
                list.add(0, iClasspathEntry);
                break;
            }
            default: {
                list.add(iClasspathEntry);
            }
        }
    }

    private void addExclusionPatterns(IClasspathEntry iClasspathEntry, List list, Set set) {
        IPath iPath = iClasspathEntry.getPath();
        int n = 0;
        while (n < list.size()) {
            IPath[] iPathArray;
            IClasspathEntry iClasspathEntry2 = (IClasspathEntry)list.get(n);
            IPath iPath2 = iClasspathEntry2.getPath();
            if (iClasspathEntry2.getEntryKind() == 3 && iPath2.isPrefixOf(iPath) && !JavaModelUtil.isExcludedPath(iPath, iPathArray = iClasspathEntry2.getExclusionPatterns())) {
                IPath iPath3 = iPath.removeFirstSegments(iPath2.segmentCount()).addTrailingSeparator();
                IPath[] iPathArray2 = new IPath[iPathArray.length + 1];
                System.arraycopy(iPathArray, 0, iPathArray2, 0, iPathArray.length);
                iPathArray2[iPathArray.length] = iPath3;
                IClasspathEntry iClasspathEntry3 = JavaCore.newSourceEntry((IPath)iPath2, (IPath[])iPathArray2, (IPath)iClasspathEntry2.getOutputLocation());
                list.set(n, iClasspathEntry3);
                set.add(iClasspathEntry3);
            }
            ++n;
        }
    }

    public IPackageFragmentRoot getNewPackageFragmentRoot() {
        return this.fCreatedRoot;
    }

    public IResource getCorrespondingResource() {
        return this.fCurrJProject.getProject().getFolder(this.fRootDialogField.getText());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createPackageFragmentRoot(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(NewWizardMessages.NewSourceFolderWizardPage_operation, 3);
        try {
            IPath iPath = this.fCurrJProject.getProject().getFullPath();
            if (this.fOutputLocation.equals((Object)iPath) && !this.fNewOutputLocation.equals((Object)iPath) && BuildPathsBlock.hasClassfiles((IResource)this.fCurrJProject.getProject()) && BuildPathsBlock.getRemoveOldBinariesQuery(this.getShell()).doQuery(false, iPath)) {
                BuildPathsBlock.removeOldClassfiles((IResource)this.fCurrJProject.getProject());
            }
            String string = this.fRootDialogField.getText();
            IFolder iFolder = this.fCurrJProject.getProject().getFolder(string);
            if (!iFolder.exists()) {
                CoreUtility.createFolder(iFolder, true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.fCurrJProject.setRawClasspath(this.fNewEntries, this.fNewOutputLocation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            this.fCreatedRoot = this.fCurrJProject.getPackageFragmentRoot((IResource)iFolder);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
    }

    private IFolder chooseFolder(String string, String string2, IPath iPath) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        TypedElementSelectionValidator typedElementSelectionValidator = new TypedElementSelectionValidator(classArray2, false);
        TypedViewerFilter typedViewerFilter = new TypedViewerFilter(classArray2, null);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        IProject iProject = this.fCurrJProject.getProject();
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)typedElementSelectionValidator);
        elementTreeSelectionDialog.setTitle(string);
        elementTreeSelectionDialog.setMessage(string2);
        elementTreeSelectionDialog.addFilter((ViewerFilter)typedViewerFilter);
        elementTreeSelectionDialog.setInput((Object)iProject);
        elementTreeSelectionDialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource iResource = iProject.findMember(iPath);
        if (iResource != null) {
            elementTreeSelectionDialog.setInitialSelection((Object)iResource);
        }
        if (elementTreeSelectionDialog.open() == 0) {
            return (IFolder)elementTreeSelectionDialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject chooseProject() {
        Object[] objectArray;
        try {
            objectArray = JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            objectArray = new IJavaProject[]{};
        }
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_title);
        elementListSelectionDialog.setMessage(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_description);
        elementListSelectionDialog.setElements(objectArray);
        elementListSelectionDialog.setInitialSelections(new Object[]{this.fCurrJProject});
        elementListSelectionDialog.setHelpAvailable(false);
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            NewSourceFolderWizardPage.this.packRootChangeControlPressed(dialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewSourceFolderWizardPage.this.packRootDialogFieldChanged(dialogField);
        }
    }
}

