/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public abstract class BuildPathWizard
extends NewElementWizard {
    private boolean fDoFlushChange;
    private final CPListElement fEntryToEdit;
    private IPackageFragmentRoot fPackageFragmentRoot;
    private IPath fOutputLocation;
    private final ArrayList fExistingEntries;

    public BuildPathWizard(CPListElement[] cPListElementArray, CPListElement cPListElement, IPath iPath, String string, ImageDescriptor imageDescriptor) {
        this.fOutputLocation = iPath;
        if (imageDescriptor != null) {
            this.setDefaultPageImageDescriptor(imageDescriptor);
        }
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(string);
        this.fEntryToEdit = cPListElement;
        this.fExistingEntries = new ArrayList<CPListElement>(Arrays.asList(cPListElementArray));
        this.fDoFlushChange = true;
    }

    protected void finishPage(IProgressMonitor iProgressMonitor) throws InterruptedException, CoreException {
        if (this.fDoFlushChange) {
            IJavaProject iJavaProject = this.getEntryToEdit().getJavaProject();
            BuildPathsBlock.flush(this.getExistingEntries(), iJavaProject, this.getSuperType(), iProgressMonitor);
            IProject iProject = iJavaProject.getProject();
            IPath iPath = this.getEntryToEdit().getPath();
            IResource iResource = iProject.getWorkspace().getRoot().findMember(iPath);
            this.fPackageFragmentRoot = iJavaProject.getPackageFragmentRoot(iResource);
        }
    }

    public LibrarySuperType getSuperType() {
        return null;
    }

    public IJavaElement getCreatedElement() {
        return this.fPackageFragmentRoot;
    }

    public void setDoFlushChange(boolean bl) {
        this.fDoFlushChange = bl;
    }

    public ArrayList getExistingEntries() {
        return this.fExistingEntries;
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    protected void setOutputLocation(IPath iPath) {
        this.fOutputLocation = iPath;
    }

    protected CPListElement getEntryToEdit() {
        return this.fEntryToEdit;
    }

    public List getInsertedElements() {
        return new ArrayList();
    }

    public List getRemovedElements() {
        return new ArrayList();
    }

    public List getModifiedElements() {
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>(1);
        arrayList.add(this.fEntryToEdit);
        return arrayList;
    }

    public abstract void cancel();
}

