/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;

public class FolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;

    public FolderSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
        super(shell, iLabelProvider, iTreeContentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Button button = new Button(composite2, 8);
        button.setText(NewWizardMessages.FolderSelectionDialog_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(composite.getFont());
        this.fNewFolderButton = button;
        FolderSelectionDialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.bp_select_default_output_folder_dialog");
        return composite2;
    }

    private void updateNewFolderButtonState() {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.fSelectedContainer = null;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)object;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog newFolderDialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer){

            protected Control createContents(Composite composite) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.bp_create_new_folder_dialog");
                return super.createContents(composite);
            }
        };
        if (newFolderDialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            Object object = newFolderDialog.getResult()[0];
            treeViewer.reveal(object);
            treeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateNewFolderButtonState();
    }
}

