/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JARFileSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.VariablePathDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class SourceAttachmentBlock {
    private IStatusChangeListener fContext;
    private StringButtonDialogField fFileNameField;
    private SelectionButtonDialogField fWorkspaceButton;
    private SelectionButtonDialogField fExternalFolderButton;
    private IStatus fNameStatus;
    private IPath fFileVariablePath;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private Label fFullPathResolvedLabel;
    private IJavaProject fProject;
    private IClasspathEntry fEntry;
    private IPath fContainerPath;

    public SourceAttachmentBlock(IStatusChangeListener iStatusChangeListener, IClasspathEntry iClasspathEntry) {
        Assert.isNotNull((Object)iClasspathEntry);
        this.fContext = iStatusChangeListener;
        this.fEntry = iClasspathEntry;
        int n = iClasspathEntry.getEntryKind();
        Assert.isTrue((n == 1 || n == 4 ? 1 : 0) != 0);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fNameStatus = new StatusInfo();
        SourceAttachmentAdapter sourceAttachmentAdapter = new SourceAttachmentAdapter();
        if (this.isVariableEntry()) {
            this.fFileNameField = new VariablePathDialogField(sourceAttachmentAdapter);
            this.fFileNameField.setDialogFieldListener(sourceAttachmentAdapter);
            this.fFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_varlabel);
            this.fFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_external_varbutton);
            ((VariablePathDialogField)this.fFileNameField).setVariableButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_variable_button);
        } else {
            this.fFileNameField = new StringButtonDialogField(sourceAttachmentAdapter);
            this.fFileNameField.setDialogFieldListener(sourceAttachmentAdapter);
            this.fFileNameField.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_label);
            this.fFileNameField.setButtonLabel(NewWizardMessages.SourceAttachmentBlock_filename_externalfile_button);
            this.fWorkspaceButton = new SelectionButtonDialogField(8);
            this.fWorkspaceButton.setDialogFieldListener(sourceAttachmentAdapter);
            this.fWorkspaceButton.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_internal_button);
            this.fExternalFolderButton = new SelectionButtonDialogField(8);
            this.fExternalFolderButton.setDialogFieldListener(sourceAttachmentAdapter);
            this.fExternalFolderButton.setLabelText(NewWizardMessages.SourceAttachmentBlock_filename_externalfolder_button);
        }
        this.setDefaults();
    }

    public SourceAttachmentBlock(IStatusChangeListener iStatusChangeListener, IClasspathEntry iClasspathEntry, IPath iPath, IJavaProject iJavaProject) {
        this(iStatusChangeListener, iClasspathEntry);
        this.fContainerPath = iPath;
        this.fProject = iJavaProject;
    }

    public void setDefaults() {
        if (this.fEntry.getSourceAttachmentPath() != null) {
            this.fFileNameField.setText(this.fEntry.getSourceAttachmentPath().toString());
        } else {
            this.fFileNameField.setText("");
        }
    }

    private boolean isVariableEntry() {
        return this.fEntry.getEntryKind() == 4;
    }

    public IPath getSourceAttachmentPath() {
        if (this.fFileNameField.getText().length() == 0) {
            return null;
        }
        return this.getFilePath();
    }

    public IPath getSourceAttachmentRootPath() {
        return null;
    }

    public IClasspathEntry getNewEntry() {
        CPListElement cPListElement = CPListElement.createFromExisting(this.fEntry, this.fProject);
        cPListElement.setAttribute("sourcepath", this.getSourceAttachmentPath());
        return cPListElement.getClasspathEntry();
    }

    public Control createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.fSWTWidget = composite;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        if (this.isVariableEntry()) {
            int n = pixelConverter.convertWidthInCharsToPixels(40);
            int n2 = n * 2;
            Label label = new Label(composite2, 64);
            GridData gridData = new GridData(4, 1, false, false, 4, 1);
            label.setLayoutData((Object)gridData);
            label.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, this.fEntry.getPath().lastSegment()));
            Label label2 = new Label(composite2, 64);
            gridData = new GridData(4, 1, false, false, 4, 1);
            gridData.widthHint = n2;
            label2.setLayoutData((Object)gridData);
            label2.setText(NewWizardMessages.SourceAttachmentBlock_filename_description);
            this.fFileNameField.doFillIntoGrid(composite2, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), n);
            this.fFullPathResolvedLabel = new Label(composite2, 64);
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
            gridData = new GridData(4, 1, false, false, 4, 1);
            gridData.widthHint = n2;
            this.fFullPathResolvedLabel.setLayoutData((Object)gridData);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
        } else {
            int n = pixelConverter.convertWidthInCharsToPixels(60);
            GridData gridData = new GridData(4, 1, false, false, 3, 1);
            gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
            Label label = new Label(composite2, 16448);
            label.setLayoutData((Object)gridData);
            label.setText(Messages.format(NewWizardMessages.SourceAttachmentBlock_message, this.fEntry.getPath().lastSegment()));
            this.fWorkspaceButton.doFillIntoGrid(composite2, 1);
            ((GridData)this.fWorkspaceButton.getSelectionButton(null).getLayoutData()).verticalAlignment = 0x1000008;
            this.fFileNameField.doFillIntoGrid(composite2, 4);
            LayoutUtil.setWidthHint((Control)this.fFileNameField.getTextControl(null), n);
            LayoutUtil.setHorizontalGrabbing((Control)this.fFileNameField.getTextControl(null));
            DialogField.createEmptySpace(composite2, 3);
            this.fExternalFolderButton.doFillIntoGrid(composite2, 1);
        }
        this.fFileNameField.postSetFocusOnDialogField(composite.getDisplay());
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.source_attachment_context");
        return composite2;
    }

    private void attachmentChangeControlPressed(DialogField dialogField) {
        if (dialogField == this.fFileNameField) {
            IPath iPath;
            IPath iPath2 = iPath = this.isVariableEntry() ? this.chooseExtension() : this.chooseExtJarFile();
            if (iPath != null) {
                this.fFileNameField.setText(iPath.toString());
            }
        }
    }

    private void attachmentDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fFileNameField) {
            this.fNameStatus = this.updateFileNameStatus();
        } else {
            if (dialogField == this.fWorkspaceButton) {
                IPath iPath = this.chooseInternal();
                if (iPath != null) {
                    this.fFileNameField.setText(iPath.toString());
                }
                return;
            }
            if (dialogField == this.fExternalFolderButton) {
                IPath iPath = this.chooseExtFolder();
                if (iPath != null) {
                    this.fFileNameField.setText(iPath.toString());
                }
                return;
            }
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        this.fFileNameField.enableButton(this.canBrowseFileName());
        if (this.fFullPathResolvedLabel != null) {
            this.fFullPathResolvedLabel.setText(this.getResolvedLabelString());
        }
        IStatus iStatus = StatusUtil.getMostSevere(new IStatus[]{this.fNameStatus});
        this.fContext.statusChanged(iStatus);
    }

    private boolean canBrowseFileName() {
        if (!this.isVariableEntry()) {
            return true;
        }
        if (this.fFileVariablePath != null) {
            return this.fFileVariablePath.toFile().isDirectory();
        }
        return false;
    }

    private String getResolvedLabelString() {
        IPath iPath = this.getResolvedPath(this.getFilePath());
        if (iPath != null) {
            return iPath.toOSString();
        }
        return "";
    }

    private IPath getResolvedPath(IPath iPath) {
        IPath iPath2;
        String string;
        if (iPath != null && (string = iPath.segment(0)) != null && (iPath2 = JavaCore.getClasspathVariable((String)string)) != null) {
            return iPath2.append(iPath.removeFirstSegments(1));
        }
        return null;
    }

    private IStatus updateFileNameStatus() {
        StatusInfo statusInfo = new StatusInfo();
        this.fFileVariablePath = null;
        String string = this.fFileNameField.getText();
        if (string.length() == 0) {
            return statusInfo;
        }
        if (!Path.EMPTY.isValidPath(string)) {
            statusInfo.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
            return statusInfo;
        }
        IPath iPath = Path.fromOSString((String)string);
        if (this.isVariableEntry()) {
            if (iPath.getDevice() != null) {
                statusInfo.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_deviceinpath);
                return statusInfo;
            }
            String string2 = iPath.segment(0);
            if (string2 == null) {
                statusInfo.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_notvalid);
                return statusInfo;
            }
            this.fFileVariablePath = JavaCore.getClasspathVariable((String)string2);
            if (this.fFileVariablePath == null) {
                statusInfo.setError(NewWizardMessages.SourceAttachmentBlock_filename_error_varnotexists);
                return statusInfo;
            }
            IPath iPath2 = this.fFileVariablePath.append(iPath.removeFirstSegments(1));
            if (iPath2.isEmpty()) {
                statusInfo.setWarning(NewWizardMessages.SourceAttachmentBlock_filename_warning_varempty);
                return statusInfo;
            }
            File file = iPath2.toFile();
            if (!file.exists()) {
                String string3 = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, iPath2.toOSString());
                statusInfo.setWarning(string3);
                return statusInfo;
            }
            if (!iPath2.isAbsolute()) {
                String string4 = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, iPath.toString());
                statusInfo.setError(string4);
                return statusInfo;
            }
            String string5 = BuildPathSupport.getDeprecationMessage(string2);
            if (string5 != null) {
                statusInfo.setWarning(string5);
                return statusInfo;
            }
        } else {
            File file = iPath.toFile();
            IResource iResource = this.fWorkspaceRoot.findMember(iPath);
            if (iResource != null && iResource.getLocation() != null) {
                file = iResource.getLocation().toFile();
            }
            if (!file.exists()) {
                String string6 = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_filenotexists, iPath.toString());
                statusInfo.setError(string6);
                return statusInfo;
            }
            if (iResource == null && !iPath.isAbsolute()) {
                String string7 = Messages.format(NewWizardMessages.SourceAttachmentBlock_filename_error_notabsolute, iPath.toString());
                statusInfo.setError(string7);
                return statusInfo;
            }
        }
        return statusInfo;
    }

    private IPath getFilePath() {
        return Path.fromOSString((String)this.fFileNameField.getText()).makeAbsolute();
    }

    private IPath chooseExtension() {
        IPath iPath;
        IPath iPath2 = this.getFilePath();
        if (iPath2.segmentCount() == 0) {
            iPath2 = this.fEntry.getPath();
        }
        File file = (iPath = this.getResolvedPath(iPath2)) != null ? iPath.toFile() : null;
        String string = iPath2.segment(0);
        JARFileSelectionDialog jARFileSelectionDialog = new JARFileSelectionDialog(this.getShell(), false, true);
        jARFileSelectionDialog.setTitle(NewWizardMessages.SourceAttachmentBlock_extvardialog_title);
        jARFileSelectionDialog.setMessage(NewWizardMessages.SourceAttachmentBlock_extvardialog_description);
        jARFileSelectionDialog.setInput(this.fFileVariablePath.toFile());
        jARFileSelectionDialog.setInitialSelection(file);
        if (jARFileSelectionDialog.open() == 0) {
            File file2 = (File)jARFileSelectionDialog.getResult()[0];
            IPath iPath3 = Path.fromOSString((String)file2.getPath()).makeAbsolute();
            return this.modifyPath(iPath3, string);
        }
        return null;
    }

    private IPath chooseExtJarFile() {
        IPath iPath = this.getFilePath();
        if (iPath.segmentCount() == 0) {
            iPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath(iPath)) {
            iPath = iPath.removeLastSegments(1);
        }
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText(NewWizardMessages.SourceAttachmentBlock_extjardialog_text);
        fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip;*.js"});
        fileDialog.setFilterPath(iPath.toOSString());
        String string = fileDialog.open();
        if (string != null) {
            return Path.fromOSString((String)string).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        IPath iPath = this.getFilePath();
        if (iPath.segmentCount() == 0) {
            iPath = this.fEntry.getPath();
        }
        if (ArchiveFileFilter.isArchivePath(iPath)) {
            iPath = iPath.removeLastSegments(1);
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage(NewWizardMessages.SourceAttachmentBlock_extfolderdialog_message);
        directoryDialog.setText(NewWizardMessages.SourceAttachmentBlock_extfolderdialog_text);
        directoryDialog.setFilterPath(iPath.toOSString());
        String string = directoryDialog.open();
        if (string != null) {
            return Path.fromOSString((String)string).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternal() {
        String string = this.fFileNameField.getText();
        ArchiveFileFilter archiveFileFilter = new ArchiveFileFilter(null, false);
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        IResource iResource = null;
        if (string.length() > 0) {
            iResource = this.fWorkspaceRoot.findMember((IPath)new Path(string));
        }
        if (iResource == null) {
            iResource = this.fWorkspaceRoot.findMember(this.fEntry.getPath());
        }
        FolderSelectionDialog folderSelectionDialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        folderSelectionDialog.setAllowMultiple(false);
        folderSelectionDialog.addFilter(archiveFileFilter);
        folderSelectionDialog.setTitle(NewWizardMessages.SourceAttachmentBlock_intjardialog_title);
        folderSelectionDialog.setMessage(NewWizardMessages.SourceAttachmentBlock_intjardialog_message);
        folderSelectionDialog.setInput(this.fWorkspaceRoot);
        folderSelectionDialog.setInitialSelection(iResource);
        if (folderSelectionDialog.open() == 0) {
            IResource iResource2 = (IResource)folderSelectionDialog.getFirstResult();
            return iResource2.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private IPath modifyPath(IPath object, String string) {
        if (string == null || object == null) {
            return null;
        }
        if (object.isEmpty()) {
            return new Path(string);
        }
        IPath iPath = JavaCore.getClasspathVariable((String)string);
        object = iPath != null ? (iPath.isPrefixOf(object) ? object.removeFirstSegments(iPath.segmentCount()) : new Path(object.lastSegment())) : new Path(object.lastSegment());
        return new Path(string).append(object);
    }

    public static IRunnableWithProgress getRunnable(final Shell shell, final IClasspathEntry iClasspathEntry, final IJavaProject iJavaProject, final IPath iPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    String[] stringArray = new String[]{"sourcepath"};
                    BuildPathSupport.modifyClasspathEntry(shell, iClasspathEntry, stringArray, iJavaProject, iPath, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    public IRunnableWithProgress getRunnable(Shell shell) {
        return SourceAttachmentBlock.getRunnable(shell, this.getNewEntry(), this.fProject, this.fContainerPath);
    }

    private class SourceAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
            SourceAttachmentBlock.this.attachmentChangeControlPressed(dialogField);
        }

        public void dialogFieldChanged(DialogField dialogField) {
            SourceAttachmentBlock.this.attachmentDialogFieldChanged(dialogField);
        }
    }
}

