/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class LinkFolderDialog
extends StatusDialog {
    private FolderNameField fFolderNameField;
    private LinkFields fDependenciesGroup;
    private IContainer fContainer;
    private IFolder fCreatedFolder;
    private boolean fCreateLink;
    private String fName;
    private String fTarget;

    public LinkFolderDialog(Shell shell, IContainer iContainer) {
        this(shell, iContainer, true);
    }

    public LinkFolderDialog(Shell shell, IContainer iContainer, boolean bl) {
        super(shell);
        this.fContainer = iContainer;
        this.fCreateLink = bl;
        this.setTitle(NewWizardMessages.LinkFolderDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public void setName(String string) {
        if (this.fFolderNameField != null) {
            this.fFolderNameField.setText(string);
        }
        this.fName = string;
    }

    public void setLinkTarget(String string) {
        if (this.fDependenciesGroup != null) {
            this.fDependenciesGroup.setLinkTarget(string);
        }
        this.fTarget = string;
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        int n = 3;
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = this.convertWidthInCharsToPixels(80);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText(Messages.format(NewWizardMessages.LinkFolderDialog_createIn, this.fContainer.getFullPath().makeRelative().toString()));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, n, 1));
        this.fDependenciesGroup = new LinkFields(composite2, n);
        if (this.fTarget != null) {
            this.fDependenciesGroup.setLinkTarget(this.fTarget);
        }
        this.fFolderNameField = new FolderNameField(composite2, n);
        if (this.fName != null) {
            this.fFolderNameField.setText(this.fName);
        }
        Validator validator = new Validator();
        this.fDependenciesGroup.addObserver(validator);
        this.fFolderNameField.addObserver(validator);
        return composite2;
    }

    private IFolder createFolderHandle(String string) {
        IWorkspaceRoot iWorkspaceRoot = this.fContainer.getWorkspace().getRoot();
        IPath iPath = this.fContainer.getFullPath().append(string);
        IFolder iFolder = iWorkspaceRoot.getFolder(iPath);
        return iFolder;
    }

    private IFolder createNewFolder(String string, String string2) {
        final IFolder iFolder = this.createFolderHandle(string);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    try {
                        iProgressMonitor.beginTask(NewWizardMessages.NewFolderDialog_progress, 2000);
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        iFolder.createLink(Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget()), 16, iProgressMonitor);
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        stringIndexOutOfBoundsException.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                JavaPlugin.log(new Exception(Messages.format("Exception in {0}.createNewFolder(): {1}", new Object[]{((Object)((Object)this)).getClass().getName(), invocationTargetException.getTargetException()})));
                MessageDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, (String)Messages.format(NewWizardMessages.NewFolderDialog_internalError, new Object[]{invocationTargetException.getTargetException().getMessage()}));
            }
            return null;
        }
        return iFolder;
    }

    protected void updateStatus(IStatus iStatus) {
        super.updateStatus(iStatus);
    }

    protected void okPressed() {
        if (this.fCreateLink) {
            String string = this.fDependenciesGroup.getLinkTarget();
            string = string.length() == 0 ? null : string;
            this.fCreatedFolder = this.createNewFolder(this.fFolderNameField.getText(), string);
        } else {
            this.fCreatedFolder = this.createFolderHandle(this.fFolderNameField.getText());
        }
        super.okPressed();
    }

    public IFolder getCreatedFolder() {
        return this.fCreatedFolder;
    }

    public IPath getLinkTarget() {
        return Path.fromOSString((String)this.fDependenciesGroup.getLinkTarget());
    }

    private final class FolderNameField
    extends Observable
    implements IDialogFieldListener {
        private StringDialogField fNameDialogField;

        public FolderNameField(Composite composite, int n) {
            this.createControls(composite, n);
        }

        private void createControls(Composite composite, int n) {
            this.fNameDialogField = new StringDialogField();
            this.fNameDialogField.setLabelText(NewWizardMessages.LinkFolderDialog_folderNameGroup_label);
            this.fNameDialogField.doFillIntoGrid(composite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
            LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), n);
            DialogField.createEmptySpace(composite, n - 1);
            this.fNameDialogField.setDialogFieldListener(this);
        }

        public StringDialogField getNameDialogField() {
            return this.fNameDialogField;
        }

        public void setText(String string) {
            this.fNameDialogField.setText(string);
            this.fNameDialogField.setFocus();
        }

        public String getText() {
            return this.fNameDialogField.getText();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.fireEvent();
        }
    }

    private final class LinkFields
    extends Observable
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private StringButtonDialogField fLinkLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.wst.jsdt.ui.last.external.project";

        public LinkFields(Composite composite, int n) {
            this.createControls(composite, n);
        }

        private void createControls(Composite composite, int n) {
            this.fLinkLocation = new StringButtonDialogField(this);
            this.fLinkLocation.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.LinkFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            SelectionButtonDialogField selectionButtonDialogField = new SelectionButtonDialogField(8);
            selectionButtonDialogField.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_variables_desc);
            selectionButtonDialogField.setDialogFieldListener(new IDialogFieldListener(this){
                final /* synthetic */ LinkFields this$1;
                {
                    this.this$1 = linkFields;
                }

                public void dialogFieldChanged(DialogField dialogField) {
                    LinkFields.access$0(this.this$1);
                }
            });
            this.fLinkLocation.doFillIntoGrid(composite, n);
            LayoutUtil.setHorizontalSpan((Control)this.fLinkLocation.getLabelControl(null), n);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            selectionButtonDialogField.doFillIntoGrid(composite, 1);
        }

        public String getLinkTarget() {
            return this.fLinkLocation.getText();
        }

        public void setLinkTarget(String string) {
            this.fLinkLocation.setText(string);
        }

        public void changeControlPressed(DialogField dialogField) {
            Object object;
            DirectoryDialog directoryDialog = new DirectoryDialog(LinkFolderDialog.this.getShell());
            directoryDialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String string = this.getLinkTarget().trim();
            if (string.length() == 0 && (object = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                string = object;
            }
            if (string.length() > 0 && ((File)(object = new File(string))).exists()) {
                directoryDialog.setFilterPath(string);
            }
            if ((object = directoryDialog.open()) != null) {
                this.fLinkLocation.setText((String)object);
                if (LinkFolderDialog.this.fName == null) {
                    LinkFolderDialog.this.fFolderNameField.setText(((String)object).substring(((String)object).lastIndexOf(File.separatorChar) + 1));
                }
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, (String)object);
            }
        }

        private void handleVariablesButtonPressed() {
            String[] stringArray;
            int n = 2;
            PathVariableSelectionDialog pathVariableSelectionDialog = new PathVariableSelectionDialog(LinkFolderDialog.this.getShell(), n);
            if (pathVariableSelectionDialog.open() == 0 && (stringArray = (String[])pathVariableSelectionDialog.getResult()) != null && stringArray.length == 1) {
                this.fLinkLocation.setText(stringArray[0]);
                if (LinkFolderDialog.this.fName == null) {
                    LinkFolderDialog.this.fFolderNameField.setText(stringArray[0]);
                }
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
            this.fireEvent();
        }

        private void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        static /* synthetic */ void access$0(LinkFields linkFields) {
            linkFields.handleVariablesButtonPressed();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable observable, Object object) {
            String string = LinkFolderDialog.this.fFolderNameField.getText();
            IStatus iStatus = this.validateFolderName(string);
            if (iStatus.matches(4)) {
                LinkFolderDialog.this.updateStatus(iStatus);
            } else {
                IStatus iStatus2 = this.validateLinkLocation(string);
                LinkFolderDialog.this.updateStatus(StatusUtil.getMoreSevere(iStatus, iStatus2));
            }
        }

        private IStatus validateLinkLocation(String string) {
            IWorkspace iWorkspace = JavaPlugin.getWorkspace();
            IPath iPath = Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget());
            IStatus iStatus = iWorkspace.validateLinkLocation((IResource)LinkFolderDialog.this.fContainer.getFolder((IPath)new Path(string)), iPath);
            if (iStatus.matches(4)) {
                return iStatus;
            }
            String string2 = this.resolveVariable();
            iPath = new Path(string2);
            File file = new Path(string2).toFile();
            if (file.exists()) {
                IStatus iStatus2 = this.validateFileType(file);
                if (!iStatus2.isOK()) {
                    return iStatus2;
                }
            } else if (iStatus.isOK()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
            }
            if (iStatus.isOK()) {
                return new StatusInfo();
            }
            return new StatusInfo(iStatus.getSeverity(), iStatus.getMessage());
        }

        private IStatus validateFileType(File file) {
            if (!file.isDirectory()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
            return new StatusInfo();
        }

        private String resolveVariable() {
            IPathVariableManager iPathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            IPath iPath = Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget());
            IPath iPath2 = iPathVariableManager.resolvePath(iPath);
            return iPath2.toOSString();
        }

        private IStatus validateFolderName(String string) {
            if (string.length() == 0) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_folderNameEmpty);
            }
            IStatus iStatus = LinkFolderDialog.this.fContainer.getWorkspace().validateName(string, 2);
            if (!iStatus.matches(4)) {
                return iStatus;
            }
            Path path = new Path(string);
            if (LinkFolderDialog.this.fContainer.findMember((IPath)path) != null) {
                return new StatusInfo(4, Messages.format(NewWizardMessages.NewFolderDialog_folderNameEmpty_alreadyExists, string));
            }
            return iStatus;
        }
    }
}

