/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.buildpath.IBuildpathModifierListener;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.ViewerPane;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorer;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.HintTextGroup;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class NewSourceContainerWorkbookPage
extends BuildPathBasePage
implements IBuildpathModifierListener {
    public static final String OPEN_SETTING = "org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.NewSourceContainerPage.openSetting";
    private ListDialogField fClassPathList;
    private HintTextGroup fHintTextGroup;
    private DialogPackageExplorer fPackageExplorer;
    private DialogPackageExplorerActionGroup fActionGroup;
    private IJavaProject fJavaProject;
    private final IRunnableContext fContext;
    private final BuildPathsBlock fBuildPathsBlock;

    public NewSourceContainerWorkbookPage(ListDialogField listDialogField, StringDialogField stringDialogField, IRunnableContext iRunnableContext, BuildPathsBlock buildPathsBlock) {
        this.fClassPathList = listDialogField;
        this.fContext = iRunnableContext;
        this.fBuildPathsBlock = buildPathsBlock;
        this.fPackageExplorer = new DialogPackageExplorer();
        this.fHintTextGroup = new HintTextGroup();
    }

    public void init(IJavaProject iJavaProject) {
        this.fJavaProject = iJavaProject;
        this.fPackageExplorer.addPostSelectionChangedListener(this.fHintTextGroup);
        this.fActionGroup.getResetAllAction().setBreakPoint(iJavaProject);
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NewSourceContainerWorkbookPage.this.doUpdateUI();
                }
            });
        }
    }

    private void doUpdateUI() {
        this.fPackageExplorer.setInput(this.fJavaProject);
        boolean bl = false;
        List list = this.fClassPathList.getElements();
        int n = 0;
        while (n < list.size() && !bl) {
            CPListElement cPListElement = (CPListElement)list.get(n);
            if (cPListElement.getEntryKind() == 3 && cPListElement.getAttribute("output") != null) {
                bl = true;
            }
            ++n;
        }
    }

    public void dispose() {
        if (this.fActionGroup != null) {
            this.fActionGroup.removeBuildpathModifierListener(this);
            this.fActionGroup = null;
        }
        this.fPackageExplorer.removePostSelectionChangedListener(this.fHintTextGroup);
        this.fPackageExplorer.dispose();
    }

    public Control getControl(Composite composite) {
        final int[] nArray = new int[]{60};
        final IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setDefault(OPEN_SETTING, true);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        Composite composite2 = scrolledPageContent.getBody();
        composite2.setLayout((Layout)new GridLayout());
        final SashForm sashForm = new SashForm(composite2, 512);
        sashForm.setFont(sashForm.getFont());
        ViewerPane viewerPane = new ViewerPane((Composite)sashForm, 0x800800);
        viewerPane.setContent(this.fPackageExplorer.createControl((Composite)viewerPane));
        this.fPackageExplorer.setContentProvider();
        final ExpandableComposite expandableComposite = new ExpandableComposite((Composite)sashForm, 0, 18);
        expandableComposite.setFont(sashForm.getFont());
        expandableComposite.setText(NewWizardMessages.NewSourceContainerWorkbookPage_HintTextGroup_title);
        boolean bl = iPreferenceStore.getBoolean(OPEN_SETTING);
        expandableComposite.setExpanded(bl);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                ScrolledPageContent scrolledPageContent = NewSourceContainerWorkbookPage.this.getParentScrolledComposite((Control)expandableComposite);
                if (scrolledPageContent != null) {
                    boolean bl = expandableComposite.isExpanded();
                    scrolledPageContent.reflow(true);
                    NewSourceContainerWorkbookPage.this.adjustSashForm(nArray, sashForm, bl);
                    iPreferenceStore.setValue(NewSourceContainerWorkbookPage.OPEN_SETTING, bl);
                }
            }
        });
        expandableComposite.setClient((Control)this.fHintTextGroup.createControl((Composite)expandableComposite));
        this.fActionGroup = new DialogPackageExplorerActionGroup(this.fHintTextGroup, this.fContext, this.fPackageExplorer, this);
        this.fActionGroup.addBuildpathModifierListener(this);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, false));
        ToolBarManager toolBarManager = this.fActionGroup.createLeftToolBarManager(viewerPane);
        viewerPane.setTopCenter(null);
        viewerPane.setTopLeft((Control)toolBarManager.getControl());
        toolBarManager = this.fActionGroup.createLeftToolBar(viewerPane);
        viewerPane.setTopRight((Control)toolBarManager.getControl());
        this.fHintTextGroup.setActionGroup(this.fActionGroup);
        this.fPackageExplorer.setActionGroup(this.fActionGroup);
        sashForm.setWeights(new int[]{60, 40});
        this.adjustSashForm(nArray, sashForm, expandableComposite.isExpanded());
        GridData gridData = new GridData(1808);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gridData);
        composite.layout(true);
        return scrolledPageContent;
    }

    private void adjustSashForm(int[] nArray, SashForm sashForm, boolean bl) {
        if (bl) {
            int n = nArray[0];
            sashForm.setWeights(new int[]{n, 100 - n});
        } else {
            nArray[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent)) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    public List getSelection() {
        ArrayList<CPListElement> arrayList = new ArrayList<CPListElement>();
        IJavaProject iJavaProject = this.fJavaProject;
        try {
            List list = ((StructuredSelection)this.fPackageExplorer.getSelection()).toList();
            List list2 = ClasspathModifier.getExistingEntries(iJavaProject);
            int n = 0;
            while (n < list.size()) {
                CPListElement cPListElement;
                IPackageFragmentRoot iPackageFragmentRoot;
                Object e = list.get(n);
                if (e instanceof IPackageFragmentRoot) {
                    iPackageFragmentRoot = (IPackageFragmentRoot)e;
                    cPListElement = ClasspathModifier.getClasspathEntry(list2, iPackageFragmentRoot);
                    arrayList.add(cPListElement);
                } else if (e instanceof IJavaProject && (iPackageFragmentRoot = ClasspathModifier.getClasspathEntryFor(iJavaProject.getPath(), iJavaProject, 3)) != null) {
                    cPListElement = CPListElement.createFromExisting((IClasspathEntry)iPackageFragmentRoot, iJavaProject);
                    arrayList.add(cPListElement);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return new ArrayList();
        }
        return arrayList;
    }

    public void setSelection(List list, boolean bl) {
        CPListElement cPListElement;
        Object object;
        if (list.size() == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < list.size()) {
            Object object2;
            object = list.get(n);
            if (object instanceof CPListElement) {
                object2 = (CPListElement)object;
                if (((CPListElement)object2).getEntryKind() == 3) {
                    arrayList.add(object2);
                }
            } else if (object instanceof CPListElementAttribute && (cPListElement = ((CPListElementAttribute)(object2 = (CPListElementAttribute)object)).getParent()).getEntryKind() == 3) {
                arrayList.add(cPListElement);
            }
            ++n;
        }
        List list2 = this.fClassPathList.getElements();
        object = new IClasspathEntry[list2.size()];
        int n2 = 0;
        while (n2 < list2.size()) {
            cPListElement = (CPListElement)list2.get(n2);
            object[n2] = cPListElement.getClasspathEntry();
            ++n2;
        }
        try {
            this.fJavaProject.setRawClasspath(object, null);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        this.fPackageExplorer.setSelection(arrayList);
    }

    public boolean isEntryKind(int n) {
        return n == 3;
    }

    public void buildpathChanged(BuildpathDelta buildpathDelta) {
    }

    public void commitDefaultOutputFolder() {
    }

    public void setFocus() {
        this.fPackageExplorer.getViewerControl().setFocus();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }
}

