/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class WorkingSetShowActionGroup
extends ActionGroup
implements IWorkingSetActionGroup {
    private List fContributions = new ArrayList();
    private ConfigureWorkingSetAction fConfigureWorkingSetAction;
    private WorkingSetModel fWorkingSetModel;
    private final IWorkbenchPartSite fSite;

    public WorkingSetShowActionGroup(IWorkbenchPartSite iWorkbenchPartSite) {
        Assert.isNotNull((Object)iWorkbenchPartSite);
        this.fSite = iWorkbenchPartSite;
    }

    public void setWorkingSetMode(WorkingSetModel workingSetModel) {
        Assert.isNotNull((Object)workingSetModel);
        this.fWorkingSetModel = workingSetModel;
        if (this.fConfigureWorkingSetAction != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        this.fillViewMenu(iMenuManager);
    }

    public void fillViewMenu(IMenuManager iMenuManager) {
        this.fConfigureWorkingSetAction = new ConfigureWorkingSetAction(this.fSite);
        if (this.fWorkingSetModel != null) {
            this.fConfigureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
        }
        this.addAction(iMenuManager, this.fConfigureWorkingSetAction);
    }

    public void cleanViewMenu(IMenuManager iMenuManager) {
        Iterator iterator = this.fContributions.iterator();
        while (iterator.hasNext()) {
            IContributionItem iContributionItem = iMenuManager.remove((IContributionItem)iterator.next());
            if (iContributionItem == null) continue;
            iContributionItem.dispose();
        }
        this.fContributions.clear();
    }

    private void addAction(IMenuManager iMenuManager, Action action) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        iMenuManager.appendToGroup("working_set_action_group", (IContributionItem)actionContributionItem);
        this.fContributions.add(actionContributionItem);
    }
}

