/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JREContainer;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;

public class JREContainerInitializer
extends ClasspathContainerInitializer {
    public static final String JsECMA_NAME = "JavaScript Language (ECMA-262)";

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        int n = iPath.segmentCount();
        if (n > 0 && iPath.segment(0).equals("org.eclipse.wst.jsdt.launching.JRE_CONTAINER")) {
            IVMInstall iVMInstall = JREContainerInitializer.resolveVM(iPath);
            JREContainer jREContainer = null;
            if (iVMInstall != null) {
                jREContainer = new JREContainer(iVMInstall, iPath);
            }
            JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{jREContainer}, null);
        }
    }

    public int getKind() {
        return 3;
    }

    public static IVMInstall resolveVM(IPath iPath) {
        IVMInstall iVMInstall = null;
        if (iPath.segmentCount() > 1) {
            String string = JREContainerInitializer.getExecutionEnvironmentId(iPath);
            if (string != null) {
                throw new UnimplementedException();
            }
            String string2 = JREContainerInitializer.getVMTypeId(iPath);
            String string3 = JREContainerInitializer.getVMName(iPath);
            IVMInstallType iVMInstallType = JavaRuntime.getVMInstallType(string2);
            if (iVMInstallType != null) {
                iVMInstall = iVMInstallType.findVMInstallByName(string3);
            }
        } else {
            iVMInstall = JavaRuntime.getDefaultVMInstall();
        }
        return iVMInstall;
    }

    public static String getExecutionEnvironmentId(IPath iPath) {
        if (iPath != null && iPath.lastSegment().equalsIgnoreCase("system.js")) {
            return JsECMA_NAME;
        }
        return null;
    }

    public static boolean isExecutionEnvironment(IPath iPath) {
        return JREContainerInitializer.getExecutionEnvironmentId(iPath) != null;
    }

    public static String encodeEnvironmentId(String string) {
        return string.replace('/', '%');
    }

    public static String decodeEnvironmentId(String string) {
        return string.replace('%', '/');
    }

    public static String getVMTypeId(IPath iPath) {
        return iPath.segment(1);
    }

    public static String getVMName(IPath iPath) {
        return iPath.segment(2);
    }

    public boolean canUpdateClasspathContainer(IPath iPath, IJavaProject iJavaProject) {
        return false;
    }

    public void requestClasspathContainerUpdate(IPath iPath, IJavaProject iJavaProject, IClasspathContainer iClasspathContainer) throws CoreException {
    }

    public String getDescription(IPath iPath, IJavaProject iJavaProject) {
        if (iPath != null && iPath.lastSegment().equalsIgnoreCase("system.js")) {
            return JsECMA_NAME;
        }
        return LaunchingMessages.JREContainerInitializer_Default_System_Library_1;
    }

    public LibraryLocation getLibraryLocation() {
        return new SystemLibraryLocation();
    }

    public boolean allowAttachJsDoc() {
        return false;
    }

    public String[] containerSuperTypes() {
        return new String[]{"Global", "Object", "Array"};
    }
}

