/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class JavaElementComparator
extends ViewerComparator {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int COMPILATIONUNITS = 4;
    private static final int CLASSFILES = 5;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
    static /* synthetic */ Class class$0;

    public JavaElementComparator() {
        super(null);
    }

    public int category(Object object) {
        if (object instanceof IJavaElement) {
            block28: {
                try {
                    IJavaElement iJavaElement = (IJavaElement)object;
                    switch (iJavaElement.getElementType()) {
                        case 9: {
                            IMethod iMethod = (IMethod)iJavaElement;
                            if (iMethod.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            int n = iMethod.getFlags();
                            if (Flags.isStatic((int)n)) {
                                return this.getMemberCategory(7);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            int n = ((IField)iJavaElement).getFlags();
                            if (Flags.isEnum((int)n)) {
                                return this.getMemberCategory(8);
                            }
                            if (Flags.isStatic((int)n)) {
                                return this.getMemberCategory(5);
                            }
                            return this.getMemberCategory(3);
                        }
                        case 10: {
                            int n = ((IInitializer)iJavaElement).getFlags();
                            if (Flags.isStatic((int)n)) {
                                return this.getMemberCategory(6);
                            }
                            return this.getMemberCategory(4);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 11: {
                            return 10;
                        }
                        case 12: {
                            return 11;
                        }
                        case 13: {
                            return 12;
                        }
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 6: {
                            return 5;
                        }
                        case 5: {
                            return 4;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (javaModelException.isDoesNotExist()) break block28;
                    JavaPlugin.log(javaModelException);
                }
            }
            return 50;
        }
        if (object instanceof IFile) {
            return 8;
        }
        if (object instanceof IProject) {
            return 1;
        }
        if (object instanceof IContainer) {
            return 7;
        }
        if (object instanceof IJarEntryResource) {
            if (((IJarEntryResource)object).isFile()) {
                return 8;
            }
            return 7;
        }
        if (object instanceof PackageFragmentRootContainer) {
            return 2;
        }
        return 51;
    }

    private int getMemberCategory(int n) {
        int n2 = this.fMemberOrderCache.getCategoryIndex(n);
        return n2 + 15;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n;
        Object object3;
        Object object4;
        int n2;
        int n3 = this.category(object);
        if (this.needsClasspathComparision(object, n3, object2, n2 = this.category(object2))) {
            int n4;
            object4 = this.getPackageFragmentRoot(object);
            object3 = this.getPackageFragmentRoot(object2);
            if (object4 == null) {
                if (object3 == null) {
                    return 0;
                }
                return 1;
            }
            if (object3 == null) {
                return -1;
            }
            if (!object4.getPath().equals((Object)object3.getPath()) && (n = this.getClassPathIndex((IPackageFragmentRoot)object4)) != (n4 = this.getClassPathIndex((IPackageFragmentRoot)object3))) {
                return n - n4;
            }
        }
        if (n3 != n2) {
            return n3 - n2;
        }
        if (n3 == 1 || n3 == 8 || n3 == 7 || n3 == 51) {
            object4 = this.getNonJavaElementLabel(viewer, object);
            object3 = this.getNonJavaElementLabel(viewer, object2);
            if (object4 != null && object3 != null) {
                return this.getComparator().compare(object4, object3);
            }
            return 0;
        }
        if (object instanceof IMember && this.fMemberOrderCache.isSortByVisibility()) {
            try {
                int n5 = JdtFlags.getVisibilityCode((IMember)object);
                int n6 = JdtFlags.getVisibilityCode((IMember)object2);
                n = this.fMemberOrderCache.getVisibilityIndex(n5) - this.fMemberOrderCache.getVisibilityIndex(n6);
                if (n != 0) {
                    return n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        object4 = this.getElementName(object);
        object3 = this.getElementName(object2);
        if (object instanceof IType) {
            if (((String)object4).length() == 0) {
                if (((String)object3).length() == 0) {
                    try {
                        return this.getComparator().compare(((IType)object).getSuperclassName(), ((IType)object2).getSuperclassName());
                    }
                    catch (JavaModelException javaModelException) {
                        return 0;
                    }
                }
                return 1;
            }
            if (((String)object3).length() == 0) {
                return -1;
            }
        }
        if ((n = this.getComparator().compare(object4, object3)) != 0) {
            return n;
        }
        if (object instanceof IMethod) {
            String[] stringArray = ((IMethod)object).getParameterTypes();
            String[] stringArray2 = ((IMethod)object2).getParameterTypes();
            int n7 = Math.min(stringArray.length, stringArray2.length);
            int n8 = 0;
            while (n8 < n7) {
                n = this.getComparator().compare(Signature.toString((String)stringArray[n8]), Signature.toString((String)stringArray2[n8]));
                if (n != 0) {
                    return n;
                }
                ++n8;
            }
            return stringArray.length - stringArray2.length;
        }
        return 0;
    }

    private IPackageFragmentRoot getPackageFragmentRoot(Object object) {
        if (object instanceof PackageFragmentRootContainer) {
            PackageFragmentRootContainer packageFragmentRootContainer = (PackageFragmentRootContainer)object;
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRootContainer.getPackageFragmentRoots();
            if (iPackageFragmentRootArray.length > 0) {
                return iPackageFragmentRootArray[0];
            }
            return null;
        }
        return JavaModelUtil.getPackageFragmentRoot((IJavaElement)object);
    }

    private String getNonJavaElementLabel(Viewer viewer, Object object) {
        IBaseLabelProvider iBaseLabelProvider;
        if (object instanceof IResource) {
            return ((IResource)object).getName();
        }
        if (object instanceof IStorage) {
            return ((IStorage)object).getName();
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBaseLabelProvider = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iBaseLabelProvider.getLabel(object);
            }
        }
        if (viewer instanceof ContentViewer && (iBaseLabelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)iBaseLabelProvider).getText(object);
        }
        return null;
    }

    private int getClassPathIndex(IPackageFragmentRoot iPackageFragmentRoot) {
        try {
            IPath iPath = iPackageFragmentRoot.getPath();
            IPackageFragmentRoot[] iPackageFragmentRootArray = iPackageFragmentRoot.getJavaProject().getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (iPackageFragmentRootArray[n].getPath().equals((Object)iPath)) {
                    return n;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        return Integer.MAX_VALUE;
    }

    private boolean needsClasspathComparision(Object object, int n, Object object2, int n2) {
        if (n == 2 && n2 == 2 || n == 3 && ((IPackageFragment)object).getParent().getResource() instanceof IProject && n2 == 2 || n == 2 && n2 == 3 && ((IPackageFragment)object2).getParent().getResource() instanceof IProject) {
            IJavaProject iJavaProject = this.getJavaProject(object);
            return iJavaProject != null && iJavaProject.equals(this.getJavaProject(object2));
        }
        return false;
    }

    private IJavaProject getJavaProject(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getJavaProject();
        }
        if (object instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)object).getJavaProject();
        }
        return null;
    }

    private String getElementName(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getElementName();
        }
        if (object instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)object).getLabel();
        }
        return object.toString();
    }
}

