/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaElementLabels {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_PRE_TYPE_PARAMETERS = 4L;
    public static final long M_APP_TYPE_PARAMETERS = 8L;
    public static final long M_EXCEPTIONS = 16L;
    public static final long M_APP_RETURNTYPE = 32L;
    public static final long M_PRE_RETURNTYPE = 64L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_APP_TYPE_SIGNATURE = 16384L;
    public static final long F_PRE_TYPE_SIGNATURE = 32768L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long SHOW_TYPE = 0x10000000000000L;
    public static final long ALL_CATEGORY = new Long(0xE000000000000L);
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471364126976L);
    public static final long ALL_DEFAULT = new Long(0x200009L);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4598139136L);
    public static final String CONCAT_STRING = JavaUIMessages.JavaElementLabels_concat_string;
    public static final String COMMA_STRING = JavaUIMessages.JavaElementLabels_comma_string;
    public static final String DECL_STRING = JavaUIMessages.JavaElementLabels_declseparator_string;
    private static final String CATEGORY_SEPARATOR_STRING = JavaUIMessages.JavaElementLabels_category_separator_string;
    public static final String ELLIPSIS_STRING = "...";
    public static final String DEFAULT_PACKAGE = JavaUIMessages.JavaElementLabels_default_package;
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    static /* synthetic */ Class class$0;

    static {
        fgPkgNameLength = -1;
    }

    private JavaElementLabels() {
    }

    private static final boolean getFlag(long l, long l2) {
        return (l & l2) != 0L;
    }

    public static String getTextLabel(Object object, long l) {
        if (object instanceof IJavaElement) {
            return JavaElementLabels.getElementLabel((IJavaElement)object, l);
        }
        if (object instanceof IResource) {
            return ((IResource)object).getName();
        }
        if (object instanceof IStorage) {
            StorageLabelProvider storageLabelProvider = new StorageLabelProvider();
            String string = storageLabelProvider.getText(object);
            storageLabelProvider.dispose();
            return string;
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        }
        return "";
    }

    public static String getElementLabel(IJavaElement iJavaElement, long l) {
        StringBuffer stringBuffer = new StringBuffer(60);
        JavaElementLabels.getElementLabel(iJavaElement, l, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getElementLabel(IJavaElement iJavaElement, long l, StringBuffer stringBuffer) {
        int n = iJavaElement.getElementType();
        IPackageFragmentRoot iPackageFragmentRoot = null;
        if (n != 1 && n != 2 && n != 3) {
            iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot(iJavaElement);
        }
        if (iPackageFragmentRoot != null && JavaElementLabels.getFlag(l, 0x100000000000L)) {
            JavaElementLabels.getPackageFragmentRootLabel(iPackageFragmentRoot, 0x20000000000L, stringBuffer);
            stringBuffer.append(CONCAT_STRING);
        }
        switch (n) {
            case 9: {
                JavaElementLabels.getMethodLabel((IMethod)iJavaElement, l, stringBuffer);
                break;
            }
            case 8: {
                JavaElementLabels.getFieldLabel((IField)iJavaElement, l, stringBuffer);
                break;
            }
            case 14: {
                JavaElementLabels.getLocalVariableLabel((ILocalVariable)iJavaElement, l, stringBuffer);
                break;
            }
            case 10: {
                JavaElementLabels.getInitializerLabel((IInitializer)iJavaElement, l, stringBuffer);
                break;
            }
            case 7: {
                JavaElementLabels.getTypeLabel((IType)iJavaElement, l, stringBuffer);
                break;
            }
            case 6: {
                JavaElementLabels.getClassFileLabel((IClassFile)iJavaElement, l, stringBuffer);
                break;
            }
            case 5: {
                JavaElementLabels.getCompilationUnitLabel((ICompilationUnit)iJavaElement, l, stringBuffer);
                break;
            }
            case 4: {
                JavaElementLabels.getPackageFragmentLabel((IPackageFragment)iJavaElement, l, stringBuffer);
                break;
            }
            case 3: {
                JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)iJavaElement, l, stringBuffer);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                JavaElementLabels.getDeclarationLabel(iJavaElement, l, stringBuffer);
                break;
            }
            case 1: 
            case 2: {
                stringBuffer.append(iJavaElement.getDisplayName());
                break;
            }
            default: {
                stringBuffer.append(iJavaElement.getDisplayName());
            }
        }
        if (iPackageFragmentRoot != null && JavaElementLabels.getFlag(l, 0x80000000000L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel(iPackageFragmentRoot, 0x20000000000L, stringBuffer);
        }
    }

    public static void getMethodLabel(IMethod iMethod, long l, StringBuffer stringBuffer) {
        try {
            int n;
            Object object;
            Object object2;
            String string;
            BindingKey bindingKey = JavaElementLabels.getFlag(l, 0x1000000000000L) && iMethod.isResolved() ? new BindingKey(iMethod.getKey()) : null;
            String string2 = string = bindingKey != null ? bindingKey.toSignature() : null;
            if (JavaElementLabels.getFlag(l, 4L)) {
                if (bindingKey != null) {
                    if (bindingKey.isParameterizedMethod()) {
                        object2 = bindingKey.getTypeArguments();
                        if (((String[])object2).length > 0) {
                            JavaElementLabels.getTypeArgumentSignaturesLabel(object2, l, stringBuffer);
                            stringBuffer.append(' ');
                        }
                    } else {
                        object2 = Signature.getTypeParameters((String)string);
                        if (((String[])object2).length > 0) {
                            JavaElementLabels.getTypeParameterSignaturesLabel(object2, l, stringBuffer);
                            stringBuffer.append(' ');
                        }
                    }
                } else if (iMethod.exists() && ((String[])(object2 = iMethod.getTypeParameters())).length > 0) {
                    JavaElementLabels.getTypeParametersLabel((ITypeParameter[])object2, l, stringBuffer);
                    stringBuffer.append(' ');
                }
            }
            if (JavaElementLabels.getFlag(l, 64L) && iMethod.exists() && !iMethod.isConstructor()) {
                object2 = string != null ? Signature.getReturnType((String)string) : iMethod.getReturnType();
                JavaElementLabels.getTypeSignatureLabel((String)object2, l, stringBuffer);
                stringBuffer.append(' ');
            }
            object2 = iMethod.getDeclaringType();
            if (JavaElementLabels.getFlag(l, 128L)) {
                if (object2 != null) {
                    JavaElementLabels.getTypeLabel(iMethod.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
                    stringBuffer.append('.');
                } else {
                    stringBuffer.append('[');
                    JavaElementLabels.getFileLabel((IMember)iMethod, 0x40000L | l & 0x1002000000000L, stringBuffer);
                    stringBuffer.append(']');
                }
            }
            stringBuffer.append(iMethod.getDisplayName());
            stringBuffer.append('(');
            if (JavaElementLabels.getFlag(l, 3L)) {
                object = null;
                n = 0;
                boolean bl = false;
                if (JavaElementLabels.getFlag(l, 1L) && JavaElementLabels.getFlag(l, 0x10000000000000L)) {
                    object = string != null ? Signature.getParameterTypes((String)string) : iMethod.getParameterTypes();
                    n = ((String[])object).length;
                    bl = iMethod.exists() && Flags.isVarargs((int)iMethod.getFlags());
                }
                String[] stringArray = null;
                if (JavaElementLabels.getFlag(l, 2L) && iMethod.exists()) {
                    stringArray = iMethod.getParameterNames();
                    if (object == null) {
                        n = stringArray.length;
                    } else if (n != stringArray.length) {
                        if (string != null && ((String[])object).length > stringArray.length) {
                            n = stringArray.length;
                            String[] stringArray2 = new String[n];
                            System.arraycopy(object, ((String[])object).length - n, stringArray2, 0, n);
                            object = stringArray2;
                        } else {
                            stringArray = null;
                        }
                    }
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(COMMA_STRING);
                    }
                    if (object != null) {
                        String string3 = object[n2];
                        if (bl && n2 == n - 1) {
                            int n3 = Signature.getArrayCount((String)string3) - 1;
                            JavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)string3), l, stringBuffer);
                            int n4 = 0;
                            while (n4 < n3) {
                                stringBuffer.append('[').append(']');
                                ++n4;
                            }
                            stringBuffer.append(ELLIPSIS_STRING);
                        } else {
                            JavaElementLabels.getTypeSignatureLabel(string3, l, stringBuffer);
                        }
                    }
                    if (stringArray != null) {
                        if (object != null) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(stringArray[n2]);
                    }
                    ++n2;
                }
            } else if (iMethod.getParameterTypes().length > 0) {
                stringBuffer.append(ELLIPSIS_STRING);
            }
            stringBuffer.append(')');
            if (JavaElementLabels.getFlag(l, 16L)) {
                if (bindingKey != null) {
                    object = bindingKey.getThrownExceptions();
                } else {
                    String[] stringArray = object = iMethod.exists() ? iMethod.getExceptionTypes() : new String[]{};
                }
                if (((String[])object).length > 0) {
                    stringBuffer.append(" throws ");
                    n = 0;
                    while (n < ((String[])object).length) {
                        if (n > 0) {
                            stringBuffer.append(COMMA_STRING);
                        }
                        JavaElementLabels.getTypeSignatureLabel(object[n], l, stringBuffer);
                        ++n;
                    }
                }
            }
            if (JavaElementLabels.getFlag(l, 8L)) {
                if (bindingKey != null) {
                    if (bindingKey.isParameterizedMethod()) {
                        object = bindingKey.getTypeArguments();
                        if (((String[])object).length > 0) {
                            stringBuffer.append(' ');
                            JavaElementLabels.getTypeArgumentSignaturesLabel(object, l, stringBuffer);
                        }
                    } else {
                        object = Signature.getTypeParameters((String)string);
                        if (((String[])object).length > 0) {
                            stringBuffer.append(' ');
                            JavaElementLabels.getTypeParameterSignaturesLabel(object, l, stringBuffer);
                        }
                    }
                } else if (iMethod.exists() && ((String[])(object = iMethod.getTypeParameters())).length > 0) {
                    stringBuffer.append(' ');
                    JavaElementLabels.getTypeParametersLabel((ITypeParameter[])object, l, stringBuffer);
                }
            }
            if (JavaElementLabels.getFlag(l, 32L) && iMethod.exists() && !iMethod.isConstructor() && iMethod.getReturnType() != null) {
                stringBuffer.append(DECL_STRING);
                object = string != null ? Signature.getReturnType((String)string) : iMethod.getReturnType();
                JavaElementLabels.getTypeSignatureLabel((String)object, l, stringBuffer);
            }
            if (JavaElementLabels.getFlag(l, 0x4000000000000L) && iMethod.exists()) {
                JavaElementLabels.getCategoryLabel((IMember)iMethod, stringBuffer);
            }
            if (JavaElementLabels.getFlag(l, 256L)) {
                stringBuffer.append(CONCAT_STRING);
                if (object2 != null) {
                    JavaElementLabels.getTypeLabel(iMethod.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
                } else {
                    JavaElementLabels.getFileLabel((IMember)iMethod, 0x40000L | l & 0x1002000000000L, stringBuffer);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    private static void getCategoryLabel(IMember iMember, StringBuffer stringBuffer) throws JavaModelException {
        String[] stringArray = iMember.getCategories();
        if (stringArray.length > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(30);
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer2.append(CATEGORY_SEPARATOR_STRING);
                }
                stringBuffer2.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append(CONCAT_STRING);
            stringBuffer.append(Messages.format(JavaUIMessages.JavaElementLabels_category, stringBuffer2.toString()));
        }
    }

    private static void getTypeParametersLabel(ITypeParameter[] iTypeParameterArray, long l, StringBuffer stringBuffer) {
        if (iTypeParameterArray.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            while (n < iTypeParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(COMMA_STRING);
                }
                stringBuffer.append(iTypeParameterArray[n].getDisplayName());
                ++n;
            }
            stringBuffer.append('>');
        }
    }

    public static void getFieldLabel(IField iField, long l, StringBuffer stringBuffer) {
        try {
            if (JavaElementLabels.getFlag(l, 32768L) && iField.exists() && !Flags.isEnum((int)iField.getFlags())) {
                if (JavaElementLabels.getFlag(l, 0x1000000000000L) && iField.isResolved()) {
                    JavaElementLabels.getTypeSignatureLabel(new BindingKey(iField.getKey()).toSignature(), l, stringBuffer);
                } else {
                    JavaElementLabels.getTypeSignatureLabel(iField.getTypeSignature(), l, stringBuffer);
                }
                stringBuffer.append(' ');
            }
            IType iType = iField.getDeclaringType();
            if (JavaElementLabels.getFlag(l, 65536L)) {
                if (iType != null) {
                    JavaElementLabels.getTypeLabel(iType, 0x40000L | l & 0x1002000000000L, stringBuffer);
                } else {
                    JavaElementLabels.getFileLabel((IMember)iField, 0x40000L | l & 0x1002000000000L, stringBuffer);
                }
                stringBuffer.append('.');
            }
            stringBuffer.append(iField.getDisplayName());
            if (JavaElementLabels.getFlag(l, 16384L) && iField.exists() && !Flags.isEnum((int)iField.getFlags()) && iField.getTypeSignature() != null) {
                stringBuffer.append(DECL_STRING);
                if (JavaElementLabels.getFlag(l, 0x1000000000000L) && iField.isResolved()) {
                    JavaElementLabels.getTypeSignatureLabel(new BindingKey(iField.getKey()).toSignature(), l, stringBuffer);
                } else {
                    JavaElementLabels.getTypeSignatureLabel(iField.getTypeSignature(), l, stringBuffer);
                }
            }
            if (JavaElementLabels.getFlag(l, 0x2000000000000L) && iField.exists()) {
                JavaElementLabels.getCategoryLabel((IMember)iField, stringBuffer);
            }
            if (JavaElementLabels.getFlag(l, 131072L)) {
                stringBuffer.append(CONCAT_STRING);
                if (iType != null) {
                    JavaElementLabels.getTypeLabel(iType, 0x40000L | l & 0x1002000000000L, stringBuffer);
                } else {
                    JavaElementLabels.getFileLabel((IMember)iField, 0x40000L | l & 0x1002000000000L, stringBuffer);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    public static void getLocalVariableLabel(ILocalVariable iLocalVariable, long l, StringBuffer stringBuffer) {
        if (JavaElementLabels.getFlag(l, 32768L)) {
            JavaElementLabels.getTypeSignatureLabel(iLocalVariable.getTypeSignature(), l, stringBuffer);
            stringBuffer.append(' ');
        }
        if (JavaElementLabels.getFlag(l, 65536L)) {
            JavaElementLabels.getElementLabel(iLocalVariable.getParent(), 0x40081L | l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iLocalVariable.getDisplayName());
        if (JavaElementLabels.getFlag(l, 16384L)) {
            stringBuffer.append(DECL_STRING);
            JavaElementLabels.getTypeSignatureLabel(iLocalVariable.getTypeSignature(), l, stringBuffer);
        }
        if (JavaElementLabels.getFlag(l, 131072L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getElementLabel(iLocalVariable.getParent(), 0x40081L | l & 0x1002000000000L, stringBuffer);
        }
    }

    public static void getInitializerLabel(IInitializer iInitializer, long l, StringBuffer stringBuffer) {
        if (JavaElementLabels.getFlag(l, 1024L)) {
            JavaElementLabels.getTypeLabel(iInitializer.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(JavaUIMessages.JavaElementLabels_initializer);
        if (JavaElementLabels.getFlag(l, 2048L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getTypeLabel(iInitializer.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
        }
    }

    private static void getTypeSignatureLabel(String string, long l, StringBuffer stringBuffer) {
        int n = Signature.getTypeSignatureKind((String)string);
        switch (n) {
            case 2: {
                if (!JavaElementLabels.getFlag(l, 0x10000000000000L)) break;
                stringBuffer.append(Signature.toString((String)string));
                break;
            }
            case 4: {
                JavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)string), l, stringBuffer);
                int n2 = Signature.getArrayCount((String)string);
                while (n2 > 0) {
                    stringBuffer.append('[').append(']');
                    --n2;
                }
                break;
            }
            case 1: {
                String string2 = Signature.toString((String)Signature.getTypeErasure((String)string));
                Util.insertTypeLabel((String)Signature.getSimpleName((String)string2), (StringBuffer)stringBuffer);
                String[] stringArray = Signature.getTypeArguments((String)string);
                JavaElementLabels.getTypeArgumentSignaturesLabel(stringArray, l, stringBuffer);
                break;
            }
            case 3: {
                stringBuffer.append(Signature.toString((String)string));
                break;
            }
            case 5: {
                char c = string.charAt(0);
                if (c == '*') {
                    stringBuffer.append('?');
                    break;
                }
                if (c == '+') {
                    stringBuffer.append("? extends ");
                    JavaElementLabels.getTypeSignatureLabel(string.substring(1), l, stringBuffer);
                    break;
                }
                if (c != '-') break;
                stringBuffer.append("? super ");
                JavaElementLabels.getTypeSignatureLabel(string.substring(1), l, stringBuffer);
                break;
            }
            case 6: {
                JavaElementLabels.getTypeSignatureLabel(string.substring(1), l, stringBuffer);
            }
        }
    }

    private static void getTypeArgumentSignaturesLabel(String[] stringArray, long l, StringBuffer stringBuffer) {
        if (stringArray.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(COMMA_STRING);
                }
                JavaElementLabels.getTypeSignatureLabel(stringArray[n], l, stringBuffer);
                ++n;
            }
            stringBuffer.append('>');
        }
    }

    private static void getTypeParameterSignaturesLabel(String[] stringArray, long l, StringBuffer stringBuffer) {
        if (stringArray.length > 0) {
            stringBuffer.append('<');
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(COMMA_STRING);
                }
                stringBuffer.append(Signature.getTypeVariable((String)stringArray[n]));
                ++n;
            }
            stringBuffer.append('>');
        }
    }

    public static void getTypeLabel(IType iType, long l, StringBuffer stringBuffer) {
        String[] stringArray;
        Object object;
        if (JavaElementLabels.getFlag(l, 262144L) && !(object = iType.getPackageFragment()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)object, l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        if (JavaElementLabels.getFlag(l, 786432L)) {
            int n;
            object = iType.getDeclaringType();
            if (object != null) {
                JavaElementLabels.getTypeLabel((IType)object, 0x80000L | l & 0x1002000000000L, stringBuffer);
                stringBuffer.append('.');
            }
            if ((n = iType.getParent().getElementType()) == 9 || n == 8 || n == 10) {
                JavaElementLabels.getElementLabel(iType.getParent(), 0L, stringBuffer);
                stringBuffer.append('.');
            }
        }
        if (((String)(object = iType.getDisplayName())).length() == 0) {
            try {
                if (iType.getParent() instanceof IField && iType.isEnum()) {
                    object = "{...}";
                } else {
                    stringArray = iType.getSuperInterfaceNames();
                    String string = stringArray.length > 0 ? Signature.getSimpleName((String)stringArray[0]) : Signature.getSimpleName((String)iType.getSuperclassName());
                    object = Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, string);
                }
            }
            catch (JavaModelException javaModelException) {
                object = JavaUIMessages.JavaElementLabels_anonym;
            }
        }
        stringBuffer.append((String)object);
        if (JavaElementLabels.getFlag(l, 0x200000L)) {
            if (JavaElementLabels.getFlag(l, 0x1000000000000L) && iType.isResolved()) {
                BindingKey bindingKey = new BindingKey(iType.getKey());
                if (bindingKey.isParameterizedType()) {
                    stringArray = bindingKey.getTypeArguments();
                    JavaElementLabels.getTypeArgumentSignaturesLabel(stringArray, l, stringBuffer);
                } else {
                    stringArray = Signature.getTypeParameters((String)bindingKey.toSignature());
                    JavaElementLabels.getTypeParameterSignaturesLabel(stringArray, l, stringBuffer);
                }
            } else if (iType.exists()) {
                try {
                    JavaElementLabels.getTypeParametersLabel(iType.getTypeParameters(), l, stringBuffer);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (JavaElementLabels.getFlag(l, 0x8000000000000L) && iType.exists()) {
            try {
                JavaElementLabels.getCategoryLabel((IMember)iType, stringBuffer);
            }
            catch (JavaModelException javaModelException) {}
        }
        if (JavaElementLabels.getFlag(l, 0x100000L)) {
            stringBuffer.append(CONCAT_STRING);
            IType iType2 = iType.getDeclaringType();
            if (iType2 != null) {
                JavaElementLabels.getTypeLabel(iType2, 0x40000L | l & 0x1002000000000L, stringBuffer);
                int n = iType.getParent().getElementType();
                if (n == 9 || n == 8 || n == 10) {
                    stringBuffer.append('.');
                    JavaElementLabels.getElementLabel(iType.getParent(), 0L, stringBuffer);
                }
            } else {
                JavaElementLabels.getPackageFragmentLabel(iType.getPackageFragment(), l & 0x1002000000000L, stringBuffer);
            }
        }
    }

    public static void getDeclarationLabel(IJavaElement iJavaElement, long l, StringBuffer stringBuffer) {
        IJavaElement iJavaElement2;
        if (JavaElementLabels.getFlag(l, 0x1000000L) && (iJavaElement2 = (IJavaElement)iJavaElement.getOpenable()) != null) {
            stringBuffer.append(JavaElementLabels.getElementLabel(iJavaElement2, 0x88000000L | l & 0x1002000000000L));
            stringBuffer.append('/');
        }
        if (iJavaElement.getElementType() == 12) {
            stringBuffer.append(JavaUIMessages.JavaElementLabels_import_container);
        } else {
            stringBuffer.append(iJavaElement.getDisplayName());
        }
        if (JavaElementLabels.getFlag(l, 0x2000000L) && (iJavaElement2 = (IJavaElement)iJavaElement.getOpenable()) != null) {
            stringBuffer.append(CONCAT_STRING);
            stringBuffer.append(JavaElementLabels.getElementLabel(iJavaElement2, 0x88000000L | l & 0x1002000000000L));
        }
    }

    public static void getClassFileLabel(IClassFile iClassFile, long l, StringBuffer stringBuffer) {
        IPackageFragment iPackageFragment;
        if (JavaElementLabels.getFlag(l, 0x8000000L) && !(iPackageFragment = (IPackageFragment)iClassFile.getParent()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel(iPackageFragment, l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iClassFile.getDisplayName());
        if (JavaElementLabels.getFlag(l, 0x10000000L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)iClassFile.getParent(), l & 0x1002000000000L, stringBuffer);
        }
    }

    public static void getCompilationUnitLabel(ICompilationUnit iCompilationUnit, long l, StringBuffer stringBuffer) {
        IPackageFragment iPackageFragment;
        if (JavaElementLabels.getFlag(l, 0x80000000L) && !(iPackageFragment = (IPackageFragment)iCompilationUnit.getParent()).isDefaultPackage()) {
            JavaElementLabels.getPackageFragmentLabel(iPackageFragment, l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iCompilationUnit.getDisplayName());
        if (JavaElementLabels.getFlag(l, 0x100000000L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)iCompilationUnit.getParent(), l & 0x1002000000000L, stringBuffer);
        }
    }

    public static void getFileLabel(IMember iMember, long l, StringBuffer stringBuffer) {
        ICompilationUnit iCompilationUnit = iMember.getCompilationUnit();
        if (iCompilationUnit != null) {
            JavaElementLabels.getCompilationUnitLabel(iCompilationUnit, l, stringBuffer);
        } else {
            IClassFile iClassFile = iMember.getClassFile();
            if (iClassFile != null) {
                JavaElementLabels.getClassFileLabel(iClassFile, l, stringBuffer);
            }
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment iPackageFragment, long l, StringBuffer stringBuffer) {
        if (JavaElementLabels.getFlag(l, 0x800000000L)) {
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)iPackageFragment.getParent(), 0x20000000000L, stringBuffer);
            stringBuffer.append('/');
        }
        JavaElementLabels.refreshPackageNamePattern();
        if (iPackageFragment.isDefaultPackage()) {
            stringBuffer.append(DEFAULT_PACKAGE);
        } else if (JavaElementLabels.getFlag(l, 0x2000000000L) && fgPkgNameLength >= 0) {
            String string = iPackageFragment.getDisplayName();
            int n = 0;
            int n2 = string.indexOf(46, n);
            while (n2 > 0) {
                if (n2 - n > fgPkgNameLength - 1) {
                    stringBuffer.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        stringBuffer.append(string.substring(n, Math.min(n + fgPkgNameChars, n2)));
                    }
                    stringBuffer.append(fgPkgNamePostfix);
                } else {
                    stringBuffer.append(string.substring(n, n2 + 1));
                }
                n = n2 + 1;
                n2 = string.indexOf(46, n);
            }
            stringBuffer.append(string.substring(n));
        } else {
            stringBuffer.append(iPackageFragment.getDisplayName());
        }
        if (JavaElementLabels.getFlag(l, 0x1000000000L)) {
            stringBuffer.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)iPackageFragment.getParent(), 0x20000000000L, stringBuffer);
        }
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        if (iPackageFragmentRoot.isArchive()) {
            JavaElementLabels.getArchiveLabel(iPackageFragmentRoot, l, stringBuffer);
        } else {
            JavaElementLabels.getFolderLabel(iPackageFragmentRoot, l, stringBuffer);
        }
    }

    private static void getArchiveLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        if (JavaElementLabels.getFlag(l, 0x10000000000L) && JavaElementLabels.getVariableLabel(iPackageFragmentRoot, l, stringBuffer)) {
            return;
        }
        boolean bl = iPackageFragmentRoot.isExternal();
        if (bl) {
            JavaElementLabels.getExternalArchiveLabel(iPackageFragmentRoot, l, stringBuffer);
        } else {
            JavaElementLabels.getInternalArchiveLabel(iPackageFragmentRoot, l, stringBuffer);
        }
    }

    private static boolean getVariableLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        try {
            IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
            if (iClasspathEntry != null && iClasspathEntry.getEntryKind() == 4) {
                IPath iPath = iClasspathEntry.getPath().makeRelative();
                if (JavaElementLabels.getFlag(l, 0x200000000000L)) {
                    int n = iPath.segmentCount();
                    if (n > 0) {
                        stringBuffer.append(iPath.segment(n - 1));
                        if (n > 1) {
                            stringBuffer.append(CONCAT_STRING);
                            stringBuffer.append(iPath.removeLastSegments(1).toOSString());
                        }
                    } else {
                        stringBuffer.append(iPath.toString());
                    }
                } else {
                    stringBuffer.append(iPath.toString());
                }
                stringBuffer.append(CONCAT_STRING);
                if (iPackageFragmentRoot.isExternal()) {
                    stringBuffer.append(iPackageFragmentRoot.getPath().toOSString());
                } else {
                    stringBuffer.append(iPackageFragmentRoot.getPath().makeRelative().toString());
                }
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return false;
    }

    private static void getExternalArchiveLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        IPath iPath = iPackageFragmentRoot.getPath();
        if (JavaElementLabels.getFlag(l, 0x200000000000L)) {
            int n = iPath.segmentCount();
            if (n > 0) {
                stringBuffer.append(iPath.segment(n - 1));
                if (n > 1 || iPath.getDevice() != null) {
                    stringBuffer.append(CONCAT_STRING);
                    stringBuffer.append(iPath.removeLastSegments(1).toOSString());
                }
            } else {
                stringBuffer.append(iPath.toOSString());
            }
        } else {
            stringBuffer.append(iPath.toOSString());
        }
    }

    private static void getInternalArchiveLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        boolean bl;
        IResource iResource = iPackageFragmentRoot.getResource();
        boolean bl2 = JavaElementLabels.getFlag(l, 0x20000000000L);
        boolean bl3 = bl = JavaElementLabels.getFlag(l, 0x200000000000L) && JavaElementLabels.isReferenced(iPackageFragmentRoot);
        if (bl2) {
            stringBuffer.append(iPackageFragmentRoot.getPath().makeRelative().toString());
        } else {
            stringBuffer.append(iPackageFragmentRoot.getDisplayName());
            if (bl) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iResource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabels.getFlag(l, 0x40000000000L)) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iPackageFragmentRoot.getParent().getPath().makeRelative().toString());
            }
        }
    }

    private static void getFolderLabel(IPackageFragmentRoot iPackageFragmentRoot, long l, StringBuffer stringBuffer) {
        boolean bl;
        IResource iResource = iPackageFragmentRoot.getResource();
        boolean bl2 = JavaElementLabels.getFlag(l, 0x20000000000L);
        boolean bl3 = bl = JavaElementLabels.getFlag(l, 0x200000000000L) && JavaElementLabels.isReferenced(iPackageFragmentRoot);
        if (bl2) {
            stringBuffer.append(iPackageFragmentRoot.getPath().makeRelative().toString());
        } else {
            if (iResource != null) {
                IPath iPath = iResource.getProjectRelativePath();
                if (iPath.segmentCount() == 0) {
                    stringBuffer.append(iResource.getName());
                    bl = false;
                } else {
                    stringBuffer.append(iPath.toString());
                }
            } else {
                stringBuffer.append(iPackageFragmentRoot.getDisplayName());
            }
            if (bl) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iResource.getProject().getName());
            } else if (JavaElementLabels.getFlag(l, 0x40000000000L)) {
                stringBuffer.append(CONCAT_STRING);
                stringBuffer.append(iPackageFragmentRoot.getParent().getDisplayName());
            }
        }
    }

    private static boolean isReferenced(IPackageFragmentRoot iPackageFragmentRoot) {
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource != null) {
            IProject iProject = iResource.getProject();
            IProject iProject2 = iPackageFragmentRoot.getJavaProject().getProject();
            return !iProject2.equals((Object)iProject);
        }
        return false;
    }

    private static void refreshPackageNamePattern() {
        String string = JavaElementLabels.getPkgNamePatternForPackagesView();
        if (string.equals(fgPkgNamePattern)) {
            return;
        }
        if (string.length() == 0) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = string;
        int n = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                fgPkgNameChars = c - 48;
                if (n > 0) {
                    fgPkgNamePrefix = string.substring(0, n);
                }
                if (n >= 0) {
                    fgPkgNamePostfix = string.substring(n + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++n;
        }
        fgPkgNamePrefix = string;
        fgPkgNameLength = string.length();
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        if (!iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.compresspackagenames")) {
            return "";
        }
        return iPreferenceStore.getString("PackagesView.pkgNamePatternForPackagesView");
    }

    public static String getContainerEntryLabel(IPath iPath, IJavaProject iJavaProject) throws JavaModelException {
        IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)iJavaProject);
        if (iClasspathContainer != null) {
            return iClasspathContainer.getDescription();
        }
        ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
        if (classpathContainerInitializer != null) {
            return classpathContainerInitializer.getDescription(iPath, iJavaProject);
        }
        return iPath.toString();
    }
}

