/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.InlineConstantAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.InlineMethodAction;
import org.eclipse.wst.jsdt.ui.actions.InlineTempAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InlineAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private final InlineTempAction fInlineTemp;
    private final InlineMethodAction fInlineMethod;
    private final InlineConstantAction fInlineConstant;

    public InlineAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fInlineTemp = new InlineTempAction(iWorkbenchSite);
        this.fInlineConstant = new InlineConstantAction(iWorkbenchSite);
        this.fInlineMethod = new InlineMethodAction(iWorkbenchSite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
    }

    public InlineAction(JavaEditor javaEditor) {
        super((IWorkbenchSite)javaEditor.getEditorSite());
        this.setText(RefactoringMessages.InlineAction_Inline);
        this.fEditor = javaEditor;
        this.fInlineTemp = new InlineTempAction(javaEditor);
        this.fInlineConstant = new InlineConstantAction(javaEditor);
        this.fInlineMethod = new InlineMethodAction(javaEditor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(ISelection iSelection) {
        this.fInlineConstant.update(iSelection);
        this.fInlineMethod.update(iSelection);
        this.fInlineTemp.update(iSelection);
        this.setEnabled(this.fInlineTemp.isEnabled() || this.fInlineConstant.isEnabled() || this.fInlineMethod.isEnabled());
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ITypeRoot iTypeRoot = SelectionConverter.getInputAsTypeRoot(this.fEditor);
        if (iTypeRoot == null) {
            return;
        }
        CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider(iTypeRoot, true, null);
        if (iTypeRoot instanceof ICompilationUnit) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iTypeRoot;
            if (this.fInlineTemp.isEnabled() && this.fInlineTemp.tryInlineTemp(iCompilationUnit, compilationUnit, iTextSelection, this.getShell())) {
                return;
            }
            if (this.fInlineConstant.isEnabled() && this.fInlineConstant.tryInlineConstant(iCompilationUnit, compilationUnit, iTextSelection, this.getShell())) {
                return;
            }
        }
        if (this.fInlineMethod.isEnabled() && this.fInlineMethod.tryInlineMethod(iTypeRoot, compilationUnit, iTextSelection, this.getShell())) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineAction_dialog_title, (String)RefactoringMessages.InlineAction_select);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (this.fInlineConstant.isEnabled()) {
            this.fInlineConstant.run(iStructuredSelection);
        } else if (this.fInlineMethod.isEnabled()) {
            this.fInlineMethod.run(iStructuredSelection);
        } else {
            Assert.isTrue((!this.fInlineTemp.isEnabled() ? 1 : 0) != 0);
        }
    }
}

