/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.MoveInstanceMethodAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.MoveStaticMembersAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMoveAction;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class MoveAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private MoveInstanceMethodAction fMoveInstanceMethodAction;
    private MoveStaticMembersAction fMoveStaticMembersAction;
    private ReorgMoveAction fReorgMoveAction;

    public MoveAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.MoveAction_text);
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(iWorkbenchSite);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(iWorkbenchSite);
        this.fReorgMoveAction = new ReorgMoveAction(iWorkbenchSite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public MoveAction(JavaEditor javaEditor) {
        super((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setText(RefactoringMessages.MoveAction_text);
        this.fMoveStaticMembersAction = new MoveStaticMembersAction(javaEditor);
        this.fMoveInstanceMethodAction = new MoveInstanceMethodAction(javaEditor);
        this.fReorgMoveAction = new ReorgMoveAction((IWorkbenchSite)javaEditor.getEditorSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fMoveStaticMembersAction.selectionChanged(selectionChangedEvent);
        this.fMoveInstanceMethodAction.selectionChanged(selectionChangedEvent);
        this.fReorgMoveAction.selectionChanged(selectionChangedEvent);
        this.setEnabled(this.computeEnableState());
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(iStructuredSelection)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(iStructuredSelection)) {
                return;
            }
            if (this.fReorgMoveAction.isEnabled()) {
                this.fReorgMoveAction.run();
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            if (this.fMoveStaticMembersAction.isEnabled() && this.tryMoveStaticMembers(iTextSelection)) {
                return;
            }
            if (this.fMoveInstanceMethodAction.isEnabled() && this.tryMoveInstanceMethod(iTextSelection)) {
                return;
            }
            if (this.tryReorgMove(iTextSelection)) {
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveAction_Move, (String)RefactoringMessages.MoveAction_select);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private boolean tryMoveStaticMembers(ITextSelection iTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
        if (iJavaElement == null || !(iJavaElement instanceof IMember)) {
            return false;
        }
        IMember[] iMemberArray = new IMember[]{(IMember)iJavaElement};
        if (!RefactoringAvailabilityTester.isMoveStaticMembersAvailable(iMemberArray)) {
            return false;
        }
        this.fMoveStaticMembersAction.run(iTextSelection);
        return true;
    }

    private static IMember[] getSelectedMembers(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return null;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IMember) continue;
            return null;
        }
        return MoveAction.convertToMemberArray(iStructuredSelection.toArray());
    }

    private static IMember[] convertToMemberArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(Arrays.asList(objectArray));
        return hashSet.toArray(new IMember[hashSet.size()]);
    }

    private boolean tryMoveStaticMembers(IStructuredSelection iStructuredSelection) throws JavaModelException {
        IMember[] iMemberArray = MoveAction.getSelectedMembers(iStructuredSelection);
        if (!RefactoringAvailabilityTester.isMoveStaticMembersAvailable(iMemberArray)) {
            return false;
        }
        this.fMoveStaticMembersAction.run(iStructuredSelection);
        return true;
    }

    private boolean tryMoveInstanceMethod(ITextSelection iTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
        if (iJavaElement == null || !(iJavaElement instanceof IMethod)) {
            return false;
        }
        IMethod iMethod = (IMethod)iJavaElement;
        if (!RefactoringAvailabilityTester.isMoveMethodAvailable(iMethod)) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(iTextSelection);
        return true;
    }

    private boolean tryMoveInstanceMethod(IStructuredSelection iStructuredSelection) throws JavaModelException {
        IMethod iMethod = MoveAction.getSingleSelectedMethod(iStructuredSelection);
        if (iMethod == null) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveMethodAvailable(iMethod)) {
            return false;
        }
        this.fMoveInstanceMethodAction.run(iStructuredSelection);
        return true;
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IMethod)) {
            return null;
        }
        return (IMethod)object;
    }

    private boolean tryReorgMove(ITextSelection iTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
        if (iJavaElement == null) {
            return false;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)iJavaElement);
        this.fReorgMoveAction.selectionChanged((IStructuredSelection)structuredSelection);
        if (!this.fReorgMoveAction.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)structuredSelection);
        return true;
    }

    public void update(ISelection iSelection) {
        this.fMoveStaticMembersAction.update(iSelection);
        this.fMoveInstanceMethodAction.update(iSelection);
        this.fReorgMoveAction.update(iSelection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.fMoveStaticMembersAction.isEnabled() || this.fMoveInstanceMethodAction.isEnabled() || this.fReorgMoveAction.isEnabled();
    }
}

