/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenProjectAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private int CLOSED_PROJECTS_SELECTED = 1;
    private int OTHER_ELEMENTS_SELECTED = 2;
    private OpenResourceAction fWorkbenchAction;

    public OpenProjectAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fWorkbenchAction = new OpenResourceAction(iWorkbenchSite.getShell());
        this.setText(this.fWorkbenchAction.getText());
        this.setToolTipText(this.fWorkbenchAction.getToolTipText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.open_project_action");
        this.setEnabled(this.hasClosedProjectsInWorkspace());
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0) {
                    this.setEnabled(this.hasClosedProjectsInWorkspace());
                    return;
                }
                ++n;
            }
        }
    }

    public void selectionChanged(ISelection iSelection) {
    }

    public void run(ISelection iSelection) {
        this.internalRun(null);
    }

    private int evaluateSelection(IStructuredSelection iStructuredSelection, List list) {
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (OpenProjectAction.isClosedProject(object)) {
                if (list != null) {
                    list.add(object);
                }
                n |= this.CLOSED_PROJECTS_SELECTED;
            } else {
                if (object instanceof IWorkingSet) {
                    IAdaptable[] iAdaptableArray = ((IWorkingSet)object).getElements();
                    int n3 = 0;
                    while (n3 < iAdaptableArray.length) {
                        IAdaptable iAdaptable = iAdaptableArray[n3];
                        if (OpenProjectAction.isClosedProject(iAdaptable)) {
                            if (list != null) {
                                list.add(iAdaptable);
                            }
                            n |= this.CLOSED_PROJECTS_SELECTED;
                        }
                        ++n3;
                    }
                }
                n |= this.OTHER_ELEMENTS_SELECTED;
            }
            ++n2;
        }
        return n;
    }

    private static boolean isClosedProject(Object object) {
        return object instanceof IProject && !((IProject)object).isOpen();
    }

    public void run(IStructuredSelection iStructuredSelection) {
        ArrayList arrayList = new ArrayList();
        int n = this.evaluateSelection(iStructuredSelection, arrayList);
        if (n == this.CLOSED_PROJECTS_SELECTED) {
            this.fWorkbenchAction.selectionChanged((IStructuredSelection)new StructuredSelection(arrayList));
            this.fWorkbenchAction.run();
        } else {
            this.internalRun(arrayList);
        }
    }

    private void internalRun(List list) {
        int n;
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.getShell(), (Object)this.getClosedProjectsInWorkspace(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaElementLabelProvider(), ActionMessages.OpenProjectAction_dialog_message);
        listSelectionDialog.setTitle(ActionMessages.OpenProjectAction_dialog_title);
        if (list != null && !list.isEmpty()) {
            listSelectionDialog.setInitialElementSelections(list);
        }
        if ((n = listSelectionDialog.open()) != 0) {
            return;
        }
        Object[] objectArray = listSelectionDialog.getResult();
        IWorkspaceRunnable iWorkspaceRunnable = this.createRunnable(objectArray);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.OpenProjectAction_dialog_title, ActionMessages.OpenProjectAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IWorkspaceRunnable createRunnable(final Object[] objectArray) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask("", objectArray.length);
                MultiStatus multiStatus = null;
                int n = 0;
                while (n < objectArray.length) {
                    IProject iProject = (IProject)objectArray[n];
                    try {
                        iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    catch (CoreException coreException) {
                        if (multiStatus == null) {
                            multiStatus = new MultiStatus(JavaPlugin.getPluginId(), 4, ActionMessages.OpenProjectAction_error_message, null);
                        }
                        multiStatus.add(coreException.getStatus());
                    }
                    ++n;
                }
                iProgressMonitor.done();
                if (multiStatus != null) {
                    throw new CoreException(multiStatus);
                }
            }
        };
    }

    private Object[] getClosedProjectsInWorkspace() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(5);
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (!iProject.isOpen()) {
                arrayList.add(iProject);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private boolean hasClosedProjectsInWorkspace() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].isOpen()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

