/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ReplaceInvocationsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ReplaceInvocationsAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(true);
    }

    public ReplaceInvocationsAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.ReplaceInvocationsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.replace_invocations_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(iStructuredSelection));
            }
            catch (JavaModelException javaModelException) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) break block2;
                JavaPlugin.log(javaModelException);
            }
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isReplaceInvocationsAvailable(iStructuredSelection));
            Object object = iStructuredSelection.getFirstElement();
            Assert.isTrue((boolean)(object instanceof IMethod));
            IMethod iMethod = (IMethod)object;
            if (ActionUtil.isProcessable(this.getShell(), (IJavaElement)iMethod)) {
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(iMethod, this.getShell());
            }
        }
        catch (CoreException coreException) {
            this.handleException(coreException);
        }
    }

    private void handleException(CoreException coreException) {
        ExceptionHandler.handle(coreException, RefactoringMessages.ReplaceInvocationsAction_dialog_title, RefactoringMessages.ReplaceInvocationsAction_unavailable);
    }

    public void run(ITextSelection iTextSelection) {
        try {
            IJavaElement iJavaElement = SelectionConverter.getInput(this.fEditor);
            if (iJavaElement instanceof ITypeRoot && ActionUtil.isProcessable(this.getShell(), iJavaElement)) {
                ITypeRoot iTypeRoot = (ITypeRoot)iJavaElement;
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(iTypeRoot, iTextSelection.getOffset(), iTextSelection.getLength(), this.getShell());
            }
        }
        catch (JavaModelException javaModelException) {
            this.handleException((CoreException)((Object)javaModelException));
        }
    }
}

