/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class SelfEncapsulateFieldAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public SelfEncapsulateFieldAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.SelfEncapsulateFieldAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.self_encapsulate_action");
    }

    public SelfEncapsulateFieldAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            IJavaElement[] iJavaElementArray = SelectionConverter.codeResolve(this.fEditor);
            if (iJavaElementArray.length != 1 || !(iJavaElementArray[0] instanceof IField)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            IField iField = (IField)iJavaElementArray[0];
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(iField)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            this.run(iField);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return;
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(iStructuredSelection)) {
                this.run((IField)iStructuredSelection.getFirstElement());
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(IField iField) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iField)) {
            return;
        }
        RefactoringExecutionStarter.startSelfEncapsulateRefactoring(iField, this.getShell());
    }
}

