/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ShowInPackageViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInPackageViewAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.ShowInPackageViewAction_label);
        this.setDescription(ActionMessages.ShowInPackageViewAction_description);
        this.setToolTipText(ActionMessages.ShowInPackageViewAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.show_in_packageview_action_context");
    }

    public ShowInPackageViewAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        return iStructuredSelection.getFirstElement() instanceof IJavaElement;
    }

    public void run(ITextSelection iTextSelection) {
        try {
            IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
            if (iJavaElement != null) {
                this.run(iJavaElement);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            String string = ActionMessages.ShowInPackageViewAction_error_message;
            ErrorDialog.openError((Shell)this.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)string, (IStatus)javaModelException.getStatus());
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (!this.checkEnabled(iStructuredSelection)) {
            return;
        }
        this.run((IJavaElement)iStructuredSelection.getFirstElement());
    }

    public void run(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return;
        }
        IOpenable iOpenable = iJavaElement.getOpenable();
        if (iOpenable instanceof IJavaElement) {
            iJavaElement = (IJavaElement)iOpenable;
        }
        PackageExplorerPart packageExplorerPart = PackageExplorerPart.openInActivePerspective();
        packageExplorerPart.tryToReveal(iJavaElement);
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInPackageViewAction_dialog_title;
    }
}

