/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.jarpackager;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarFileExportOperation;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageReader;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageWriter;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.ManifestProvider;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.wst.jsdt.ui.jarpackager.IManifestProvider;
import org.eclipse.wst.jsdt.ui.jarpackager.JarWriter2;
import org.eclipse.wst.jsdt.ui.jarpackager.JarWriter3;

public class JarPackageData {
    private String fManifestVersion;
    private boolean fExportClassFiles;
    private boolean fExportOutputFolders;
    private boolean fExportJavaFiles;
    private boolean fUseSourceFolderHierarchy;
    private boolean fBuildIfNeeded;
    private Object[] fElements;
    private IPath fJarLocation;
    private boolean fOverwrite;
    private boolean fCompress;
    private boolean fSaveDescription;
    private IPath fDescriptionLocation;
    private boolean fUsesManifest;
    private boolean fSaveManifest;
    private boolean fReuseManifest;
    private boolean fGenerateManifest;
    private IPath fManifestLocation;
    private boolean fSealJar;
    private IPackageFragment[] fPackagesToSeal;
    private IPackageFragment[] fPackagesToUnseal;
    private IType fManifestMainClass;
    private String fComment;
    private boolean fExportErrors;
    private boolean fExportWarnings;
    private IManifestProvider fManifestProvider;
    private boolean fIncludeDirectoryEntries;
    private IProject[] fRefactoringProjects = new IProject[0];
    private boolean fRefactoringAware = false;
    private boolean fRefactoringStructural = false;
    private boolean fDeprecationAware = true;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];

    public JarPackageData() {
        this.setExportClassFiles(true);
        this.setExportOutputFolders(false);
        this.setUseSourceFolderHierarchy(false);
        this.setCompress(true);
        this.setSaveDescription(false);
        this.setJarLocation((IPath)Path.EMPTY);
        this.setDescriptionLocation((IPath)Path.EMPTY);
        this.setUsesManifest(true);
        this.setGenerateManifest(true);
        this.setReuseManifest(false);
        this.setSaveManifest(false);
        this.setManifestLocation((IPath)Path.EMPTY);
        this.setExportErrors(true);
        this.setExportWarnings(true);
        this.setBuildIfNeeded(true);
        this.setIncludeDirectoryEntries(false);
    }

    public boolean isCompressed() {
        return this.fCompress;
    }

    public void setCompress(boolean bl) {
        this.fCompress = bl;
    }

    public boolean allowOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean bl) {
        this.fOverwrite = bl;
    }

    public boolean areClassFilesExported() {
        return this.fExportClassFiles;
    }

    public void setExportClassFiles(boolean bl) {
        this.fExportClassFiles = bl;
    }

    public boolean areOutputFoldersExported() {
        return this.fExportOutputFolders;
    }

    public void setExportOutputFolders(boolean bl) {
        this.fExportOutputFolders = bl;
    }

    public boolean areGeneratedFilesExported() {
        return this.fExportOutputFolders || this.fExportClassFiles;
    }

    public boolean areJavaFilesExported() {
        return this.fExportJavaFiles;
    }

    public void setExportJavaFiles(boolean bl) {
        this.fExportJavaFiles = bl;
    }

    public boolean useSourceFolderHierarchy() {
        return this.fUseSourceFolderHierarchy;
    }

    public void setUseSourceFolderHierarchy(boolean bl) {
        this.fUseSourceFolderHierarchy = bl;
    }

    public IPath getAbsoluteJarLocation() {
        IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (!this.fJarLocation.isAbsolute() && iPath != null) {
            return iPath.append(this.fJarLocation);
        }
        return this.fJarLocation;
    }

    public IPath getJarLocation() {
        return this.fJarLocation;
    }

    public void setJarLocation(IPath iPath) {
        this.fJarLocation = iPath;
    }

    public boolean isManifestGenerated() {
        return this.fGenerateManifest;
    }

    public void setGenerateManifest(boolean bl) {
        this.fGenerateManifest = bl;
    }

    public boolean isManifestSaved() {
        return this.fSaveManifest;
    }

    public void setSaveManifest(boolean bl) {
        this.fSaveManifest = bl;
        if (!this.fSaveManifest) {
            this.setReuseManifest(false);
        }
    }

    public boolean isManifestReused() {
        return this.fReuseManifest;
    }

    public void setReuseManifest(boolean bl) {
        this.fReuseManifest = bl;
        if (this.fReuseManifest) {
            this.setSaveManifest(true);
        }
    }

    public IPath getManifestLocation() {
        return this.fManifestLocation;
    }

    public void setManifestLocation(IPath iPath) {
        this.fManifestLocation = iPath;
    }

    public IFile getManifestFile() {
        IPath iPath = this.getManifestLocation();
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(iPath);
        }
        return null;
    }

    public String getManifestVersion() {
        if (this.fManifestVersion == null) {
            return "1.0";
        }
        return this.fManifestVersion;
    }

    public void setManifestVersion(String string) {
        this.fManifestVersion = string;
    }

    public boolean usesManifest() {
        return this.fUsesManifest;
    }

    public void setUsesManifest(boolean bl) {
        this.fUsesManifest = bl;
    }

    public IManifestProvider getManifestProvider() {
        if (this.fManifestProvider == null) {
            this.fManifestProvider = new ManifestProvider();
        }
        return this.fManifestProvider;
    }

    public void setManifestProvider(IManifestProvider iManifestProvider) {
        this.fManifestProvider = iManifestProvider;
    }

    public boolean isJarSealed() {
        return this.fSealJar;
    }

    public void setSealJar(boolean bl) {
        this.fSealJar = bl;
    }

    public void setPackagesToSeal(IPackageFragment[] iPackageFragmentArray) {
        this.fPackagesToSeal = iPackageFragmentArray;
    }

    public IPackageFragment[] getPackagesToSeal() {
        if (this.fPackagesToSeal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToSeal;
    }

    public IPackageFragment[] getPackagesToUnseal() {
        if (this.fPackagesToUnseal == null) {
            return new IPackageFragment[0];
        }
        return this.fPackagesToUnseal;
    }

    public void setPackagesToUnseal(IPackageFragment[] iPackageFragmentArray) {
        this.fPackagesToUnseal = iPackageFragmentArray;
    }

    public boolean isDescriptionSaved() {
        return this.fSaveDescription;
    }

    public void setSaveDescription(boolean bl) {
        this.fSaveDescription = bl;
    }

    public IPath getDescriptionLocation() {
        return this.fDescriptionLocation;
    }

    public void setDescriptionLocation(IPath iPath) {
        this.fDescriptionLocation = iPath;
    }

    public IFile getDescriptionFile() {
        IPath iPath = this.getDescriptionLocation();
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(iPath);
        }
        return null;
    }

    public IType getManifestMainClass() {
        return this.fManifestMainClass;
    }

    public void setManifestMainClass(IType iType) {
        this.fManifestMainClass = iType;
    }

    public Object[] getElements() {
        if (this.fElements == null) {
            this.setElements(new Object[0]);
        }
        return this.fElements;
    }

    public void setElements(Object[] objectArray) {
        this.fElements = objectArray;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public boolean logErrors() {
        return true;
    }

    public void setLogErrors(boolean bl) {
    }

    public boolean logWarnings() {
        return true;
    }

    public void setLogWarnings(boolean bl) {
    }

    public boolean areErrorsExported() {
        return this.fExportErrors;
    }

    public void setExportErrors(boolean bl) {
        this.fExportErrors = bl;
    }

    public boolean exportWarnings() {
        return this.fExportWarnings;
    }

    public void setExportWarnings(boolean bl) {
        this.fExportWarnings = bl;
    }

    public boolean isBuildingIfNeeded() {
        return this.fBuildIfNeeded;
    }

    public void setBuildIfNeeded(boolean bl) {
        this.fBuildIfNeeded = bl;
    }

    public IFile[] findClassfilesFor(IFile iFile) throws CoreException {
        return null;
    }

    public JarWriter2 createJarWriter(Shell shell) throws CoreException {
        return new JarWriter2(this, shell);
    }

    public JarWriter3 createJarWriter3(Shell shell) throws CoreException {
        return new JarWriter3(this, shell);
    }

    public IJarExportRunnable createJarExportRunnable(Shell shell) {
        return new JarFileExportOperation(this, shell);
    }

    public IJarExportRunnable createJarExportRunnable(JarPackageData[] jarPackageDataArray, Shell shell) {
        return new JarFileExportOperation(jarPackageDataArray, shell);
    }

    public IJarDescriptionWriter createJarDescriptionWriter(OutputStream outputStream) {
        return new JarPackageWriter(outputStream, "UTF-8");
    }

    public IJarDescriptionWriter createJarDescriptionWriter(OutputStream outputStream, String string) {
        return new JarPackageWriter(outputStream, string);
    }

    public IJarDescriptionReader createJarDescriptionReader(InputStream inputStream) {
        return new JarPackageReader(inputStream);
    }

    public boolean isValid() {
        return (this.areGeneratedFilesExported() || this.areJavaFilesExported()) && this.getElements() != null && this.getElements().length > 0 && this.getAbsoluteJarLocation() != null && this.isManifestAccessible() && this.isMainClassValid(new BusyIndicatorRunnableContext());
    }

    public boolean isManifestAccessible() {
        if (this.isManifestGenerated()) {
            return true;
        }
        IFile iFile = this.getManifestFile();
        return iFile != null && iFile.isAccessible();
    }

    public boolean isMainClassValid(IRunnableContext iRunnableContext) {
        return JarPackagerUtil.isMainClassValid(this, iRunnableContext);
    }

    public boolean areDirectoryEntriesIncluded() {
        return this.fIncludeDirectoryEntries;
    }

    public void setIncludeDirectoryEntries(boolean bl) {
        this.fIncludeDirectoryEntries = bl;
    }

    public IProject[] getRefactoringProjects() {
        return this.fRefactoringProjects;
    }

    public boolean isExportStructuralOnly() {
        return this.fRefactoringStructural;
    }

    public boolean isRefactoringAware() {
        return this.fRefactoringAware;
    }

    public boolean isDeprecationAware() {
        return this.fDeprecationAware;
    }

    public void setRefactoringProjects(IProject[] iProjectArray) {
        Assert.isNotNull((Object)iProjectArray);
        this.fRefactoringProjects = iProjectArray;
    }

    public void setRefactoringAware(boolean bl) {
        this.fRefactoringAware = bl;
    }

    public void setDeprecationAware(boolean bl) {
        this.fDeprecationAware = bl;
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] refactoringDescriptorProxyArray) {
        Assert.isNotNull((Object)refactoringDescriptorProxyArray);
        this.fRefactoringDescriptors = refactoringDescriptorProxyArray;
    }

    public RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        return this.fRefactoringDescriptors;
    }

    public void setExportStructuralOnly(boolean bl) {
        this.fRefactoringStructural = bl;
    }
}

