/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public class JarWriter3 {
    private Set fDirectories = new HashSet();
    private JarOutputStream fJarOutputStream;
    private JarPackageData fJarPackage;

    public JarWriter3(JarPackageData jarPackageData, Shell shell) throws CoreException {
        Assert.isNotNull((Object)jarPackageData, (String)"The JAR specification is null");
        this.fJarPackage = jarPackageData;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(shell)) {
            throw new OperationCanceledException();
        }
        try {
            Object object;
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                object = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()), (Manifest)object);
            } else {
                this.fJarOutputStream = new JarOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()));
            }
            object = jarPackageData.getComment();
            if (object != null) {
                this.fJarOutputStream.setComment((String)object);
            }
            if (this.fJarPackage.isRefactoringAware()) {
                Assert.isTrue((boolean)this.fJarPackage.areDirectoryEntriesIncluded());
                Path path = new Path(JarPackagerUtil.getMetaEntry());
                this.addDirectories((IPath)path);
                this.addHistory(this.fJarPackage, (IPath)new Path(JarPackagerUtil.getRefactoringsEntry()), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException iOException) {
            throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
        }
    }

    protected void addDirectories(IPath iPath) throws IOException {
        String string = iPath.toString().replace(File.separatorChar, '/');
        int n = string.lastIndexOf(47);
        ArrayList<JarEntry> arrayList = new ArrayList<JarEntry>(2);
        while (n != -1) {
            if (!this.fDirectories.add(string = string.substring(0, n + 1))) break;
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setMethod(0);
            jarEntry.setSize(0L);
            jarEntry.setCrc(0L);
            jarEntry.setTime(System.currentTimeMillis());
            arrayList.add(jarEntry);
            n = string.lastIndexOf(47, n - 1);
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)arrayList.get(n2));
            --n2;
        }
    }

    protected void addDirectories(IResource iResource, IPath iPath) throws IOException, CoreException {
        IContainer iContainer = null;
        String string = iPath.toString().replace(File.separatorChar, '/');
        int n = string.lastIndexOf(47);
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (n != -1) {
            Object object;
            if (!this.fDirectories.add(string = string.substring(0, n + 1))) break;
            iContainer = iResource.getParent();
            long l = System.currentTimeMillis();
            URI uRI = iContainer.getLocationURI();
            if (uRI != null && (object = EFS.getStore((URI)uRI).fetchInfo()).exists()) {
                l = object.getLastModified();
            }
            object = new JarEntry(string);
            ((ZipEntry)object).setMethod(0);
            ((ZipEntry)object).setSize(0L);
            ((ZipEntry)object).setCrc(0L);
            ((ZipEntry)object).setTime(l);
            arrayList.add(object);
            n = string.lastIndexOf(47, n - 1);
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)arrayList.get(n2));
            --n2;
        }
    }

    /*
     * Exception decompiling
     */
    protected void addFile(IFile var1_1, IPath var2_2) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 196->200)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void addHistory(JarPackageData var1_1, IPath var2_2, IProgressMonitor var3_3) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 128->134)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean canCreateJar(Shell shell) {
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return shell != null && JarPackagerUtil.askForOverwritePermission(shell, this.fJarPackage.getAbsoluteJarLocation().toOSString());
        }
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            return true;
        }
        File file2 = new File(string.substring(0, n));
        if (!file2.exists()) {
            if (JarPackagerUtil.askToCreateDirectory(shell, file2)) {
                return file2.mkdirs();
            }
            return false;
        }
        return true;
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException iOException) {
                throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    private void registerInWorkspaceIfNeeded() {
        IPath iPath = this.fJarPackage.getAbsoluteJarLocation();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IPath iPath2 = iProject.getLocation();
            if (iPath2 != null && iPath2.isPrefixOf(iPath)) {
                try {
                    iPath = iPath.removeFirstSegments(iPath2.segmentCount());
                    iPath = iPath.removeLastSegments(1);
                    IResource iResource = iProject.findMember(iPath);
                    if (iResource != null && iResource.isAccessible()) {
                        iResource.refreshLocal(1, null);
                    }
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            }
            ++n;
        }
    }

    public void write(IFile iFile, IPath iPath) throws CoreException {
        try {
            if (this.fJarPackage.areDirectoryEntriesIncluded()) {
                this.addDirectories((IResource)iFile, iPath);
            }
            this.addFile(iFile, iPath);
        }
        catch (IOException iOException) {
            String string = null;
            string = iOException.getLocalizedMessage() != null ? Messages.format(JarPackagerMessages.JarWriter_writeProblemWithMessage, new Object[]{iFile.getFullPath(), iOException.getLocalizedMessage()}) : Messages.format(JarPackagerMessages.JarWriter_writeProblem, iFile.getFullPath());
            throw JarPackagerUtil.createCoreException(string, iOException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeMetaData(JarPackageData jarPackageData, File file, IPath iPath) throws FileNotFoundException, IOException, CoreException {
        Assert.isNotNull((Object)jarPackageData);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)iPath);
        JarEntry jarEntry = new JarEntry(iPath.toString().replace(File.separatorChar, '/'));
        byte[] byArray = new byte[4096];
        if (jarPackageData.isCompressed()) {
            jarEntry.setMethod(8);
        } else {
            jarEntry.setMethod(0);
            JarPackagerUtil.calculateCrcAndSize(jarEntry, new BufferedInputStream(new FileInputStream(file)), byArray);
        }
        jarEntry.setTime(System.currentTimeMillis());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            int n;
            this.fJarOutputStream.putNextEntry(jarEntry);
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                this.fJarOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((InputStream)bufferedInputStream).close();
    }
}

