/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.wst.jsdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.JavaElementProvider;
import org.eclipse.wst.jsdt.internal.ui.text.JavaOutlineInformationControl;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.wst.jsdt.internal.ui.text.JavaReconciler;
import org.eclipse.wst.jsdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.wst.jsdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCodeScanner;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaDoubleClickSelector;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaStringAutoIndentStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaStringDoubleClickSelector;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavadocDoubleClickStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverProxy;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaInformationProvider;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocAutoIndentStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDocScanner;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavadocCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public class JavaSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "org.eclipse.wst.jsdt.ui.editor.tab.width";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    private JavaTextTools fJavaTextTools;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractJavaScanner fCodeScanner;
    private AbstractJavaScanner fMultilineCommentScanner;
    private AbstractJavaScanner fSinglelineCommentScanner;
    private AbstractJavaScanner fStringScanner;
    private AbstractJavaScanner fJavaDocScanner;
    private IColorManager fColorManager;
    private JavaDoubleClickSelector fJavaDoubleClickSelector;

    public JavaSourceViewerConfiguration(IColorManager iColorManager, IPreferenceStore iPreferenceStore, ITextEditor iTextEditor, String string) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.fTextEditor = iTextEditor;
        this.fDocumentPartitioning = string;
        this.initializeScanners();
    }

    public JavaSourceViewerConfiguration(JavaTextTools javaTextTools, ITextEditor iTextEditor) {
        super(JavaSourceViewerConfiguration.createPreferenceStore(javaTextTools));
        this.fJavaTextTools = javaTextTools;
        this.fColorManager = javaTextTools.getColorManager();
        this.fCodeScanner = (AbstractJavaScanner)this.fJavaTextTools.getCodeScanner();
        this.fMultilineCommentScanner = (AbstractJavaScanner)this.fJavaTextTools.getMultilineCommentScanner();
        this.fSinglelineCommentScanner = (AbstractJavaScanner)this.fJavaTextTools.getSinglelineCommentScanner();
        this.fStringScanner = (AbstractJavaScanner)this.fJavaTextTools.getStringScanner();
        this.fJavaDocScanner = (AbstractJavaScanner)this.fJavaTextTools.getJavaDocScanner();
        this.fTextEditor = iTextEditor;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getJavaDocScanner() {
        return this.fJavaDocScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        return this.fJavaTextTools.getPreferenceStore();
    }

    private boolean isNewSetup() {
        return this.fJavaTextTools == null;
    }

    private static final IPreferenceStore createPreferenceStore(JavaTextTools javaTextTools) {
        Assert.isNotNull((Object)javaTextTools);
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        if (javaTextTools.getCorePreferenceStore() == null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{javaTextTools.getPreferenceStore(), iPreferenceStore});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{javaTextTools.getPreferenceStore(), new PreferencesAdapter(javaTextTools.getCorePreferenceStore()), iPreferenceStore});
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new JavaCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_multi_line_comment");
        this.fSinglelineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_single_line_comment");
        this.fStringScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "java_string");
        this.fJavaDocScanner = new JavaDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        JavaPresentationReconciler javaPresentationReconciler = new JavaPresentationReconciler();
        javaPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getJavaDocScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__java_javadoc");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__java_javadoc");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__java_multiline_comment");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__java_multiline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__java_singleline_comment");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__java_singleline_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__java_string");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__java_string");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        javaPresentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__java_character");
        javaPresentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__java_character");
        return javaPresentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant contentAssistant = new ContentAssistant();
            contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            contentAssistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
            JavaCompletionProcessor javaCompletionProcessor = new JavaCompletionProcessor((IEditorPart)this.getEditor(), contentAssistant, "__dftl_partition_content_type");
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)javaCompletionProcessor, "__dftl_partition_content_type");
            JavaCompletionProcessor javaCompletionProcessor2 = new JavaCompletionProcessor((IEditorPart)this.getEditor(), contentAssistant, "__java_singleline_comment");
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)javaCompletionProcessor2, "__java_singleline_comment");
            JavaCompletionProcessor javaCompletionProcessor3 = new JavaCompletionProcessor((IEditorPart)this.getEditor(), contentAssistant, "__java_string");
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)javaCompletionProcessor3, "__java_string");
            JavaCompletionProcessor javaCompletionProcessor4 = new JavaCompletionProcessor((IEditorPart)this.getEditor(), contentAssistant, "__java_multiline_comment");
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)javaCompletionProcessor4, "__java_multiline_comment");
            JavadocCompletionProcessor javadocCompletionProcessor = new JavadocCompletionProcessor((IEditorPart)this.getEditor(), contentAssistant);
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)javadocCompletionProcessor, "__java_javadoc");
            ContentAssistPreference.configure(contentAssistant, this.fPreferenceStore);
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
            return contentAssistant;
        }
        return null;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer iSourceViewer) {
        if (this.getEditor() != null) {
            return new JavaCorrectionAssistant(this.getEditor());
        }
        return null;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        ITextEditor iTextEditor = this.getEditor();
        if (iTextEditor != null && iTextEditor.isEditable()) {
            JavaCompositeReconcilingStrategy javaCompositeReconcilingStrategy = new JavaCompositeReconcilingStrategy(iSourceViewer, iTextEditor, this.getConfiguredDocumentPartitioning(iSourceViewer));
            JavaReconciler javaReconciler = new JavaReconciler(iTextEditor, javaCompositeReconcilingStrategy, false);
            javaReconciler.setIsIncrementalReconciler(false);
            javaReconciler.setIsAllowedToModifyDocument(false);
            javaReconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            javaReconciler.setDelay(500);
            return javaReconciler;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        String string2 = this.getConfiguredDocumentPartitioning(iSourceViewer);
        if ("__java_javadoc".equals(string) || "__java_multiline_comment".equals(string)) {
            return new IAutoEditStrategy[]{new JavaDocAutoIndentStrategy(string2)};
        }
        if ("__java_string".equals(string)) {
            return new IAutoEditStrategy[]{new SmartSemicolonAutoEditStrategy(string2), new JavaStringAutoIndentStrategy(string2)};
        }
        if ("__java_character".equals(string) || "__dftl_partition_content_type".equals(string)) {
            return new IAutoEditStrategy[]{new SmartSemicolonAutoEditStrategy(string2), new JavaAutoIndentStrategy(string2, this.getProject())};
        }
        return new IAutoEditStrategy[]{new JavaAutoIndentStrategy(string2, this.getProject())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if ("__java_javadoc".equals(string)) {
            return new JavadocDoubleClickStrategy();
        }
        if ("__java_multiline_comment".equals(string) || "__java_singleline_comment".equals(string)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__java_string".equals(string) || "__java_character".equals(string)) {
            return new JavaStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(iSourceViewer));
        }
        if (this.fJavaDoubleClickSelector == null) {
            this.fJavaDoubleClickSelector = new JavaDoubleClickSelector();
            this.fJavaDoubleClickSelector.setSourceVersion(this.fPreferenceStore.getString("org.eclipse.wst.jsdt.core.compiler.source"));
        }
        return this.fJavaDoubleClickSelector;
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"//", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        int n;
        IJavaProject iJavaProject = this.getProject();
        int n2 = CodeFormatterUtil.getTabWidth(iJavaProject);
        boolean bl = n2 <= (n = CodeFormatterUtil.getIndentWidth(iJavaProject));
        String string2 = iJavaProject == null ? JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.formatter.tabulation.char") : iJavaProject.getOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", true);
        boolean bl2 = "space".equals(string2) || "mixed".equals(string2);
        Assert.isLegal((bl || bl2 ? 1 : 0) != 0);
        if (!bl) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            return new String[]{new String(cArray), ""};
        }
        if (!bl2) {
            return this.getIndentPrefixesForTab(n2);
        }
        return this.getIndentPrefixesForSpaces(n2);
    }

    private String[] getIndentPrefixesForSpaces(int n) {
        String[] stringArray = new String[n + 2];
        stringArray[0] = this.getStringWithSpaces(n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.getStringWithSpaces(n2);
            stringArray[n2 + 1] = n2 < n ? String.valueOf(string) + '\t' : new String(string);
            ++n2;
        }
        stringArray[n + 1] = "";
        return stringArray;
    }

    private String getStringWithSpaces(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private IJavaProject getProject() {
        ITextEditor iTextEditor = this.getEditor();
        if (iTextEditor == null) {
            return null;
        }
        ICompilationUnit iCompilationUnit = null;
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        if (iDocumentProvider instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider iCompilationUnitDocumentProvider = (ICompilationUnitDocumentProvider)iDocumentProvider;
            iCompilationUnit = iCompilationUnitDocumentProvider.getWorkingCopy(iEditorInput);
        } else if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)iEditorInput;
            iCompilationUnit = iClassFileEditorInput.getClassFile();
        }
        if (iCompilationUnit == null) {
            return null;
        }
        return iCompilationUnit.getJavaProject();
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        return CodeFormatterUtil.getTabWidth(this.getProject());
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return JavaSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer iSourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return JavaSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer iSourceViewer, String string) {
        JavaEditorTextHoverDescriptor[] javaEditorTextHoverDescriptorArray = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int[] nArray = new int[javaEditorTextHoverDescriptorArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < javaEditorTextHoverDescriptorArray.length) {
            if (javaEditorTextHoverDescriptorArray[n2].isEnabled()) {
                int n3 = 0;
                int n4 = javaEditorTextHoverDescriptorArray[n2].getStateMask();
                while (n3 < n) {
                    if (nArray[n3] == n4) break;
                    ++n3;
                }
                if (n3 == n) {
                    nArray[n++] = n4;
                }
            }
            ++n2;
        }
        if (n == javaEditorTextHoverDescriptorArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        JavaEditorTextHoverDescriptor[] javaEditorTextHoverDescriptorArray = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int n2 = 0;
        while (n2 < javaEditorTextHoverDescriptorArray.length) {
            if (javaEditorTextHoverDescriptorArray[n2].isEnabled() && javaEditorTextHoverDescriptorArray[n2].getStateMask() == n) {
                return new JavaEditorTextHoverProxy(javaEditorTextHoverDescriptorArray[n2], (IEditorPart)this.getEditor());
            }
            ++n2;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(iSourceViewer);
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "__dftl_partition_content_type");
        multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_javadoc");
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_singleline_comment");
        multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_multiline_comment");
        return multiPassContentFormatter;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 20;
                int n2 = 768;
                return new DefaultInformationControl(shell, n, n2, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer iSourceViewer, final String string) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new JavaOutlineInformationControl(shell, n, n2, string);
            }
        };
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer iSourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new HierarchyInformationControl(shell, n, n2);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(this.getInformationPresenterControlCreator(iSourceViewer));
        informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        JavaInformationProvider javaInformationProvider = new JavaInformationProvider((IEditorPart)this.getEditor());
        String[] stringArray = this.getConfiguredContentTypes(iSourceViewer);
        int n = 0;
        while (n < stringArray.length) {
            informationPresenter.setInformationProvider((IInformationProvider)javaInformationProvider, stringArray[n]);
            ++n;
        }
        informationPresenter.setSizeConstraints(60, 10, true, true);
        return informationPresenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer iSourceViewer, boolean bl) {
        InformationPresenter informationPresenter = bl ? new InformationPresenter(this.getOutlinePresenterControlCreator(iSourceViewer, "org.eclipse.wst.jsdt.ui.navigate.java.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator(iSourceViewer, "org.eclipse.wst.jsdt.ui.edit.text.java.show.outline"));
        informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider javaElementProvider = new JavaElementProvider((IEditorPart)this.getEditor(), bl);
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__dftl_partition_content_type");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_javadoc");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_multiline_comment");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_singleline_comment");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_string");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_character");
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    private IDialogSettings getSettings(String string) {
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(string);
        if (iDialogSettings == null) {
            iDialogSettings = JavaPlugin.getDefault().getDialogSettings().addNewSection(string);
        }
        return iDialogSettings;
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer iSourceViewer, boolean bl) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && JavaUI.getEditorInputJavaElement(this.getEditor().getEditorInput()) == null) {
            return null;
        }
        InformationPresenter informationPresenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(iSourceViewer));
        informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider javaElementProvider = new JavaElementProvider((IEditorPart)this.getEditor(), bl);
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__dftl_partition_content_type");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_javadoc");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_multiline_comment");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_singleline_comment");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_string");
        informationPresenter.setInformationProvider((IInformationProvider)javaElementProvider, "__java_character");
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return this.fCodeScanner.affectsBehavior(propertyChangeEvent) || this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent) || this.fStringScanner.affectsBehavior(propertyChangeEvent) || this.fJavaDocScanner.affectsBehavior(propertyChangeEvent);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(propertyChangeEvent)) {
            this.fCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fStringScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fJavaDocScanner.affectsBehavior(propertyChangeEvent)) {
            this.fJavaDocScanner.adaptToPreferenceChange(propertyChangeEvent);
        }
        if (this.fJavaDoubleClickSelector != null && "org.eclipse.wst.jsdt.core.compiler.source".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() instanceof String) {
            this.fJavaDoubleClickSelector.setSourceVersion((String)propertyChangeEvent.getNewValue());
        }
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer iSourceViewer) {
        Map map = super.getHyperlinkDetectorTargets(iSourceViewer);
        map.put("org.eclipse.wst.jsdt.ui.javaCode", this.fTextEditor);
        return map;
    }
}

