/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.folding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingStructureProviderExtension;

public class DefaultJavaFoldingStructureProvider
implements IJavaFoldingStructureProvider,
IJavaFoldingStructureProviderExtension {
    private JavaEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IJavaElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fCollapseJavadoc = false;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseInnerTypes = true;
    private boolean fCollapseMembers = false;
    private boolean fCollapseHeaderComments = true;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private IScanner fSharedScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
    private volatile int fUpdatingCount = 0;
    static /* synthetic */ Class class$0;

    public void install(ITextEditor iTextEditor, ProjectionViewer projectionViewer) {
        Assert.isLegal((iTextEditor != null ? 1 : 0) != 0);
        Assert.isLegal((projectionViewer != null ? 1 : 0) != 0);
        this.internalUninstall();
        if (iTextEditor instanceof JavaEditor) {
            this.fProjectionListener = new ProjectionListener(projectionViewer);
            this.fEditor = (JavaEditor)iTextEditor;
        }
    }

    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void initialize() {
        ++this.fUpdatingCount;
        try {
            this.update(this.createInitialContext());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            --this.fUpdatingCount;
            throw throwable;
        }
        {
            Object var1_3 = null;
            --this.fUpdatingCount;
            return;
        }
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean bl) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel projectionAnnotationModel = this.getModel();
        if (projectionAnnotationModel == null) {
            return null;
        }
        IDocument iDocument = this.getDocument();
        if (iDocument == null) {
            return null;
        }
        IScanner iScanner = null;
        if (this.fUpdatingCount == 1) {
            iScanner = this.fSharedScanner;
        }
        return new FoldingStructureComputationContext(iDocument, projectionAnnotationModel, bl, iScanner);
    }

    private IJavaElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
    }

    private void initializePreferences() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = iPreferenceStore.getBoolean("editor_folding_default_innertypes");
        this.fCollapseImportContainer = iPreferenceStore.getBoolean("editor_folding_default_imports");
        this.fCollapseJavadoc = iPreferenceStore.getBoolean("editor_folding_default_javadoc");
        this.fCollapseMembers = iPreferenceStore.getBoolean("editor_folding_default_methods");
        this.fCollapseHeaderComments = iPreferenceStore.getBoolean("editor_folding_default_headers");
    }

    private void update(FoldingStructureComputationContext foldingStructureComputationContext) {
        Annotation[] annotationArray;
        Object object;
        if (foldingStructureComputationContext == null) {
            return;
        }
        HashMap<Object, Annotation[]> hashMap = new HashMap<Object, Annotation[]>();
        ArrayList<JavaProjectionAnnotation> arrayList = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> arrayList2 = new ArrayList<JavaProjectionAnnotation>();
        this.computeFoldingStructure(foldingStructureComputationContext);
        LinkedHashMap linkedHashMap = foldingStructureComputationContext.fMap;
        Map map = this.computeCurrentStructure(foldingStructureComputationContext);
        Iterator<Object> iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (JavaProjectionAnnotation)((Object)iterator.next());
            annotationArray = (Annotation[])linkedHashMap.get(object);
            IJavaElement iJavaElement = ((JavaProjectionAnnotation)((Object)object)).getElement();
            boolean bl = annotationArray.getOffset() == 0 && iJavaElement.getElementType() == 7 && this.isInnerType((IType)iJavaElement);
            List list = (List)map.get(iJavaElement);
            if (list == null) {
                if (bl) continue;
                hashMap.put(object, annotationArray);
                continue;
            }
            Iterator iterator2 = list.iterator();
            boolean bl2 = false;
            while (iterator2.hasNext()) {
                boolean bl3;
                Tuple tuple = (Tuple)iterator2.next();
                JavaProjectionAnnotation javaProjectionAnnotation = tuple.annotation;
                Position position = tuple.position;
                if (((JavaProjectionAnnotation)((Object)object)).isComment() != javaProjectionAnnotation.isComment()) continue;
                boolean bl4 = bl3 = foldingStructureComputationContext.allowCollapsing() && javaProjectionAnnotation.isCollapsed() != object.isCollapsed();
                if (!(bl || position == null || annotationArray.equals((Object)position) && !bl3)) {
                    position.setOffset(annotationArray.getOffset());
                    position.setLength(annotationArray.getLength());
                    if (bl3) {
                        if (object.isCollapsed()) {
                            javaProjectionAnnotation.markCollapsed();
                        } else {
                            javaProjectionAnnotation.markExpanded();
                        }
                    }
                    arrayList2.add(javaProjectionAnnotation);
                }
                bl2 = true;
                iterator2.remove();
                break;
            }
            if (!bl2) {
                hashMap.put(object, annotationArray);
            }
            if (!list.isEmpty()) continue;
            map.remove(iJavaElement);
        }
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            int n = object.size();
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(((Tuple)object.get((int)n2)).annotation);
                ++n2;
            }
        }
        this.match(arrayList, hashMap, arrayList2, foldingStructureComputationContext);
        object = arrayList.toArray(new Annotation[arrayList.size()]);
        annotationArray = arrayList2.toArray(new Annotation[arrayList2.size()]);
        foldingStructureComputationContext.getModel().modifyAnnotations((Annotation[])object, hashMap, annotationArray);
        foldingStructureComputationContext.fScanner.setSource(null);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext foldingStructureComputationContext) {
        IParent iParent = (IParent)this.fInput;
        try {
            if (!(this.fInput instanceof ISourceReference)) {
                return;
            }
            String string = ((ISourceReference)this.fInput).getSource();
            if (string == null) {
                return;
            }
            foldingStructureComputationContext.getScanner().setSource(string.toCharArray());
            this.computeFoldingStructure(iParent.getChildren(), foldingStructureComputationContext);
        }
        catch (JavaModelException javaModelException) {}
    }

    private void computeFoldingStructure(IJavaElement[] iJavaElementArray, FoldingStructureComputationContext foldingStructureComputationContext) throws JavaModelException {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            this.computeFoldingStructure(iJavaElement, foldingStructureComputationContext);
            if (iJavaElement instanceof IParent) {
                IParent iParent = (IParent)iJavaElement;
                this.computeFoldingStructure(iParent.getChildren(), foldingStructureComputationContext);
            }
            ++n;
        }
    }

    protected void computeFoldingStructure(IJavaElement iJavaElement, FoldingStructureComputationContext foldingStructureComputationContext) {
        boolean bl = false;
        boolean bl2 = true;
        switch (iJavaElement.getElementType()) {
            case 12: {
                bl = foldingStructureComputationContext.collapseImportContainer();
                break;
            }
            case 7: {
                bl2 = this.isInnerType((IType)iJavaElement) && !this.isAnonymousEnum((IType)iJavaElement);
                bl = foldingStructureComputationContext.collapseInnerTypes() && bl2;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                bl = foldingStructureComputationContext.collapseMembers();
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] iRegionArray = this.computeProjectionRanges((ISourceReference)iJavaElement, foldingStructureComputationContext);
        if (iRegionArray.length > 0) {
            IRegion iRegion;
            IRegion iRegion2;
            int n = 0;
            while (n < iRegionArray.length - 1) {
                Position position;
                iRegion2 = this.alignRegion(iRegionArray[n], foldingStructureComputationContext);
                if (iRegion2 != null && (position = this.createCommentPosition(iRegion2)) != null) {
                    boolean bl3 = n == 0 && (iRegionArray.length > 2 || foldingStructureComputationContext.hasHeaderComment()) && iJavaElement == foldingStructureComputationContext.getFirstType() ? foldingStructureComputationContext.collapseHeaderComments() : foldingStructureComputationContext.collapseJavadoc();
                    foldingStructureComputationContext.addProjectionRange(new JavaProjectionAnnotation(bl3, iJavaElement, true), position);
                }
                ++n;
            }
            if (bl2 && (iRegion = this.alignRegion(iRegionArray[iRegionArray.length - 1], foldingStructureComputationContext)) != null) {
                Position position = iRegion2 = iJavaElement instanceof IMember ? this.createMemberPosition(iRegion, (IMember)iJavaElement) : this.createCommentPosition(iRegion);
                if (iRegion2 != null) {
                    foldingStructureComputationContext.addProjectionRange(new JavaProjectionAnnotation(bl, iJavaElement, false), (Position)iRegion2);
                }
            }
        }
    }

    private boolean isAnonymousEnum(IType iType) {
        try {
            return iType.isEnum() && iType.isAnonymous();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isInnerType(IType iType) {
        return iType.getDeclaringType() != null;
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference iSourceReference, FoldingStructureComputationContext foldingStructureComputationContext) {
        try {
            ISourceRange iSourceRange = iSourceReference.getSourceRange();
            if (!SourceRange.isAvailable(iSourceRange)) {
                return new IRegion[0];
            }
            String string = iSourceReference.getSource();
            if (string == null) {
                return new IRegion[0];
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!foldingStructureComputationContext.hasFirstType() && iSourceReference instanceof IType) {
                foldingStructureComputationContext.setFirstType((IType)iSourceReference);
                IRegion iRegion = this.computeHeaderComment(foldingStructureComputationContext);
                if (iRegion != null) {
                    arrayList.add(iRegion);
                    foldingStructureComputationContext.setHasHeaderComment();
                }
            }
            int n = iSourceRange.getOffset();
            IScanner iScanner = foldingStructureComputationContext.getScanner();
            iScanner.resetTo(n, n + iSourceRange.getLength());
            int n2 = n;
            block7: while (true) {
                int n3 = iScanner.getNextToken();
                n2 = iScanner.getCurrentTokenStartPosition();
                switch (n3) {
                    case 1002: 
                    case 1003: {
                        int n4 = iScanner.getCurrentTokenEndPosition() + 1;
                        arrayList.add(new Region(n2, n4 - n2));
                        continue block7;
                    }
                    case 1001: {
                        continue block7;
                    }
                }
                break;
            }
            arrayList.add(new Region(n2, n + iSourceRange.getLength() - n2));
            IRegion[] iRegionArray = new IRegion[arrayList.size()];
            arrayList.toArray(iRegionArray);
            return iRegionArray;
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {}
        return new IRegion[0];
    }

    private IRegion computeHeaderComment(FoldingStructureComputationContext foldingStructureComputationContext) throws JavaModelException {
        ISourceRange iSourceRange = foldingStructureComputationContext.getFirstType().getSourceRange();
        if (iSourceRange == null) {
            return null;
        }
        int n = 0;
        int n2 = iSourceRange.getOffset();
        IScanner iScanner = foldingStructureComputationContext.getScanner();
        iScanner.resetTo(n, n2);
        int n3 = -1;
        int n4 = -1;
        try {
            boolean bl = false;
            int n5 = iScanner.getNextToken();
            while (n5 == 1003 || n5 == 1000 || n5 == 1001 || n5 == 1002) {
                if (n5 == 1003 || n5 == 1002 || n5 == 1001) {
                    if (!bl) {
                        n3 = iScanner.getCurrentTokenStartPosition();
                    }
                    n4 = iScanner.getCurrentTokenEndPosition();
                    bl = true;
                }
                n5 = iScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        if (n4 != -1) {
            return new Region(n3, n4 - n3);
        }
        return null;
    }

    protected final Position createCommentPosition(IRegion iRegion) {
        return new CommentPosition(iRegion.getOffset(), iRegion.getLength());
    }

    protected final Position createMemberPosition(IRegion iRegion, IMember iMember) {
        return new JavaElementPosition(iRegion.getOffset(), iRegion.getLength(), iMember);
    }

    protected final IRegion alignRegion(IRegion iRegion, FoldingStructureComputationContext foldingStructureComputationContext) {
        int n;
        int n2;
        IDocument iDocument;
        block4: {
            if (iRegion == null) {
                return null;
            }
            iDocument = foldingStructureComputationContext.getDocument();
            try {
                n2 = iDocument.getLineOfOffset(iRegion.getOffset());
                n = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
                if (n2 < n) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int n3 = iDocument.getLineOffset(n2);
        int n4 = iDocument.getNumberOfLines() > n + 1 ? iDocument.getLineOffset(n + 1) : iDocument.getLineOffset(n) + iDocument.getLineLength(n);
        return new Region(n3, n4 - n3);
    }

    private ProjectionAnnotationModel getModel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(clazz);
    }

    private IDocument getDocument() {
        JavaEditor javaEditor = this.fEditor;
        if (javaEditor == null) {
            return null;
        }
        IDocumentProvider iDocumentProvider = javaEditor.getDocumentProvider();
        if (iDocumentProvider == null) {
            return null;
        }
        return iDocumentProvider.getDocument((Object)javaEditor.getEditorInput());
    }

    private void match(List list, Map map, List list2, FoldingStructureComputationContext foldingStructureComputationContext) {
        if (list.isEmpty() || map.isEmpty() && list2.isEmpty()) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> arrayList = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> arrayList2 = new ArrayList<JavaProjectionAnnotation>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavaProjectionAnnotation javaProjectionAnnotation = (JavaProjectionAnnotation)((Object)iterator.next());
            Position position = foldingStructureComputationContext.getModel().getPosition((Annotation)javaProjectionAnnotation);
            if (position == null) continue;
            Tuple tuple = new Tuple(javaProjectionAnnotation, position);
            Tuple tuple2 = this.findMatch(tuple, list2, null, foldingStructureComputationContext);
            boolean bl = true;
            if (tuple2 == null) {
                tuple2 = this.findMatch(tuple, map.keySet(), map, foldingStructureComputationContext);
                bl = false;
            }
            if (tuple2 == null) continue;
            IJavaElement iJavaElement = tuple2.annotation.getElement();
            javaProjectionAnnotation.setElement(iJavaElement);
            position.setLength(tuple2.position.getLength());
            if (position instanceof JavaElementPosition && iJavaElement instanceof IMember) {
                JavaElementPosition javaElementPosition = (JavaElementPosition)position;
                javaElementPosition.setMember((IMember)iJavaElement);
            }
            iterator.remove();
            arrayList2.add(javaProjectionAnnotation);
            if (!bl) continue;
            arrayList.add(tuple2.annotation);
        }
        list.addAll(arrayList);
        list2.addAll(arrayList2);
    }

    private Tuple findMatch(Tuple tuple, Collection collection, Map map, FoldingStructureComputationContext foldingStructureComputationContext) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Position position;
            JavaProjectionAnnotation javaProjectionAnnotation = (JavaProjectionAnnotation)((Object)iterator.next());
            if (tuple.annotation.isComment() != javaProjectionAnnotation.isComment()) continue;
            Position position2 = position = map == null ? foldingStructureComputationContext.getModel().getPosition((Annotation)javaProjectionAnnotation) : (Position)map.get((Object)javaProjectionAnnotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            iterator.remove();
            return new Tuple(javaProjectionAnnotation, position);
        }
        return null;
    }

    private Map computeCurrentStructure(FoldingStructureComputationContext foldingStructureComputationContext) {
        Object object;
        Object object2;
        Object object3;
        HashMap<IJavaElement, ArrayList<Tuple>> hashMap = new HashMap<IJavaElement, ArrayList<Tuple>>();
        ProjectionAnnotationModel projectionAnnotationModel = foldingStructureComputationContext.getModel();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!(object3 instanceof JavaProjectionAnnotation)) continue;
            object2 = (JavaProjectionAnnotation)((Object)object3);
            object = projectionAnnotationModel.getPosition((Annotation)object2);
            Assert.isNotNull((Object)object);
            ArrayList<Tuple> arrayList = (ArrayList<Tuple>)hashMap.get(((JavaProjectionAnnotation)((Object)object2)).getElement());
            if (arrayList == null) {
                arrayList = new ArrayList<Tuple>(2);
                hashMap.put(((JavaProjectionAnnotation)((Object)object2)).getElement(), arrayList);
            }
            arrayList.add(new Tuple((JavaProjectionAnnotation)((Object)object2), (Position)object));
        }
        object3 = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Tuple)object).position.getOffset() - ((Tuple)object2).position.getOffset();
            }
        };
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            object = (List)object2.next();
            Collections.sort(object, object3);
        }
        return hashMap;
    }

    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    public final void collapseElements(IJavaElement[] iJavaElementArray) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(Arrays.asList(iJavaElementArray));
        this.modifyFiltered(new JavaElementSetFilter(hashSet, false), false);
    }

    public final void expandElements(IJavaElement[] iJavaElementArray) {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(Arrays.asList(iJavaElementArray));
        this.modifyFiltered(new JavaElementSetFilter(hashSet, true), true);
    }

    private void modifyFiltered(Filter filter, boolean bl) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel projectionAnnotationModel = this.getModel();
        if (projectionAnnotationModel == null) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> arrayList = new ArrayList<JavaProjectionAnnotation>();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            JavaProjectionAnnotation javaProjectionAnnotation;
            Object e = iterator.next();
            if (!(e instanceof JavaProjectionAnnotation) || bl != (javaProjectionAnnotation = (JavaProjectionAnnotation)((Object)e)).isCollapsed() || !filter.match(javaProjectionAnnotation)) continue;
            if (bl) {
                javaProjectionAnnotation.markExpanded();
            } else {
                javaProjectionAnnotation.markCollapsed();
            }
            arrayList.add(javaProjectionAnnotation);
        }
        projectionAnnotationModel.modifyAnnotations(null, null, arrayList.toArray(new Annotation[arrayList.size()]));
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        public boolean match(JavaProjectionAnnotation javaProjectionAnnotation) {
            return javaProjectionAnnotation.isComment() && !javaProjectionAnnotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int n, int n2) {
            super(n, n2);
        }

        public IRegion[] computeProjectionRegions(IDocument iDocument) throws BadLocationException {
            Region region;
            IRegion iRegion;
            int n;
            DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator(iDocument, this.offset, this.offset + this.length);
            int n2 = 0;
            int n3 = this.findFirstContent(documentCharacterIterator, n2);
            int n4 = iDocument.getLineOfOffset(this.offset + n2);
            int n5 = iDocument.getLineOfOffset(this.offset + n3);
            int n6 = iDocument.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((n4 <= n5 ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((n5 <= n6 ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (n4 < n5) {
                n = iDocument.getLineOffset(n4);
                iRegion = iDocument.getLineInformation(n5);
                int n7 = iRegion.getOffset();
                region = new Region(n, n7 - n);
            } else {
                region = null;
            }
            if (n5 < n6) {
                n = iDocument.getLineOffset(n5 + 1);
                iRegion = new Region(n, this.offset + this.length - n);
                if (region == null) {
                    return new IRegion[]{iRegion};
                }
                return new IRegion[]{region, iRegion};
            }
            if (region != null) {
                return new IRegion[]{region};
            }
            return null;
        }

        private int findFirstContent(CharSequence charSequence, int n) {
            int n2 = charSequence.length();
            int n3 = n;
            while (n3 < n2) {
                if (Character.isUnicodeIdentifierPart(charSequence.charAt(n3))) {
                    return n3;
                }
                ++n3;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument iDocument) {
            DocumentCharacterIterator documentCharacterIterator = new DocumentCharacterIterator(iDocument, this.offset, this.offset + this.length);
            return this.findFirstContent(documentCharacterIterator, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            DefaultJavaFoldingStructureProvider defaultJavaFoldingStructureProvider;
            IJavaElementDelta iJavaElementDelta = this.findElement(DefaultJavaFoldingStructureProvider.this.fInput, elementChangedEvent.getDelta());
            if (iJavaElementDelta == null) return;
            if ((iJavaElementDelta.getFlags() & 9) == 0) return;
            if (this.shouldIgnoreDelta(elementChangedEvent.getDelta().getCompilationUnitAST(), iJavaElementDelta)) {
                return;
            }
            DefaultJavaFoldingStructureProvider defaultJavaFoldingStructureProvider2 = DefaultJavaFoldingStructureProvider.this;
            defaultJavaFoldingStructureProvider2.fUpdatingCount = defaultJavaFoldingStructureProvider2.fUpdatingCount + 1;
            try {
                DefaultJavaFoldingStructureProvider.this.update(DefaultJavaFoldingStructureProvider.this.createContext(false));
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                DefaultJavaFoldingStructureProvider defaultJavaFoldingStructureProvider3 = DefaultJavaFoldingStructureProvider.this;
                defaultJavaFoldingStructureProvider3.fUpdatingCount = defaultJavaFoldingStructureProvider3.fUpdatingCount - 1;
                throw throwable;
            }
            {
                Object var3_5 = null;
                defaultJavaFoldingStructureProvider = DefaultJavaFoldingStructureProvider.this;
            }
            defaultJavaFoldingStructureProvider.fUpdatingCount = defaultJavaFoldingStructureProvider.fUpdatingCount - 1;
        }

        private boolean shouldIgnoreDelta(CompilationUnit compilationUnit, IJavaElementDelta iJavaElementDelta) {
            if (compilationUnit == null) {
                return false;
            }
            IDocument iDocument = DefaultJavaFoldingStructureProvider.this.getDocument();
            if (iDocument == null) {
                return false;
            }
            JavaEditor javaEditor = DefaultJavaFoldingStructureProvider.this.fEditor;
            if (javaEditor == null || javaEditor.getCachedSelectedRange() == null) {
                return false;
            }
            try {
                IJavaElement iJavaElement;
                if (iJavaElementDelta.getAffectedChildren().length == 1 && iJavaElementDelta.getAffectedChildren()[0].getElement() instanceof IImportContainer && !((iJavaElement = SelectionConverter.getElementAtOffset(compilationUnit.getJavaElement(), (ITextSelection)new TextSelection(javaEditor.getCachedSelectedRange().x, javaEditor.getCachedSelectedRange().y))) instanceof IImportDeclaration)) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            int n = 0;
            try {
                n = iDocument.getLineOfOffset(javaEditor.getCachedSelectedRange().x) + 1;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (n > 0 && compilationUnit != null) {
                IProblem[] iProblemArray = compilationUnit.getProblems();
                int n2 = 0;
                while (n2 < iProblemArray.length) {
                    if (iProblemArray[n2].isError() && n == iProblemArray[n2].getSourceLineNumber()) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private IJavaElementDelta findElement(IJavaElement iJavaElement, IJavaElementDelta iJavaElementDelta) {
            if (iJavaElementDelta == null || iJavaElement == null) {
                return null;
            }
            IJavaElement iJavaElement2 = iJavaElementDelta.getElement();
            if (iJavaElement2.getElementType() > 6) {
                return null;
            }
            if (iJavaElement.equals(iJavaElement2)) {
                return iJavaElementDelta;
            }
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iJavaElementDeltaArray.length) {
                IJavaElementDelta iJavaElementDelta2 = this.findElement(iJavaElement, iJavaElementDeltaArray[n]);
                if (iJavaElementDelta2 != null) {
                    return iJavaElementDelta2;
                }
                ++n;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(JavaProjectionAnnotation var1);
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private IType fFirstType;
        private boolean fHasHeaderComment;
        private LinkedHashMap fMap = new LinkedHashMap();
        private IScanner fScanner;

        private FoldingStructureComputationContext(IDocument iDocument, ProjectionAnnotationModel projectionAnnotationModel, boolean bl, IScanner iScanner) {
            Assert.isNotNull((Object)iDocument);
            Assert.isNotNull((Object)projectionAnnotationModel);
            this.fDocument = iDocument;
            this.fModel = projectionAnnotationModel;
            this.fAllowCollapsing = bl;
            this.fScanner = iScanner;
        }

        private void setFirstType(IType iType) {
            if (this.hasFirstType()) {
                throw new IllegalStateException();
            }
            this.fFirstType = iType;
        }

        boolean hasFirstType() {
            return this.fFirstType != null;
        }

        private IType getFirstType() {
            return this.fFirstType;
        }

        private boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        private void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        private IDocument getDocument() {
            return this.fDocument;
        }

        private ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        private IScanner getScanner() {
            if (this.fScanner == null) {
                this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            }
            return this.fScanner;
        }

        public void addProjectionRange(JavaProjectionAnnotation javaProjectionAnnotation, Position position) {
            this.fMap.put(javaProjectionAnnotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseHeaderComments;
        }

        public boolean collapseImportContainer() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseImportContainer;
        }

        public boolean collapseInnerTypes() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseInnerTypes;
        }

        public boolean collapseJavadoc() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseJavadoc;
        }

        public boolean collapseMembers() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseMembers;
        }
    }

    private static final class JavaElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public JavaElementPosition(int n, int n2, IMember iMember) {
            super(n, n2);
            Assert.isNotNull((Object)iMember);
            this.fMember = iMember;
        }

        public void setMember(IMember iMember) {
            Assert.isNotNull((Object)iMember);
            this.fMember = iMember;
        }

        public IRegion[] computeProjectionRegions(IDocument iDocument) throws BadLocationException {
            Region region;
            IRegion iRegion;
            int n;
            int n2 = this.offset;
            try {
                ISourceRange iSourceRange = this.fMember.getNameRange();
                if (iSourceRange != null) {
                    n2 = iSourceRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {}
            int n3 = iDocument.getLineOfOffset(this.offset);
            int n4 = iDocument.getLineOfOffset(n2);
            int n5 = iDocument.getLineOfOffset(this.offset + this.length);
            if (n4 < n3) {
                n4 = n3;
            }
            if (n4 > n5) {
                n4 = n5;
            }
            if (n3 < n4) {
                n = iDocument.getLineOffset(n3);
                iRegion = iDocument.getLineInformation(n4);
                int n6 = iRegion.getOffset();
                region = new Region(n, n6 - n);
            } else {
                region = null;
            }
            if (n4 < n5) {
                n = iDocument.getLineOffset(n4 + 1);
                iRegion = new Region(n, this.offset + this.length - n);
                if (region == null) {
                    return new IRegion[]{iRegion};
                }
                return new IRegion[]{region, iRegion};
            }
            if (region != null) {
                return new IRegion[]{region};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument iDocument) throws BadLocationException {
            int n = this.offset;
            try {
                ISourceRange iSourceRange = this.fMember.getNameRange();
                if (iSourceRange != null) {
                    n = iSourceRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {}
            return n - this.offset;
        }
    }

    private static final class JavaElementSetFilter
    implements Filter {
        private final Set fSet;
        private final boolean fMatchCollapsed;

        private JavaElementSetFilter(Set set, boolean bl) {
            this.fSet = set;
            this.fMatchCollapsed = bl;
        }

        public boolean match(JavaProjectionAnnotation javaProjectionAnnotation) {
            IJavaElement iJavaElement;
            boolean bl;
            boolean bl2 = bl = this.fMatchCollapsed == javaProjectionAnnotation.isCollapsed();
            return bl && !javaProjectionAnnotation.isComment() && !javaProjectionAnnotation.isMarkedDeleted() && this.fSet.contains(iJavaElement = javaProjectionAnnotation.getElement());
        }
    }

    protected static final class JavaProjectionAnnotation
    extends ProjectionAnnotation {
        private IJavaElement fJavaElement;
        private boolean fIsComment;

        public JavaProjectionAnnotation(boolean bl, IJavaElement iJavaElement, boolean bl2) {
            super(bl);
            this.fJavaElement = iJavaElement;
            this.fIsComment = bl2;
        }

        IJavaElement getElement() {
            return this.fJavaElement;
        }

        void setElement(IJavaElement iJavaElement) {
            this.fJavaElement = iJavaElement;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        void setIsComment(boolean bl) {
            this.fIsComment = bl;
        }

        public String toString() {
            return "JavaProjectionAnnotation:\n\telement: \t" + this.fJavaElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        public boolean match(JavaProjectionAnnotation javaProjectionAnnotation) {
            IJavaElement iJavaElement;
            return !javaProjectionAnnotation.isComment() && !javaProjectionAnnotation.isMarkedDeleted() && (iJavaElement = javaProjectionAnnotation.getElement()) instanceof IMember && (iJavaElement.getElementType() != 7 || ((IMember)iJavaElement).getDeclaringType() != null);
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer projectionViewer) {
            Assert.isLegal((projectionViewer != null ? 1 : 0) != 0);
            this.fViewer = projectionViewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultJavaFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultJavaFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static final class Tuple {
        JavaProjectionAnnotation annotation;
        Position position;

        Tuple(JavaProjectionAnnotation javaProjectionAnnotation, Position position) {
            this.annotation = javaProjectionAnnotation;
            this.position = position;
        }
    }
}

