/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;

public class ContentAssistInvocationContext {
    private final ITextViewer fViewer;
    private final IDocument fDocument;
    private final int fOffset;
    private CharSequence fPrefix;

    public ContentAssistInvocationContext(ITextViewer iTextViewer) {
        this(iTextViewer, iTextViewer.getSelectedRange().x);
    }

    public ContentAssistInvocationContext(ITextViewer iTextViewer, int n) {
        Assert.isNotNull((Object)iTextViewer);
        this.fViewer = iTextViewer;
        this.fDocument = null;
        this.fOffset = n;
    }

    protected ContentAssistInvocationContext() {
        this.fDocument = null;
        this.fViewer = null;
        this.fOffset = -1;
    }

    public ContentAssistInvocationContext(IDocument iDocument, int n) {
        Assert.isNotNull((Object)iDocument);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fViewer = null;
        this.fDocument = iDocument;
        this.fOffset = n;
    }

    public final int getInvocationOffset() {
        return this.fOffset;
    }

    public final ITextViewer getViewer() {
        return this.fViewer;
    }

    public IDocument getDocument() {
        if (this.fDocument == null) {
            if (this.fViewer == null) {
                return null;
            }
            return this.fViewer.getDocument();
        }
        return this.fDocument;
    }

    public CharSequence computeIdentifierPrefix() throws BadLocationException {
        if (this.fPrefix == null) {
            int n;
            IDocument iDocument = this.getDocument();
            if (iDocument == null) {
                return null;
            }
            int n2 = n = this.getInvocationOffset();
            while (--n2 >= 0) {
                if (!Character.isJavaIdentifierPart(iDocument.getChar(n2))) break;
            }
            this.fPrefix = iDocument.get(++n2, n - n2);
        }
        return this.fPrefix;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        ContentAssistInvocationContext contentAssistInvocationContext = (ContentAssistInvocationContext)object;
        return (this.fViewer == null && contentAssistInvocationContext.fViewer == null || this.fViewer != null && this.fViewer.equals(contentAssistInvocationContext.fViewer)) && this.fOffset == contentAssistInvocationContext.fOffset && (this.fDocument == null && contentAssistInvocationContext.fDocument == null || this.fDocument != null && this.fDocument.equals(contentAssistInvocationContext.fDocument));
    }

    public int hashCode() {
        return 0x2CBEB1A0 | (this.fViewer == null ? 0 : this.fViewer.hashCode() << 3) | this.fOffset;
    }
}

