/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.wizards.NewTypeWizardPage;

public class NewClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATEMAIN = "create_main";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(NewWizardMessages.NewClassWizardPage_title);
        this.setDescription(NewWizardMessages.NewClassWizardPage_description);
        String[] stringArray = new String[]{NewWizardMessages.NewClassWizardPage_methods_main, NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, stringArray, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection iStructuredSelection) {
        IDialogSettings iDialogSettings;
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        this.initContainerPage(iJavaElement);
        this.initTypePage(iJavaElement);
        this.doStatusUpdate();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        IDialogSettings iDialogSettings2 = this.getDialogSettings();
        if (iDialogSettings2 != null && (iDialogSettings = iDialogSettings2.getSection(PAGE_NAME)) != null) {
            bl = iDialogSettings.getBoolean(SETTINGS_CREATEMAIN);
            bl2 = iDialogSettings.getBoolean(SETTINGS_CREATECONSTR);
            bl3 = iDialogSettings.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(bl, bl2, bl3, true);
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(iStatusArray);
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.doStatusUpdate();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createEnclosingTypeControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createModifierControls(composite2, n);
        this.createSuperClassControls(composite2, n);
        this.createSuperInterfacesControls(composite2, n);
        this.createMethodStubSelectionControls(composite2, n);
        this.createCommentControls(composite2, n);
        this.enableCommentControl(true);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.new_class_wizard_page_context");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.setFocus();
        } else {
            IDialogSettings iDialogSettings = this.getDialogSettings();
            if (iDialogSettings != null) {
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_NAME);
                if (iDialogSettings2 == null) {
                    iDialogSettings2 = iDialogSettings.addNewSection(PAGE_NAME);
                }
                iDialogSettings2.put(SETTINGS_CREATEMAIN, this.isCreateMain());
                iDialogSettings2.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
                iDialogSettings2.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
            }
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int n) {
        Label label = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)label, n);
        DialogField.createEmptySpace(composite);
        Composite composite2 = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)composite2, n - 1);
    }

    public boolean isCreateMain() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    public void setMethodStubSelection(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fMethodStubsButtons.setSelection(0, bl);
        this.fMethodStubsButtons.setSelection(1, bl2);
        this.fMethodStubsButtons.setSelection(2, bl3);
        this.fMethodStubsButtons.setEnabled(bl4);
    }

    protected void createTypeMembers(IType iType, NewTypeWizardPage.ImportsManager importsManager, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = this.isCreateMain();
        boolean bl2 = this.isCreateConstructors();
        boolean bl3 = this.isCreateInherited();
        this.createInheritedMethods(iType, bl2, bl3, importsManager, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = CodeGeneration.getMethodComment(iType.getCompilationUnit(), iType.getTypeQualifiedName('.'), "main", new String[]{"args"}, new String[0], Signature.createTypeSignature((String)"void", (boolean)true), null, "\n");
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            stringBuffer.append("public static void main(");
            stringBuffer.append(importsManager.addImport("java.lang.String"));
            stringBuffer.append("[] args) {");
            stringBuffer.append("\n");
            String string2 = CodeGeneration.getMethodBodyContent(iType.getCompilationUnit(), iType.getTypeQualifiedName('.'), "main", false, "", "\n");
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append("\n");
            stringBuffer.append("}");
            iType.createMethod(stringBuffer.toString(), null, false, null);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }
}

