/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.wst.jsdt.jsdoc.Util;

public class ElementInfo {
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PROPERTY = 3;
    public static final int EVENT = 4;
    public static final int COLLECTION = 5;
    protected String name;
    protected String baseUrl;
    protected ElementInfo parent;
    protected ElementInfo[] children;
    protected int type = -5;
    protected static ArrayList nodes;
    protected boolean visited = false;
    protected static int instances;
    protected static boolean DEBUG;
    protected static boolean useCache;
    protected static boolean keepCache;

    static {
        instances = 0;
        DEBUG = false;
    }

    public boolean shouldUseCache() {
        return useCache;
    }

    public boolean shouldKeepCache() {
        return keepCache;
    }

    public static void setUseCache(boolean bl) {
        useCache = bl;
    }

    public static void setKeepCache(boolean bl) {
        keepCache = bl;
    }

    public boolean visit() {
        boolean bl = this.visited;
        this.visited = true;
        return bl;
    }

    public boolean equals(Object object) {
        try {
            ElementInfo elementInfo = (ElementInfo)object;
            boolean bl = elementInfo.getUrl().trim().equalsIgnoreCase(this.getUrl().trim());
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void freeObject(ElementInfo elementInfo) {
        int n = 0;
        while (n < nodes.size()) {
            ElementInfo elementInfo2 = (ElementInfo)nodes.get(n);
            if (elementInfo2.getUrl().equalsIgnoreCase(elementInfo.getUrl())) {
                nodes.remove(n);
                break;
            }
            ++n;
        }
    }

    public ElementInfo[] getFoundObjects() {
        ArrayList<ElementInfo> arrayList = new ArrayList<ElementInfo>();
        ElementInfo[] elementInfoArray = this.getChildren();
        int n = 0;
        while (n < elementInfoArray.length) {
            if (elementInfoArray[n].getType() == 5 || elementInfoArray[n].getType() == 4) {
                elementInfoArray[n].clearVisit();
                arrayList.add(elementInfoArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ElementInfo[arrayList.size()]);
    }

    public void clearVisit() {
        this.visited = false;
    }

    public ElementInfo(String string, ElementInfo elementInfo) {
        nodes = new ArrayList();
        this.baseUrl = string;
        this.parent = elementInfo;
        if (DEBUG) {
            System.out.println("Creating new instance for total of : " + ++instances);
        }
    }

    public void finalize() {
        if (DEBUG) {
            System.out.println("Destroying instance for total of : " + --instances);
        }
    }

    public void addNode(ElementInfo elementInfo) {
        nodes.add(elementInfo);
    }

    public static ElementInfo findChild(String string) {
        int n = 0;
        while (n < nodes.size()) {
            ElementInfo elementInfo = (ElementInfo)nodes.get(n);
            if (elementInfo.getUrl().equalsIgnoreCase(string)) {
                return elementInfo;
            }
            ++n;
        }
        return null;
    }

    public boolean isDefined(String string) {
        return ElementInfo.findChild(string) != null;
    }

    private ElementInfo() {
        nodes = new ArrayList();
    }

    public ElementInfo getParent() {
        return this.parent;
    }

    public ElementInfo[] getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.baseUrl;
    }

    public String getJsDoc(String string) {
        return null;
    }

    public String getJsStructure() {
        return null;
    }

    public String getTypeName() {
        switch (this.getType()) {
            case 3: {
                return "Property";
            }
            case 2: {
                return "Method";
            }
            case 1: {
                return "Class";
            }
        }
        return "Unknown Type";
    }

    public int getType() {
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name : " + this.getName() + Util.NEW_LINE);
        stringBuffer.append("Type : " + this.getTypeName() + "Util.NEW_LINE");
        if (this.getParent() != null) {
            stringBuffer.append("\tParent Name : " + this.getParent().getName() + Util.NEW_LINE);
            stringBuffer.append("\tParent Type : " + this.getParent().getTypeName() + Util.NEW_LINE);
        } else {
            stringBuffer.append("No Parent" + Util.NEW_LINE);
        }
        stringBuffer.append("baseUrl : " + this.baseUrl + Util.NEW_LINE);
        stringBuffer.append("----------------Children--------------" + Util.NEW_LINE + "Name\t\t\t\tType" + Util.NEW_LINE);
        if (this.hasChildren()) {
            ElementInfo[] elementInfoArray = this.getChildren();
            int n = 0;
            while (n < elementInfoArray.length) {
                stringBuffer.append(String.valueOf(elementInfoArray[n].getName()) + "\t\t\t" + elementInfoArray[n].getTypeName() + Util.NEW_LINE);
                ++n;
            }
        } else {
            stringBuffer.append(String.valueOf(Util.NEW_LINE) + "No Children" + Util.NEW_LINE);
        }
        stringBuffer.append("--------------------------------------");
        return stringBuffer.toString();
    }

    protected String getPageText() {
        try {
            return Util.retrieveFromUrl(this.getUrl(), this.shouldUseCache(), !this.shouldKeepCache());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getBaseUrl() {
        return Util.getBaseUrl(this.getUrl());
    }

    public String getDeclarationString() {
        return null;
    }

    public String getJsStructure(String string) {
        return "NOT DEFINED " + string;
    }

    public boolean isStatic() {
        return false;
    }
}

