/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.atf.adapter.IWebResourceLocator;
import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.natures.ArtifactHandlerUtil;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.installer.IRuntimeInstaller;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.common.EnvEntryType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WARRuntimeInstaller
implements IRuntimeInstaller {
    private static final int ADDVALUES = 0;
    private static final int REMOVEVALUES = 1;
    private static String[] EXCLUDE_LIST = new String[]{"WEB-INF", "META-INF", "web.xml", "MANIFEST.MF"};
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(IRuntimeInstance iRuntimeInstance, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IWebResourceLocator iWebResourceLocator;
        iProgressMonitor.beginTask("Handler installing runtime " + iRuntimeInstance.getType().getName() + " into project " + iProject.getName() + "...", 100);
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.atf.adapter.IWebResourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((iWebResourceLocator = (IWebResourceLocator)iProject.getAdapter((Class)clazz)) == null) {
            return;
        }
        IContainer iContainer = iWebResourceLocator.getWebResourceContainer();
        try {
            try {
                URL uRL;
                if (!iContainer.exists()) {
                    iProject.getFolder(iContainer.getProjectRelativePath()).create(true, true, null);
                }
                if (!"file".equalsIgnoreCase((uRL = new URL(iRuntimeInstance.getLocation())).getProtocol())) {
                    uRL = FileLocator.toFileURL((URL)uRL);
                }
                iProgressMonitor.worked(10);
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 90);
                subProgressMonitor.setTaskName("Copying runtime assets...");
                this.mergeTree(new File(uRL.getPath()), iContainer, (IProgressMonitor)subProgressMonitor);
                IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
                this.mergeDeploymentDescriptors(new File(String.valueOf(uRL.getPath()) + System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator") + "web.xml"), iVirtualComponent);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, "Error installing runtime instance! Location <" + iRuntimeInstance.getLocation() + "> is not a valid URL.", (Throwable)malformedURLException));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, "Error installing runtime instance! Location <" + iRuntimeInstance.getLocation() + "> is not a valid platform URL.", (Throwable)iOException));
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(IRuntimeInstance iRuntimeInstance, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IWebResourceLocator iWebResourceLocator;
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.atf.adapter.IWebResourceLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((iWebResourceLocator = (IWebResourceLocator)iProject.getAdapter((Class)clazz)) == null) {
            return;
        }
        iProgressMonitor.beginTask("Handler uninstalling runtime " + iRuntimeInstance.getType().getName() + " from project " + iProject.getName() + "...", 100);
        if (iWebResourceLocator == null) {
            return;
        }
        IContainer iContainer = iWebResourceLocator.getWebResourceContainer();
        IPath iPath = iContainer.getFullPath();
        iProgressMonitor.worked(10);
        try {
            try {
                URL uRL = new URL(iRuntimeInstance.getLocation());
                if (!"file".equalsIgnoreCase(uRL.getProtocol())) {
                    uRL = FileLocator.toFileURL((URL)uRL);
                }
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 80);
                IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
                this.uninstallDeploymentDescriptors(new File(String.valueOf(uRL.getPath()) + System.getProperty("file.separator") + "WEB-INF" + System.getProperty("file.separator") + "web.xml"), iVirtualComponent);
                subProgressMonitor.setTaskName("Deleting runtime assets...");
                this.removeRuntimeTree(new File(uRL.getPath()), iPath, iProject.getWorkspace().getRoot(), (IProgressMonitor)subProgressMonitor);
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
                subProgressMonitor.setTaskName("Refresing workspace...");
                iContainer.refreshLocal(0, (IProgressMonitor)subProgressMonitor);
            }
            catch (IOException iOException) {
                CorePlugin.log((Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeRuntimeTree(File file, IPath iPath, IWorkspaceRoot iWorkspaceRoot, IProgressMonitor iProgressMonitor) {
        if (file == null || iWorkspaceRoot == null) {
            iProgressMonitor.done();
            return;
        }
        try {
            try {
                if (file.exists()) {
                    File[] fileArray = file.isDirectory() ? file.listFiles() : new File[]{file};
                    iProgressMonitor.beginTask("Deleting files from runtime" + file.getName() + "...", fileArray.length);
                    int n = 0;
                    while (n < fileArray.length) {
                        File file2 = fileArray[n];
                        boolean bl = file2.getName().toLowerCase().equals("web.xml");
                        if (file2.isFile() && !bl) {
                            iProgressMonitor.subTask("Deleting file " + file2.getName() + "...");
                            if (!this.shouldExclude(file2.getName())) {
                                iWorkspaceRoot.getFile(iPath.append(file2.getName())).delete(true, iProgressMonitor);
                            }
                        } else if (file2.isDirectory()) {
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            this.removeRuntimeTree(file2, iPath.append(file2.getName()), iWorkspaceRoot, (IProgressMonitor)subProgressMonitor);
                            IFolder iFolder = iWorkspaceRoot.getFolder(iPath.append(file2.getName()));
                            if (!this.shouldExclude(iFolder.getName())) {
                                iFolder.delete(false, (IProgressMonitor)subProgressMonitor);
                            }
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                CorePlugin.log((Throwable)coreException);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeTree(File file, IContainer iContainer, IProgressMonitor iProgressMonitor) {
        if (file == null || iContainer == null) {
            iProgressMonitor.done();
            return;
        }
        try {
            try {
                if (file.exists()) {
                    File[] fileArray = file.isDirectory() ? file.listFiles() : new File[]{file};
                    iProgressMonitor.beginTask("Copying files from " + file.getName() + "...", fileArray.length);
                    int n = 0;
                    while (n < fileArray.length) {
                        File file2 = fileArray[n];
                        if (file2.isFile()) {
                            this.copyFile(file2, iContainer, iProgressMonitor);
                        } else if (file2.isDirectory()) {
                            IFolder iFolder = iContainer.getProject().getFolder(iContainer.getProjectRelativePath().append(file2.getName()));
                            if (!iFolder.exists()) {
                                iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            this.mergeTree(file2, (IContainer)iFolder, (IProgressMonitor)subProgressMonitor);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                CorePlugin.log((Throwable)iOException);
            }
            catch (CoreException coreException) {
                CorePlugin.log((Throwable)coreException);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        iProgressMonitor.done();
    }

    protected void copyFile(File file, IContainer iContainer, IProgressMonitor iProgressMonitor) throws FileNotFoundException, CoreException, IOException {
        iProgressMonitor.subTask("Copying file " + file.getName() + "...");
        IFile iFile = iContainer.getProject().getFile(iContainer.getProjectRelativePath().append(file.getName()));
        FileInputStream fileInputStream = new FileInputStream(file);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
        subProgressMonitor.setTaskName("Creating file in project...");
        boolean bl = iFile.getName().toLowerCase().equals("web.xml");
        if (!iFile.exists() && !bl) {
            iFile.create((InputStream)fileInputStream, true, (IProgressMonitor)subProgressMonitor);
        } else if (!bl) {
            iFile.setContents((InputStream)fileInputStream, true, false, (IProgressMonitor)subProgressMonitor);
        }
        fileInputStream.close();
    }

    protected void mergeDeploymentDescriptors(File file, IVirtualComponent iVirtualComponent) throws CoreException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            return;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new FileInputStream(file));
        }
        catch (Exception exception) {
            return;
        }
        this.updateServlets(document, iVirtualComponent, 0);
        this.updateContextParams(document, iVirtualComponent, 0);
        this.updateServletMapping(document, iVirtualComponent, 0);
        this.updateEnvEntries(document, iVirtualComponent, 0);
    }

    protected void uninstallDeploymentDescriptors(File file, IVirtualComponent iVirtualComponent) throws CoreException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            return;
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new FileInputStream(file));
        }
        catch (Exception exception) {
            return;
        }
        this.updateServlets(document, iVirtualComponent, 1);
        this.updateContextParams(document, iVirtualComponent, 1);
        this.updateServletMapping(document, iVirtualComponent, 1);
        this.updateEnvEntries(document, iVirtualComponent, 1);
    }

    private void updateServlets(Document document, IVirtualComponent iVirtualComponent, int n) throws CoreException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("servlet");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            String string = null;
            String string2 = null;
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node = nodeList2.item(n3);
                if (node.getNodeName().equalsIgnoreCase("servlet-name")) {
                    string = ((Text)node.getFirstChild()).getData().trim();
                }
                if (node.getNodeName().equalsIgnoreCase("servlet-class")) {
                    string2 = ((Text)node.getFirstChild()).getData().trim();
                }
                ++n3;
            }
            if (string2 != null && string != null) {
                switch (n) {
                    case 0: {
                        ArtifactHandlerUtil.addServlet(iVirtualComponent, string, string2);
                        break;
                    }
                    case 1: {
                        ArtifactHandlerUtil.removeServlet(iVirtualComponent, string);
                    }
                }
            }
            ++n2;
        }
    }

    private void updateServletMapping(Document document, IVirtualComponent iVirtualComponent, int n) throws CoreException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("servlet-mapping");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            String string = null;
            String string2 = null;
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node = nodeList2.item(n3);
                if (node.getNodeName().equalsIgnoreCase("servlet-name")) {
                    string = ((Text)node.getFirstChild()).getData().trim();
                }
                if (node.getNodeName().equalsIgnoreCase("url-pattern")) {
                    string2 = ((Text)node.getFirstChild()).getData().trim();
                }
                ++n3;
            }
            if (string2 != null && string != null) {
                switch (n) {
                    case 0: {
                        ArtifactHandlerUtil.addServletMapping(iVirtualComponent, string, string2);
                        break;
                    }
                    case 1: {
                        ArtifactHandlerUtil.removeServletMapping(iVirtualComponent, string);
                    }
                }
            }
            ++n2;
        }
    }

    private void updateContextParams(Document document, IVirtualComponent iVirtualComponent, int n) throws CoreException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("context-param");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            String string = null;
            String string2 = null;
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node = nodeList2.item(n3);
                if (node.getNodeName().equalsIgnoreCase("param-name")) {
                    string = ((Text)node.getFirstChild()).getData().trim();
                }
                if (node.getNodeName().equalsIgnoreCase("param-value")) {
                    string2 = ((Text)node.getFirstChild()).getData().trim();
                }
                ++n3;
            }
            if (string2 != null && string != null) {
                switch (n) {
                    case 0: {
                        ArtifactHandlerUtil.addContextParam(iVirtualComponent, string, string2);
                        break;
                    }
                    case 1: {
                        ArtifactHandlerUtil.removeContextParam(iVirtualComponent, string);
                    }
                }
            }
            ++n2;
        }
    }

    private void updateEnvEntries(Document document, IVirtualComponent iVirtualComponent, int n) throws CoreException {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("env-entry");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            NodeList nodeList2 = nodeList.item(n2).getChildNodes();
            String string = null;
            String string2 = null;
            EnvEntryType envEntryType = null;
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node = nodeList2.item(n3);
                if (node.getNodeName().equalsIgnoreCase("env-entry-name")) {
                    string = ((Text)node.getFirstChild()).getData().trim();
                }
                if (node.getNodeName().equalsIgnoreCase("env-entry-value")) {
                    string2 = ((Text)node.getFirstChild()).getData().trim();
                }
                if (node.getNodeName().equalsIgnoreCase("env-entry-type")) {
                    String string3 = ((Text)node.getFirstChild()).getData().toUpperCase();
                    if (string3.indexOf("STRING") >= 0) {
                        envEntryType = EnvEntryType.STRING_LITERAL;
                    }
                    if (string3.indexOf("INTEGER") >= 0) {
                        envEntryType = EnvEntryType.INTEGER_LITERAL;
                    }
                    if (string3.indexOf("BOOLEAN") >= 0) {
                        envEntryType = EnvEntryType.BOOLEAN_LITERAL;
                    }
                    if (string3.indexOf("DOUBLE") >= 0) {
                        envEntryType = EnvEntryType.DOUBLE_LITERAL;
                    }
                    if (string3.indexOf("BYTE") >= 0) {
                        envEntryType = EnvEntryType.BYTE_LITERAL;
                    }
                    if (string3.indexOf("SHORT") >= 0) {
                        envEntryType = EnvEntryType.SHORT_LITERAL;
                    }
                    if (string3.indexOf("LONG") >= 0) {
                        envEntryType = EnvEntryType.LONG_LITERAL;
                    }
                    if (string3.indexOf("FLOAT") >= 0) {
                        envEntryType = EnvEntryType.FLOAT_LITERAL;
                    }
                    if (string3.indexOf("CHARACTER") >= 0) {
                        envEntryType = EnvEntryType.CHARACTER_LITERAL;
                    }
                }
                ++n3;
            }
            if (string2 != null && string != null) {
                switch (n) {
                    case 0: {
                        ArtifactHandlerUtil.addEnvEntry(iVirtualComponent, string, envEntryType, string2);
                        break;
                    }
                    case 1: {
                        ArtifactHandlerUtil.removeEnvEntry(iVirtualComponent, string);
                    }
                }
            }
            ++n2;
        }
    }

    private boolean shouldExclude(String string) {
        int n = 0;
        while (n < EXCLUDE_LIST.length) {
            if (EXCLUDE_LIST[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IPath getProjectInstallPath(IRuntimeInstance iRuntimeInstance) {
        throw new RuntimeException("not implemented");
    }
}

