/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.manipulation;

import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;

public class JavaElementPropertyTester
extends PropertyTester {
    public static final String NAME = "name";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_JAVA_PROJECT_WITH_NATURE = "isInJavaProjectWithNature";
    public static final String IS_ON_CLASSPATH = "isOnClasspath";
    public static final String HAS_TYPE_ON_CLASSPATH = "hasTypeOnClasspath";
    public static final String IN_SOURCE_FOLDER = "inSourceFolder";
    public static final String IN_ARCHIVE = "inArchive";
    public static final String IN_EXTERNAL_ARCHIVE = "inExternalArchive";
    public static final String PROJECT_OPTION = "projectOption";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        IJavaProject iJavaProject;
        if (!(object instanceof IJavaElement)) {
            return false;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        if (string.equals(NAME)) {
            return Pattern.matches(this.toString(object2), iJavaElement.getElementName());
        }
        if (string.equals(IS_IN_JAVA_PROJECT)) {
            IJavaProject iJavaProject2 = iJavaElement.getJavaProject();
            return iJavaProject2 != null && iJavaProject2.exists() && iJavaProject2.getProject().isOpen();
        }
        if (string.equals(IS_IN_JAVA_PROJECT_WITH_NATURE)) {
            IJavaProject iJavaProject3 = iJavaElement.getJavaProject();
            if (iJavaProject3 != null && iJavaProject3.exists() && iJavaProject3.getProject().isOpen() && object2 != null) {
                try {
                    return iJavaProject3.getProject().hasNature(this.toString(object2));
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return false;
        }
        if (string.equals(IS_ON_CLASSPATH)) {
            IJavaProject iJavaProject4 = iJavaElement.getJavaProject();
            if (iJavaProject4 != null && iJavaProject4.exists()) {
                return iJavaProject4.isOnClasspath(iJavaElement);
            }
            return false;
        }
        if (string.equals(IN_SOURCE_FOLDER)) {
            IJavaElement iJavaElement2 = iJavaElement.getAncestor(3);
            if (iJavaElement2 != null) {
                try {
                    return ((IPackageFragmentRoot)iJavaElement2).getKind() == 1;
                }
                catch (JavaModelException javaModelException) {}
            }
            return false;
        }
        if (string.equals(IN_ARCHIVE)) {
            IJavaElement iJavaElement3 = iJavaElement.getAncestor(3);
            if (iJavaElement3 != null) {
                return ((IPackageFragmentRoot)iJavaElement3).isArchive();
            }
            return false;
        }
        if (string.equals(IN_EXTERNAL_ARCHIVE)) {
            IJavaElement iJavaElement4 = iJavaElement.getAncestor(3);
            if (iJavaElement4 != null) {
                return ((IPackageFragmentRoot)iJavaElement4).isExternal();
            }
            return false;
        }
        if (string.equals(PROJECT_OPTION)) {
            IJavaProject iJavaProject5 = iJavaElement.getJavaProject();
            if (iJavaProject5 != null) {
                if (objectArray.length == 2) {
                    String string2 = iJavaProject5.getOption(this.toString(objectArray[0]), true);
                    return string2 != null && string2.equals(objectArray[1]);
                }
                if (objectArray.length == 1) {
                    return iJavaProject5.getOption(this.toString(objectArray[0]), false) != null;
                }
            }
            return false;
        }
        if (string.equals(HAS_TYPE_ON_CLASSPATH) && (iJavaProject = iJavaElement.getJavaProject()) != null && iJavaProject.exists()) {
            try {
                return iJavaProject.findType(this.toString(object2)) != null;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private String toString(Object object) {
        return object == null ? "" : object.toString();
    }
}

