/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslation;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.internal.java.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsValidator
implements IValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspvalidator"));
    private IValidator fMessageOriginator;
    private static String[] jsdtValidator = new String[]{"org.eclipse.wst.jsdt.web.core.internal.validation.JsBatchValidator"};
    static /* synthetic */ Class class$0;

    public JsValidator() {
        this.fMessageOriginator = this;
    }

    public JsValidator(IValidator iValidator) {
        this.fMessageOriginator = iValidator;
    }

    private IMessage createMessageFromProblem(IProblem iProblem, IFile iFile, JsTranslation jsTranslation, IStructuredDocument iStructuredDocument) {
        int n = iProblem.getSourceStart();
        int n2 = iProblem.getSourceEnd();
        if (n == -1) {
            return null;
        }
        int n3 = iStructuredDocument.getLineOfOffset(n) + 1;
        int n4 = iProblem.isError() ? 1 : 2;
        LocalizedMessage localizedMessage = new LocalizedMessage(n4, iProblem.getMessage(), (IResource)iFile);
        localizedMessage.setLineNo(n3);
        localizedMessage.setOffset(n);
        localizedMessage.setLength(n2 - n + 1);
        return localizedMessage;
    }

    void performValidation(IFile iFile, IReporter iReporter, IStructuredModel iStructuredModel, boolean bl) {
        if (iStructuredModel instanceof IDOMModel) {
            IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
            this.setupAdapterFactory((IStructuredModel)iDOMModel);
            IDOMDocument iDOMDocument = iDOMModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.internal.java.IJsTranslation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JsTranslationAdapter jsTranslationAdapter = (JsTranslationAdapter)iDOMDocument.getAdapterFor((Object)clazz);
            JsTranslation jsTranslation = jsTranslationAdapter.getJSPTranslation(false);
            if (!iReporter.isCancelled()) {
                jsTranslation.setProblemCollectingActive(true);
                jsTranslation.reconcileCompilationUnit();
                List list = jsTranslation.getProblems();
                if (!bl) {
                    iReporter.removeAllMessages((IValidator)this, (Object)iFile);
                }
                int n = 0;
                while (n < list.size() && !iReporter.isCancelled()) {
                    IMessage iMessage = this.createMessageFromProblem((IProblem)list.get(n), iFile, jsTranslation, iDOMModel.getStructuredDocument());
                    if (iMessage != null) {
                        iReporter.addMessage(this.fMessageOriginator, iMessage);
                    }
                    ++n;
                }
            }
        }
    }

    private void setupAdapterFactory(IStructuredModel iStructuredModel) {
        FactoryRegistry factoryRegistry = iStructuredModel.getFactoryRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.internal.java.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (factoryRegistry.getFactoryFor((Object)clazz) == null) {
            JsTranslationAdapterFactory jsTranslationAdapterFactory = new JsTranslationAdapterFactory();
            iStructuredModel.getFactoryRegistry().addFactory((INodeAdapterFactory)jsTranslationAdapterFactory);
        }
    }

    private boolean shouldValidate(IFile iFile) {
        IFile iFile2 = iFile;
        do {
            if (!iFile2.isDerived() && !iFile2.isTeamPrivateMember() && iFile2.isAccessible() && iFile2.getName().charAt(0) != '.') continue;
            return false;
        } while (((iFile2 = iFile2.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        block11: {
            JSPFileVisitor jSPFileVisitor;
            block9: {
                block10: {
                    String[] stringArray = iValidationContext.getURIs();
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (stringArray.length <= 0) break block10;
                    IFile iFile = null;
                    int n = 0;
                    while (n < stringArray.length && !iReporter.isCancelled()) {
                        iFile = iWorkspaceRoot.getFile((IPath)new Path(stringArray[n]));
                        iReporter.removeAllMessages((IValidator)this, (Object)iFile);
                        if (iFile != null && iFile.exists()) {
                            if (this.shouldValidate(iFile)) {
                                int n2 = n * 100 / stringArray.length + 1;
                                LocalizedMessage localizedMessage = new LocalizedMessage(4, String.valueOf(n2) + "% " + stringArray[n]);
                                iReporter.displaySubtask((IValidator)this, (IMessage)localizedMessage);
                                this.validateFile(iFile, iReporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + stringArray[n] + "]");
                            }
                        }
                        ++n;
                    }
                    break block11;
                }
                if (!(iValidationContext instanceof IWorkbenchContext)) break block11;
                IProject iProject = ((IWorkbenchContext)iValidationContext).getProject();
                jSPFileVisitor = new JSPFileVisitor(iReporter);
                try {
                    iProject.accept((IResourceProxyVisitor)jSPFileVisitor, 2);
                }
                catch (CoreException coreException) {
                    if (!DEBUG) break block9;
                    coreException.printStackTrace();
                }
            }
            IFile[] iFileArray = jSPFileVisitor.getFiles();
            int n = 0;
            while (n < iFileArray.length && !iReporter.isCancelled()) {
                if (this.shouldValidate(iFileArray[n])) {
                    int n3 = n * 100 / iFileArray.length + 1;
                    LocalizedMessage localizedMessage = new LocalizedMessage(4, String.valueOf(n3) + "% " + iFileArray[n].getFullPath().toString());
                    iReporter.displaySubtask((IValidator)this, (IMessage)localizedMessage);
                    this.validateFile(iFileArray[n], iReporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + iFileArray[n] + "]");
                }
                ++n;
            }
        }
    }

    public void cleanup(IReporter iReporter) {
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile var1_1, IReporter var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class JSPFileVisitor
    implements IResourceProxyVisitor {
        private IContentType[] fContentTypes = null;
        private List fFiles = new ArrayList();
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter iReporter) {
            this.fReporter = iReporter;
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            IFile iFile;
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (iResourceProxy.getType() == 1 && Util.isJsType(iResourceProxy.getName()) && (iFile = (IFile)iResourceProxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + iFile.getName());
                }
                this.fFiles.add(iFile);
                return false;
            }
            return true;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int n, String string) {
            this(n, string, null);
        }

        public LocalizedMessage(int n, String string, IResource iResource) {
            this(n, string, (Object)iResource);
        }

        public LocalizedMessage(int n, String string, Object object) {
            super(null, n, null);
            this.setLocalizedMessage(string);
            this.setTargetObject(object);
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader classLoader) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale locale) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale locale, ClassLoader classLoader) {
            return this.getLocalizedMessage();
        }

        public void setLocalizedMessage(String string) {
            this._message = string;
        }
    }
}

