/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IProblem fParsingError;
    private ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private final boolean fAllowSyntaxErrors;

    public OrganizeImportsOperation(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3, IChooseImportQuery iChooseImportQuery) throws CoreException {
        this.fCompilationUnit = iCompilationUnit;
        this.fASTRoot = compilationUnit;
        this.fDoSave = bl2;
        this.fIgnoreLowerCaseNames = bl;
        this.fAllowSyntaxErrors = bl3;
        this.fChooseImportQuery = iChooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fParsingError = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        block6: {
            block5: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                try {
                    iProgressMonitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, this.fCompilationUnit.getElementName()), 10);
                    TextEdit textEdit = this.createTextEdit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 9));
                    if (textEdit == null) {
                        Object var3_3 = null;
                        break block5;
                    }
                    JavaModelUtil.applyEdit(this.fCompilationUnit, textEdit, this.fDoSave, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var3_5 = null;
        iProgressMonitor.done();
    }

    public TextEdit createTextEdit(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        TextEdit textEdit;
        HashSet hashSet;
        HashSet hashSet2;
        ArrayList arrayList;
        ArrayList arrayList2;
        ImportRewrite importRewrite;
        CompilationUnit compilationUnit;
        block11: {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            iProgressMonitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, this.fCompilationUnit.getElementName()), 9);
            compilationUnit = this.fASTRoot;
            if (compilationUnit == null) {
                compilationUnit = ASTProvider.getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            } else {
                iProgressMonitor.worked(2);
            }
            importRewrite = StubUtility.createImportRewrite(compilationUnit, false);
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            hashSet2 = new HashSet();
            hashSet = new HashSet();
            if (this.collectReferences(compilationUnit, arrayList2, arrayList, hashSet2, hashSet)) break block11;
            Object var16_8 = null;
            iProgressMonitor.done();
            return null;
        }
        try {
            TextEdit textEdit2;
            iProgressMonitor.worked(1);
            TypeReferenceProcessor typeReferenceProcessor = new TypeReferenceProcessor(hashSet2, hashSet, compilationUnit, importRewrite, this.fIgnoreLowerCaseNames);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                SimpleName simpleName = (SimpleName)iterator.next();
                typeReferenceProcessor.add(simpleName);
            }
            boolean bl = typeReferenceProcessor.process((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            this.addStaticImports(arrayList, importRewrite);
            if (bl && this.fChooseImportQuery != null) {
                ISourceRange[] iSourceRangeArray;
                textEdit2 = typeReferenceProcessor.getChoices();
                TypeNameMatch[] typeNameMatchArray = this.fChooseImportQuery.chooseImports((TypeNameMatch[][])textEdit2, iSourceRangeArray = typeReferenceProcessor.getChoicesSourceRanges());
                if (typeNameMatchArray == null) {
                    throw new OperationCanceledException();
                }
                int n = 0;
                while (n < typeNameMatchArray.length) {
                    TypeNameMatch typeNameMatch = typeNameMatchArray[n];
                    importRewrite.addImport(typeNameMatch.getFullyQualifiedName());
                    ++n;
                }
            }
            textEdit2 = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            this.determineImportDifferences(importRewrite, hashSet2, hashSet);
            textEdit = textEdit2;
            Object var16_9 = null;
        }
        catch (Throwable throwable) {
            Object var16_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return textEdit;
    }

    private void determineImportDifferences(ImportRewrite importRewrite, Set set, Set set2) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(importRewrite.getCreatedImports()));
        arrayList.addAll(Arrays.asList(importRewrite.getCreatedStaticImports()));
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = (String)objectArray[n];
            if (arrayList.remove(string)) {
                set.remove(string);
            }
            ++n;
        }
        objectArray = set2.toArray();
        n = 0;
        while (n < objectArray.length) {
            string = (String)objectArray[n];
            if (arrayList.remove(String.valueOf(string) + ".*")) {
                set2.remove(string);
            }
            ++n;
        }
        this.fNumberOfImportsAdded = arrayList.size();
        this.fNumberOfImportsRemoved = set.size() + set2.size();
    }

    private void addStaticImports(List list, ImportRewrite importRewrite) {
        int n = 0;
        while (n < list.size()) {
            Name name = (Name)list.get(n);
            IBinding iBinding = name.resolveBinding();
            if (iBinding != null) {
                importRewrite.addStaticImport(iBinding);
            }
            ++n;
        }
    }

    private boolean collectReferences(CompilationUnit compilationUnit, List list, List list2, Set set, Set set2) {
        Object object;
        int n;
        Object object2;
        if (!this.fAllowSyntaxErrors) {
            object2 = compilationUnit.getProblems();
            n = 0;
            while (n < ((IProblem[])object2).length) {
                object = object2[n];
                if (object.isError() && (object.getID() & 0x40000000) != 0) {
                    this.fParsingError = object2[n];
                    return false;
                }
                ++n;
            }
        }
        object2 = compilationUnit.imports();
        n = 0;
        while (n < object2.size()) {
            object = (ImportDeclaration)object2.get(n);
            String string = ASTResolving.getFullName(object.getName());
            if (object.isOnDemand()) {
                set2.add(string);
            } else {
                set.add(string);
            }
            ++n;
        }
        IJavaProject iJavaProject = this.fCompilationUnit.getJavaProject();
        ImportReferencesCollector.collect((ASTNode)compilationUnit, iJavaProject, null, list, list2);
        return true;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    private static class TypeReferenceProcessor {
        private Set fOldSingleImports;
        private Set fOldDemandImports;
        private Set fImplicitImports;
        private ImportRewrite fImpStructure;
        private boolean fDoIgnoreLowerCaseNames;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;
        private boolean fAllowDefaultPackageImports;
        private Map fUnresolvedTypes;
        private Set fImportsAdded;
        private TypeNameMatch[][] fOpenChoices;
        private SourceRange[] fSourceRanges;

        public TypeReferenceProcessor(Set set, Set set2, CompilationUnit compilationUnit, ImportRewrite importRewrite, boolean bl) {
            this.fOldSingleImports = set;
            this.fOldDemandImports = set2;
            this.fImpStructure = importRewrite;
            this.fDoIgnoreLowerCaseNames = bl;
            ICompilationUnit iCompilationUnit = importRewrite.getCompilationUnit();
            this.fImplicitImports = new HashSet(3);
            this.fImplicitImports.add("");
            this.fImplicitImports.add("java.lang");
            this.fImplicitImports.add(iCompilationUnit.getParent().getElementName());
            this.fAnalyzer = new ScopeAnalyzer(compilationUnit);
            this.fCurrPackage = (IPackageFragment)iCompilationUnit.getParent();
            this.fAllowDefaultPackageImports = iCompilationUnit.getJavaProject().getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true).equals("1.3");
            this.fImportsAdded = new HashSet();
            this.fUnresolvedTypes = new HashMap();
        }

        private boolean needsImport(ITypeBinding iTypeBinding, SimpleName simpleName) {
            if (!iTypeBinding.isTopLevel() && !iTypeBinding.isMember() || iTypeBinding.isRecovered()) {
                return false;
            }
            int n = iTypeBinding.getModifiers();
            if (Modifier.isPrivate((int)n)) {
                return false;
            }
            ITypeBinding iTypeBinding2 = Bindings.getBindingOfParentType((ASTNode)simpleName);
            if (iTypeBinding2 == null) {
                return false;
            }
            if (!Modifier.isPublic((int)n) && !iTypeBinding2.getPackage().getName().equals(iTypeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode aSTNode = simpleName.getParent();
            while (aSTNode instanceof Type) {
                aSTNode = aSTNode.getParent();
            }
            if (aSTNode instanceof AbstractTypeDeclaration && aSTNode.getParent() instanceof CompilationUnit) {
                return true;
            }
            return !iTypeBinding.isMember() || !this.fAnalyzer.isDeclaredInScope((IBinding)iTypeBinding, simpleName, 20);
        }

        public void add(SimpleName simpleName) {
            char c;
            String string = simpleName.getIdentifier();
            if (this.fImportsAdded.contains(string)) {
                return;
            }
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding != null) {
                if (iBinding.getKind() != 2) {
                    return;
                }
                ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
                if (iTypeBinding.isArray()) {
                    iTypeBinding = iTypeBinding.getElementType();
                }
                if (!(iTypeBinding = iTypeBinding.getTypeDeclaration()).isRecovered()) {
                    if (this.needsImport(iTypeBinding, simpleName)) {
                        this.fImpStructure.addImport(iTypeBinding);
                        this.fImportsAdded.add(string);
                    }
                    return;
                }
            } else if (this.fDoIgnoreLowerCaseNames && string.length() > 0 && Strings.isLowerCase(c = string.charAt(0)) && Character.isLetter(c)) {
                return;
            }
            this.fImportsAdded.add(string);
            this.fUnresolvedTypes.put(string, new UnresolvedTypeData(simpleName));
        }

        /*
         * Unable to fully structure code
         */
        public boolean process(IProgressMonitor var1_1) throws JavaModelException {
            block8: {
                var2_2 = this.fUnresolvedTypes.size();
                if (var2_2 != 0) break block8;
                while (true) {
                    var15_3 = null;
                    var1_1.done();
                    return false;
                }
            }
            try {
                var3_6 = new char[var2_2][];
                var4_7 = 0;
                var5_8 = this.fUnresolvedTypes.keySet().iterator();
                while (var5_8.hasNext()) {
                    var3_6[var4_7++] = ((String)var5_8.next()).toCharArray();
                }
                var5_8 = new ArrayList<E>();
                var6_9 = this.fCurrPackage.getJavaProject();
                var7_10 = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{var6_9});
                var8_11 = new TypeNameMatchCollector((Collection)var5_8);
                new SearchEngine().searchAllTypeNames(null, (char[][])var3_6, var7_10, (TypeNameMatchRequestor)var8_11, 3, var1_1);
                var9_12 = JavaModelUtil.is50OrHigher(var6_9);
                var4_7 = 0;
                while (var4_7 < var5_8.size()) {
                    var10_13 = (TypeNameMatch)var5_8.get(var4_7);
                    var11_14 = (UnresolvedTypeData)this.fUnresolvedTypes.get(var10_13.getSimpleTypeName());
                    if (var11_14 != null && this.isVisible(var10_13) && this.isOfKind(var10_13, var11_14.typeKinds, var9_12) && (this.fAllowDefaultPackageImports || var10_13.getPackageName().length() > 0)) {
                        var11_14.addInfo(var10_13);
                    }
                    ++var4_7;
                }
                var10_13 = new ArrayList(var2_2);
                var11_14 = new ArrayList<E>(var2_2);
                var12_15 = this.fUnresolvedTypes.values().iterator();
                while (var12_15.hasNext()) {
                    var13_16 = (UnresolvedTypeData)var12_15.next();
                    var14_17 = this.processTypeInfo(var13_16.foundInfos);
                    if (var14_17 == null) continue;
                    var10_13.add(var14_17);
                    var11_14.add(new SourceRange(var13_16.ref.getStartPosition(), var13_16.ref.getLength()));
                }
                if (var10_13.isEmpty()) ** continue;
                this.fOpenChoices = (TypeNameMatch[][])var10_13.toArray((T[])new TypeNameMatch[var10_13.size()][]);
                this.fSourceRanges = var11_14.toArray(new SourceRange[var11_14.size()]);
                var15_4 = null;
            }
            catch (Throwable var16_18) {
                var15_5 = null;
                var1_1.done();
                throw var16_18;
            }
            var1_1.done();
            return true;
        }

        private TypeNameMatch[] processTypeInfo(List list) {
            int n = list.size();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                TypeNameMatch typeNameMatch = (TypeNameMatch)list.get(0);
                this.fImpStructure.addImport(typeNameMatch.getFullyQualifiedName());
                return null;
            }
            String string = null;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                TypeNameMatch typeNameMatch = (TypeNameMatch)list.get(n2);
                String string2 = typeNameMatch.getFullyQualifiedName();
                String string3 = typeNameMatch.getTypeContainerName();
                if (this.fOldSingleImports.contains(string2)) {
                    this.fImpStructure.addImport(string2);
                    return null;
                }
                if (this.fOldDemandImports.contains(string3) || this.fImplicitImports.contains(string3)) {
                    if (string == null) {
                        string = string2;
                    } else {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (string != null && !bl) {
                this.fImpStructure.addImport(string);
                return null;
            }
            return list.toArray(new TypeNameMatch[n]);
        }

        private boolean isOfKind(TypeNameMatch typeNameMatch, int n, boolean bl) {
            int n2 = typeNameMatch.getModifiers();
            if (Flags.isAnnotation((int)n2)) {
                return bl && (n & 8) != 0;
            }
            if (Flags.isEnum((int)n2)) {
                return bl && (n & 0x10) != 0;
            }
            if (Flags.isInterface((int)n2)) {
                return (n & 4) != 0;
            }
            return (n & 2) != 0;
        }

        private boolean isVisible(TypeNameMatch typeNameMatch) {
            int n = typeNameMatch.getModifiers();
            if (Flags.isPrivate((int)n)) {
                return false;
            }
            if (Flags.isPublic((int)n) || Flags.isProtected((int)n)) {
                return true;
            }
            return typeNameMatch.getPackageName().equals(this.fCurrPackage.getElementName());
        }

        public TypeNameMatch[][] getChoices() {
            return this.fOpenChoices;
        }

        public ISourceRange[] getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final SimpleName ref;
            final int typeKinds;
            final List foundInfos;

            public UnresolvedTypeData(SimpleName simpleName) {
                this.ref = simpleName;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)simpleName, true);
                this.foundInfos = new ArrayList(3);
            }

            public void addInfo(TypeNameMatch typeNameMatch) {
                int n = this.foundInfos.size() - 1;
                while (n >= 0) {
                    TypeNameMatch typeNameMatch2 = (TypeNameMatch)this.foundInfos.get(n);
                    if (typeNameMatch2.getTypeContainerName().equals(typeNameMatch.getTypeContainerName())) {
                        return;
                    }
                    --n;
                }
                this.foundInfos.add(typeNameMatch);
            }
        }
    }
}

