/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.util.CompilationUnitSorter;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class SortMembersOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private int[] fPositions;
    private final boolean fDoNotSortFields;

    public SortMembersOperation(ICompilationUnit iCompilationUnit, int[] nArray, boolean bl) {
        this.fCompilationUnit = iCompilationUnit;
        this.fPositions = nArray;
        this.fDoNotSortFields = bl;
    }

    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitSorter.sort((int)3, (ICompilationUnit)this.fCompilationUnit, (int[])this.fPositions, (Comparator)new DefaultJavaElementComparator(this.fDoNotSortFields), (int)0, (IProgressMonitor)iProgressMonitor);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static class DefaultJavaElementComparator
    implements Comparator {
        private final Collator fCollator;
        private final MembersOrderPreferenceCache fMemberOrderCache;
        private final boolean fDoNotSortFields;

        public DefaultJavaElementComparator(boolean bl) {
            this.fDoNotSortFields = bl;
            this.fCollator = Collator.getInstance();
            this.fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        }

        private int category(BodyDeclaration bodyDeclaration) {
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    if (methodDeclaration.isConstructor()) {
                        return this.getMemberCategory(1);
                    }
                    int n = methodDeclaration.getModifiers();
                    if (Modifier.isStatic((int)n)) {
                        return this.getMemberCategory(7);
                    }
                    return this.getMemberCategory(2);
                }
                case 23: {
                    int n = ((FieldDeclaration)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)n)) {
                        return this.getMemberCategory(5);
                    }
                    return this.getMemberCategory(3);
                }
                case 28: {
                    int n = ((Initializer)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)n)) {
                        return this.getMemberCategory(6);
                    }
                    return this.getMemberCategory(4);
                }
                case 55: 
                case 71: 
                case 81: {
                    return this.getMemberCategory(0);
                }
                case 72: {
                    return this.getMemberCategory(8);
                }
                case 82: {
                    return this.getMemberCategory(2);
                }
            }
            return 0;
        }

        private int getMemberCategory(int n) {
            return this.fMemberOrderCache.getCategoryIndex(n);
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            BodyDeclaration bodyDeclaration = (BodyDeclaration)object;
            BodyDeclaration bodyDeclaration2 = (BodyDeclaration)object2;
            int n3 = this.category(bodyDeclaration);
            if (n3 != (n2 = this.category(bodyDeclaration2))) {
                return n3 - n2;
            }
            if (this.fMemberOrderCache.isSortByVisibility()) {
                int n4 = JdtFlags.getVisibilityCode(bodyDeclaration);
                int n5 = JdtFlags.getVisibilityCode(bodyDeclaration2);
                n = this.fMemberOrderCache.getVisibilityIndex(n4) - this.fMemberOrderCache.getVisibilityIndex(n5);
                if (n != 0) {
                    return n;
                }
            }
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    String string;
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    MethodDeclaration methodDeclaration2 = (MethodDeclaration)bodyDeclaration2;
                    if (this.fMemberOrderCache.isSortByVisibility() && (n = this.fMemberOrderCache.getVisibilityIndex(methodDeclaration.getModifiers()) - this.fMemberOrderCache.getVisibilityIndex(methodDeclaration2.getModifiers())) != 0) {
                        return n;
                    }
                    String string2 = methodDeclaration.getName().getIdentifier();
                    int n6 = this.fCollator.compare(string2, string = methodDeclaration2.getName().getIdentifier());
                    if (n6 != 0) {
                        return n6;
                    }
                    List list = methodDeclaration.parameters();
                    List list2 = methodDeclaration2.parameters();
                    int n7 = list.size();
                    int n8 = list2.size();
                    int n9 = Math.min(n7, n8);
                    int n10 = 0;
                    while (n10 < n9) {
                        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)list.get(n10);
                        SingleVariableDeclaration singleVariableDeclaration2 = (SingleVariableDeclaration)list2.get(n10);
                        n6 = this.fCollator.compare(this.buildSignature(singleVariableDeclaration.getType()), this.buildSignature(singleVariableDeclaration2.getType()));
                        if (n6 != 0) {
                            return n6;
                        }
                        ++n10;
                    }
                    if (n7 != n8) {
                        return n7 - n8;
                    }
                    return this.preserveRelativeOrder(bodyDeclaration, bodyDeclaration2);
                }
                case 23: {
                    if (!this.fDoNotSortFields) {
                        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                        FieldDeclaration fieldDeclaration2 = (FieldDeclaration)bodyDeclaration2;
                        String string = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).getName().getIdentifier();
                        String string3 = ((VariableDeclarationFragment)fieldDeclaration2.fragments().get(0)).getName().getIdentifier();
                        return this.compareNames(bodyDeclaration, bodyDeclaration2, string, string3);
                    }
                    return this.preserveRelativeOrder(bodyDeclaration, bodyDeclaration2);
                }
                case 28: {
                    return this.preserveRelativeOrder(bodyDeclaration, bodyDeclaration2);
                }
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)bodyDeclaration;
                    AbstractTypeDeclaration abstractTypeDeclaration2 = (AbstractTypeDeclaration)bodyDeclaration2;
                    String string = abstractTypeDeclaration.getName().getIdentifier();
                    String string4 = abstractTypeDeclaration2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration, bodyDeclaration2, string, string4);
                }
                case 72: {
                    if (!this.fDoNotSortFields) {
                        EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
                        EnumConstantDeclaration enumConstantDeclaration2 = (EnumConstantDeclaration)bodyDeclaration2;
                        String string = enumConstantDeclaration.getName().getIdentifier();
                        String string5 = enumConstantDeclaration2.getName().getIdentifier();
                        return this.compareNames(bodyDeclaration, bodyDeclaration2, string, string5);
                    }
                    return this.preserveRelativeOrder(bodyDeclaration, bodyDeclaration2);
                }
                case 82: {
                    AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = (AnnotationTypeMemberDeclaration)bodyDeclaration;
                    AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration2 = (AnnotationTypeMemberDeclaration)bodyDeclaration2;
                    String string = annotationTypeMemberDeclaration.getName().getIdentifier();
                    String string6 = annotationTypeMemberDeclaration2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration, bodyDeclaration2, string, string6);
                }
            }
            return 0;
        }

        private int preserveRelativeOrder(BodyDeclaration bodyDeclaration, BodyDeclaration bodyDeclaration2) {
            int n = (Integer)bodyDeclaration.getProperty("relativeOrder");
            int n2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
            return n - n2;
        }

        private int compareNames(BodyDeclaration bodyDeclaration, BodyDeclaration bodyDeclaration2, String string, String string2) {
            int n = this.fCollator.compare(string, string2);
            if (n != 0) {
                return n;
            }
            return this.preserveRelativeOrder(bodyDeclaration, bodyDeclaration2);
        }

        private String buildSignature(Type type) {
            return ASTNodes.asString((ASTNode)type);
        }
    }
}

