/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;

public class ASTFlattener
extends GenericVisitor {
    protected StringBuffer fBuffer = new StringBuffer();

    public String getResult() {
        return this.fBuffer.toString();
    }

    public void reset() {
        this.fBuffer.setLength(0);
    }

    public static String asString(ASTNode aSTNode) {
        ASTFlattener aSTFlattener = new ASTFlattener();
        aSTNode.accept((ASTVisitor)aSTFlattener);
        return aSTFlattener.getResult();
    }

    protected boolean visitNode(ASTNode aSTNode) {
        Assert.isTrue((boolean)false, (String)("No implementation to flatten node: " + aSTNode.toString()));
        return false;
    }

    private void printModifiers(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            aSTNode.accept((ASTVisitor)this);
            this.fBuffer.append(" ");
        }
    }

    private void printModifiers(int n) {
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        if (annotationTypeDeclaration.getJavadoc() != null) {
            annotationTypeDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(annotationTypeDeclaration.modifiers());
        this.fBuffer.append("@interface ");
        annotationTypeDeclaration.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" {");
        Iterator iterator = annotationTypeDeclaration.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            bodyDeclaration.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        if (annotationTypeMemberDeclaration.getJavadoc() != null) {
            annotationTypeMemberDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(annotationTypeMemberDeclaration.modifiers());
        annotationTypeMemberDeclaration.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        annotationTypeMemberDeclaration.getName().accept((ASTVisitor)this);
        this.fBuffer.append("()");
        if (annotationTypeMemberDeclaration.getDefault() != null) {
            this.fBuffer.append(" default ");
            annotationTypeMemberDeclaration.getDefault().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.fBuffer.append("{");
        Iterator iterator = anonymousClassDeclaration.bodyDeclarations().iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            bodyDeclaration.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(ArrayAccess arrayAccess) {
        arrayAccess.getArray().accept((ASTVisitor)this);
        this.fBuffer.append("[");
        arrayAccess.getIndex().accept((ASTVisitor)this);
        this.fBuffer.append("]");
        return false;
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.fBuffer.append("new ");
        ArrayType arrayType = arrayCreation.getType();
        int n = arrayType.getDimensions();
        Type type = arrayType.getElementType();
        type.accept((ASTVisitor)this);
        Iterator iterator = arrayCreation.dimensions().iterator();
        while (iterator.hasNext()) {
            this.fBuffer.append("[");
            Expression expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            this.fBuffer.append("]");
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            this.fBuffer.append("[]");
            ++n2;
        }
        if (arrayCreation.getInitializer() != null) {
            arrayCreation.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.fBuffer.append("[");
        Iterator iterator = arrayInitializer.expressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append("]");
        return false;
    }

    public boolean visit(ArrayType arrayType) {
        arrayType.getComponentType().accept((ASTVisitor)this);
        this.fBuffer.append("[]");
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        this.fBuffer.append("assert ");
        assertStatement.getExpression().accept((ASTVisitor)this);
        if (assertStatement.getMessage() != null) {
            this.fBuffer.append(" : ");
            assertStatement.getMessage().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(Assignment assignment) {
        assignment.getLeftHandSide().accept((ASTVisitor)this);
        this.fBuffer.append(assignment.getOperator().toString());
        assignment.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Block block) {
        this.fBuffer.append("{");
        Iterator iterator = block.statements().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(BlockComment blockComment) {
        this.fBuffer.append("/* */");
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        if (booleanLiteral.booleanValue()) {
            this.fBuffer.append("true");
        } else {
            this.fBuffer.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement breakStatement) {
        this.fBuffer.append("break");
        if (breakStatement.getLabel() != null) {
            this.fBuffer.append(" ");
            breakStatement.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(CastExpression castExpression) {
        this.fBuffer.append("(");
        castExpression.getType().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        castExpression.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression) {
        functionExpression.getMethod().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ObjectLiteral objectLiteral) {
        this.fBuffer.append("{");
        Iterator iterator = objectLiteral.fields().iterator();
        while (iterator.hasNext()) {
            ObjectLiteralField objectLiteralField = (ObjectLiteralField)iterator.next();
            objectLiteralField.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(ObjectLiteralField objectLiteralField) {
        objectLiteralField.getFieldName().accept((ASTVisitor)this);
        this.fBuffer.append(" : ");
        objectLiteralField.getInitializer().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CatchClause catchClause) {
        this.fBuffer.append("catch (");
        catchClause.getException().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        catchClause.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.fBuffer.append(characterLiteral.getEscapedValue());
        return false;
    }

    public boolean visit(RegularExpressionLiteral regularExpressionLiteral) {
        this.fBuffer.append(regularExpressionLiteral.getRegularExpression());
        return false;
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (classInstanceCreation.getExpression() != null) {
            classInstanceCreation.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("new ");
        classInstanceCreation.getMember().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator iterator = classInstanceCreation.arguments().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        if (classInstanceCreation.getAnonymousClassDeclaration() != null) {
            classInstanceCreation.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CompilationUnit compilationUnit) {
        ImportDeclaration importDeclaration;
        if (compilationUnit.getPackage() != null) {
            compilationUnit.getPackage().accept((ASTVisitor)this);
        }
        Iterator iterator = compilationUnit.imports().iterator();
        while (iterator.hasNext()) {
            importDeclaration = (ImportDeclaration)iterator.next();
            importDeclaration.accept((ASTVisitor)this);
        }
        iterator = compilationUnit.types().iterator();
        while (iterator.hasNext()) {
            importDeclaration = (AbstractTypeDeclaration)iterator.next();
            importDeclaration.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append("?");
        conditionalExpression.getThenExpression().accept((ASTVisitor)this);
        this.fBuffer.append(":");
        conditionalExpression.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        Expression expression;
        Iterator iterator;
        if (constructorInvocation.getAST().apiLevel() >= 3 && !constructorInvocation.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            iterator = constructorInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                expression = (Type)iterator.next();
                expression.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("this(");
        iterator = constructorInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    public boolean visit(ContinueStatement continueStatement) {
        this.fBuffer.append("continue");
        if (continueStatement.getLabel() != null) {
            this.fBuffer.append(" ");
            continueStatement.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(DoStatement doStatement) {
        this.fBuffer.append("do ");
        doStatement.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" while (");
        doStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(");");
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.fBuffer.append("for (");
        enhancedForStatement.getParameter().accept((ASTVisitor)this);
        this.fBuffer.append(" : ");
        enhancedForStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        enhancedForStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        if (enumConstantDeclaration.getJavadoc() != null) {
            enumConstantDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(enumConstantDeclaration.modifiers());
        enumConstantDeclaration.getName().accept((ASTVisitor)this);
        if (!enumConstantDeclaration.arguments().isEmpty()) {
            this.fBuffer.append("(");
            Iterator iterator = enumConstantDeclaration.arguments().iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                expression.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(")");
        }
        if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
            enumConstantDeclaration.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        Type type;
        Iterator iterator;
        if (enumDeclaration.getJavadoc() != null) {
            enumDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(enumDeclaration.modifiers());
        this.fBuffer.append("enum ");
        enumDeclaration.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        if (!enumDeclaration.superInterfaceTypes().isEmpty()) {
            this.fBuffer.append("implements ");
            iterator = enumDeclaration.superInterfaceTypes().iterator();
            while (iterator.hasNext()) {
                type = (Type)iterator.next();
                type.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        this.fBuffer.append("{");
        iterator = enumDeclaration.enumConstants().iterator();
        while (iterator.hasNext()) {
            type = (EnumConstantDeclaration)iterator.next();
            type.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        if (!enumDeclaration.bodyDeclarations().isEmpty()) {
            this.fBuffer.append("; ");
            iterator = enumDeclaration.bodyDeclarations().iterator();
            while (iterator.hasNext()) {
                type = (BodyDeclaration)iterator.next();
                type.accept((ASTVisitor)this);
            }
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        expressionStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        fieldAccess.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        fieldAccess.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.getJavadoc() != null) {
            fieldDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        if (fieldDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(fieldDeclaration.getModifiers());
        }
        if (fieldDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(fieldDeclaration.modifiers());
        }
        fieldDeclaration.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        Expression expression;
        this.fBuffer.append("for (");
        Iterator iterator = forStatement.initializers().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        if (forStatement.getExpression() != null) {
            forStatement.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        iterator = forStatement.updaters().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        forStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ForInStatement forInStatement) {
        this.fBuffer.append("for (");
        if (forInStatement.getIterationVariable() != null) {
            forInStatement.getIterationVariable().accept((ASTVisitor)this);
        }
        this.fBuffer.append(" in ");
        if (forInStatement.getCollection() != null) {
            forInStatement.getCollection().accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        forInStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement ifStatement) {
        this.fBuffer.append("if (");
        ifStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        ifStatement.getThenStatement().accept((ASTVisitor)this);
        if (ifStatement.getElseStatement() != null) {
            this.fBuffer.append(" else ");
            ifStatement.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        this.fBuffer.append("import ");
        if (importDeclaration.getAST().apiLevel() >= 3 && importDeclaration.isStatic()) {
            this.fBuffer.append("static ");
        }
        importDeclaration.getName().accept((ASTVisitor)this);
        if (importDeclaration.isOnDemand()) {
            this.fBuffer.append(".*");
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        infixExpression.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(' ');
        this.fBuffer.append(infixExpression.getOperator().toString());
        this.fBuffer.append(' ');
        infixExpression.getRightOperand().accept((ASTVisitor)this);
        List list = infixExpression.extendedOperands();
        if (list.size() != 0) {
            this.fBuffer.append(' ');
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.fBuffer.append(infixExpression.getOperator().toString()).append(' ');
                Expression expression = (Expression)iterator.next();
                expression.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        instanceofExpression.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(" instanceof ");
        instanceofExpression.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Initializer initializer) {
        if (initializer.getJavadoc() != null) {
            initializer.getJavadoc().accept((ASTVisitor)this);
        }
        if (initializer.getAST().apiLevel() == 2) {
            this.printModifiers(initializer.getModifiers());
        }
        if (initializer.getAST().apiLevel() >= 3) {
            this.printModifiers(initializer.modifiers());
        }
        initializer.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Javadoc javadoc) {
        this.fBuffer.append("/** ");
        Iterator iterator = javadoc.tags().iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            aSTNode.accept((ASTVisitor)this);
        }
        this.fBuffer.append("\n */");
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        labeledStatement.getLabel().accept((ASTVisitor)this);
        this.fBuffer.append(": ");
        labeledStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ListExpression listExpression) {
        Iterator iterator = listExpression.expressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        return false;
    }

    public boolean visit(LineComment lineComment) {
        this.fBuffer.append("//\n");
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        this.fBuffer.append("@");
        markerAnnotation.getTypeName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        if (memberRef.getQualifier() != null) {
            memberRef.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        memberRef.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MemberValuePair memberValuePair) {
        memberValuePair.getName().accept((ASTVisitor)this);
        this.fBuffer.append("=");
        memberValuePair.getValue().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        if (methodRef.getQualifier() != null) {
            methodRef.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        methodRef.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator iterator = methodRef.parameters().iterator();
        while (iterator.hasNext()) {
            MethodRefParameter methodRefParameter = (MethodRefParameter)iterator.next();
            methodRefParameter.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        methodRefParameter.getType().accept((ASTVisitor)this);
        if (methodRefParameter.getAST().apiLevel() >= 3 && methodRefParameter.isVarargs()) {
            this.fBuffer.append("...");
        }
        if (methodRefParameter.getName() != null) {
            this.fBuffer.append(" ");
            methodRefParameter.getName().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        SingleVariableDeclaration singleVariableDeclaration;
        Iterator iterator;
        if (methodDeclaration.getJavadoc() != null) {
            methodDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        if (methodDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(methodDeclaration.getModifiers());
        }
        if (methodDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(methodDeclaration.modifiers());
            if (!methodDeclaration.typeParameters().isEmpty()) {
                this.fBuffer.append("<");
                iterator = methodDeclaration.typeParameters().iterator();
                while (iterator.hasNext()) {
                    singleVariableDeclaration = (TypeParameter)iterator.next();
                    singleVariableDeclaration.accept((ASTVisitor)this);
                    if (!iterator.hasNext()) continue;
                    this.fBuffer.append(",");
                }
                this.fBuffer.append("> ");
            }
        }
        if (methodDeclaration.getName() != null) {
            methodDeclaration.getName().accept((ASTVisitor)this);
        }
        this.fBuffer.append("(");
        iterator = methodDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
            singleVariableDeclaration.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        int n = 0;
        while (n < methodDeclaration.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++n;
        }
        if (!methodDeclaration.thrownExceptions().isEmpty()) {
            this.fBuffer.append(" throws ");
            Iterator iterator2 = methodDeclaration.thrownExceptions().iterator();
            while (iterator2.hasNext()) {
                singleVariableDeclaration = (Name)iterator2.next();
                singleVariableDeclaration.accept((ASTVisitor)this);
                if (!iterator2.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        if (methodDeclaration.getBody() == null) {
            this.fBuffer.append(";");
        } else {
            methodDeclaration.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        Type type;
        Object object;
        if (methodInvocation.getExpression() != null) {
            methodInvocation.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (methodInvocation.getAST().apiLevel() >= 3 && !methodInvocation.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            object = methodInvocation.typeArguments().iterator();
            while (object.hasNext()) {
                type = (Type)object.next();
                type.accept((ASTVisitor)this);
                if (!object.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        if ((object = methodInvocation.getName()) != null) {
            object.accept((ASTVisitor)this);
        }
        this.fBuffer.append("(");
        type = methodInvocation.arguments().iterator();
        while (type.hasNext()) {
            Expression expression = (Expression)type.next();
            expression.accept((ASTVisitor)this);
            if (!type.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(Modifier modifier) {
        this.fBuffer.append(modifier.getKeyword().toString());
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        this.fBuffer.append("@");
        normalAnnotation.getTypeName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator iterator = normalAnnotation.values().iterator();
        while (iterator.hasNext()) {
            MemberValuePair memberValuePair = (MemberValuePair)iterator.next();
            memberValuePair.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(NullLiteral nullLiteral) {
        this.fBuffer.append("null");
        return false;
    }

    public boolean visit(UndefinedLiteral undefinedLiteral) {
        this.fBuffer.append("undefined");
        return false;
    }

    public boolean visit(NumberLiteral numberLiteral) {
        this.fBuffer.append(numberLiteral.getToken());
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (packageDeclaration.getAST().apiLevel() >= 3) {
            if (packageDeclaration.getJavadoc() != null) {
                packageDeclaration.getJavadoc().accept((ASTVisitor)this);
            }
            Iterator iterator = packageDeclaration.annotations().iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                annotation.accept((ASTVisitor)this);
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append("package ");
        packageDeclaration.getName().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        parameterizedType.getType().accept((ASTVisitor)this);
        this.fBuffer.append("<");
        Iterator iterator = parameterizedType.typeArguments().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            type.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(">");
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        this.fBuffer.append("(");
        parenthesizedExpression.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression) {
        postfixExpression.getOperand().accept((ASTVisitor)this);
        this.fBuffer.append(postfixExpression.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.fBuffer.append(prefixExpression.getOperator().toString());
        prefixExpression.getOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.fBuffer.append(primitiveType.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        qualifiedName.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        qualifiedName.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        qualifiedType.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        qualifiedType.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.fBuffer.append("return");
        if (returnStatement.getExpression() != null) {
            this.fBuffer.append(" ");
            returnStatement.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        this.fBuffer.append(simpleName.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        return true;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        this.fBuffer.append("@");
        singleMemberAnnotation.getTypeName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        singleMemberAnnotation.getValue().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        if (singleVariableDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(singleVariableDeclaration.getModifiers());
        }
        if (singleVariableDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(singleVariableDeclaration.modifiers());
        }
        if (singleVariableDeclaration.getAST().apiLevel() >= 3 && singleVariableDeclaration.isVarargs()) {
            this.fBuffer.append("...");
        }
        this.fBuffer.append(" ");
        singleVariableDeclaration.getName().accept((ASTVisitor)this);
        int n = 0;
        while (n < singleVariableDeclaration.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++n;
        }
        if (singleVariableDeclaration.getInitializer() != null) {
            this.fBuffer.append("=");
            singleVariableDeclaration.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.fBuffer.append(stringLiteral.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        Expression expression;
        Iterator iterator;
        if (superConstructorInvocation.getExpression() != null) {
            superConstructorInvocation.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (superConstructorInvocation.getAST().apiLevel() >= 3 && !superConstructorInvocation.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            iterator = superConstructorInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                expression = (Type)iterator.next();
                expression.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("super(");
        iterator = superConstructorInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            expression.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        if (superFieldAccess.getQualifier() != null) {
            superFieldAccess.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        superFieldAccess.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        Type type;
        Iterator iterator;
        if (superMethodInvocation.getQualifier() != null) {
            superMethodInvocation.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        if (superMethodInvocation.getAST().apiLevel() >= 3 && !superMethodInvocation.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            iterator = superMethodInvocation.typeArguments().iterator();
            while (iterator.hasNext()) {
                type = (Type)iterator.next();
                type.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        superMethodInvocation.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        iterator = superMethodInvocation.arguments().iterator();
        while (iterator.hasNext()) {
            type = (Expression)iterator.next();
            type.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.fBuffer.append("default :");
        } else {
            this.fBuffer.append("case ");
            switchCase.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(":");
        }
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.fBuffer.append("switch (");
        switchStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        this.fBuffer.append("{");
        Iterator iterator = switchStatement.statements().iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            statement.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.fBuffer.append("synchronized (");
        synchronizedStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        synchronizedStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(TagElement tagElement) {
        if (tagElement.isNested()) {
            this.fBuffer.append("{");
        } else {
            this.fBuffer.append("\n * ");
        }
        boolean bl = false;
        if (tagElement.getTagName() != null) {
            this.fBuffer.append(tagElement.getTagName());
            bl = true;
        }
        boolean bl2 = false;
        Iterator iterator = tagElement.fragments().iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            boolean bl3 = aSTNode instanceof TextElement;
            if (bl2 && bl3) {
                this.fBuffer.append("\n * ");
            }
            bl2 = bl3;
            if (bl && !bl3) {
                this.fBuffer.append(" ");
            }
            aSTNode.accept((ASTVisitor)this);
            boolean bl4 = bl = !bl3 && !(aSTNode instanceof TagElement);
        }
        if (tagElement.isNested()) {
            this.fBuffer.append("}");
        }
        return false;
    }

    public boolean visit(TextElement textElement) {
        this.fBuffer.append(textElement.getText());
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        if (thisExpression.getQualifier() != null) {
            thisExpression.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("this");
        return false;
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.fBuffer.append("throw ");
        throwStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        this.fBuffer.append("try ");
        tryStatement.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator iterator = tryStatement.catchClauses().iterator();
        while (iterator.hasNext()) {
            CatchClause catchClause = (CatchClause)iterator.next();
            catchClause.accept((ASTVisitor)this);
        }
        if (tryStatement.getFinally() != null) {
            this.fBuffer.append("finally ");
            tryStatement.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        Object object;
        Iterator iterator;
        if (typeDeclaration.getJavadoc() != null) {
            typeDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        if (typeDeclaration.getAST().apiLevel() == 2) {
            this.printModifiers(typeDeclaration.getModifiers());
        }
        if (typeDeclaration.getAST().apiLevel() >= 3) {
            this.printModifiers(typeDeclaration.modifiers());
        }
        this.fBuffer.append(typeDeclaration.isInterface() ? "interface " : "class ");
        typeDeclaration.getName().accept((ASTVisitor)this);
        if (typeDeclaration.getAST().apiLevel() >= 3 && !typeDeclaration.typeParameters().isEmpty()) {
            this.fBuffer.append("<");
            iterator = typeDeclaration.typeParameters().iterator();
            while (iterator.hasNext()) {
                object = (TypeParameter)iterator.next();
                object.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append(" ");
        if (typeDeclaration.getAST().apiLevel() == 2) {
            if (typeDeclaration.getSuperclass() != null) {
                this.fBuffer.append("extends ");
                typeDeclaration.getSuperclass().accept((ASTVisitor)this);
                this.fBuffer.append(" ");
            }
            if (!typeDeclaration.superInterfaces().isEmpty()) {
                this.fBuffer.append(typeDeclaration.isInterface() ? "extends " : "implements ");
                iterator = typeDeclaration.superInterfaces().iterator();
                while (iterator.hasNext()) {
                    object = (Name)iterator.next();
                    object.accept((ASTVisitor)this);
                    if (!iterator.hasNext()) continue;
                    this.fBuffer.append(", ");
                }
                this.fBuffer.append(" ");
            }
        }
        if (typeDeclaration.getAST().apiLevel() >= 3) {
            if (typeDeclaration.getSuperclassType() != null) {
                this.fBuffer.append("extends ");
                typeDeclaration.getSuperclassType().accept((ASTVisitor)this);
                this.fBuffer.append(" ");
            }
            if (!typeDeclaration.superInterfaceTypes().isEmpty()) {
                this.fBuffer.append(typeDeclaration.isInterface() ? "extends " : "implements ");
                iterator = typeDeclaration.superInterfaceTypes().iterator();
                while (iterator.hasNext()) {
                    object = (Type)iterator.next();
                    object.accept((ASTVisitor)this);
                    if (!iterator.hasNext()) continue;
                    this.fBuffer.append(", ");
                }
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append("{");
        iterator = null;
        object = typeDeclaration.bodyDeclarations().iterator();
        while (object.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)object.next();
            if (iterator instanceof EnumConstantDeclaration) {
                if (bodyDeclaration instanceof EnumConstantDeclaration) {
                    this.fBuffer.append(", ");
                } else {
                    this.fBuffer.append("; ");
                }
            }
            bodyDeclaration.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        if (typeDeclarationStatement.getAST().apiLevel() == 2) {
            typeDeclarationStatement.getTypeDeclaration().accept((ASTVisitor)this);
        }
        if (typeDeclarationStatement.getAST().apiLevel() >= 3) {
            typeDeclarationStatement.getDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        typeLiteral.getType().accept((ASTVisitor)this);
        this.fBuffer.append(".class");
        return false;
    }

    public boolean visit(TypeParameter typeParameter) {
        typeParameter.getName().accept((ASTVisitor)this);
        if (!typeParameter.typeBounds().isEmpty()) {
            this.fBuffer.append(" extends ");
            Iterator iterator = typeParameter.typeBounds().iterator();
            while (iterator.hasNext()) {
                Type type = (Type)iterator.next();
                type.accept((ASTVisitor)this);
                if (!iterator.hasNext()) continue;
                this.fBuffer.append(" & ");
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        if (variableDeclarationExpression.getAST().apiLevel() == 2) {
            this.printModifiers(variableDeclarationExpression.getModifiers());
        }
        if (variableDeclarationExpression.getAST().apiLevel() >= 3) {
            this.printModifiers(variableDeclarationExpression.modifiers());
        }
        this.fBuffer.append(" ");
        Iterator iterator = variableDeclarationExpression.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        variableDeclarationFragment.getName().accept((ASTVisitor)this);
        int n = 0;
        while (n < variableDeclarationFragment.getExtraDimensions()) {
            this.fBuffer.append("[]");
            ++n;
        }
        if (variableDeclarationFragment.getInitializer() != null) {
            this.fBuffer.append("=");
            variableDeclarationFragment.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        if (variableDeclarationStatement.getAST().apiLevel() == 2) {
            this.printModifiers(variableDeclarationStatement.getModifiers());
        }
        if (variableDeclarationStatement.getAST().apiLevel() >= 3) {
            this.printModifiers(variableDeclarationStatement.modifiers());
        }
        variableDeclarationStatement.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator iterator = variableDeclarationStatement.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            variableDeclarationFragment.accept((ASTVisitor)this);
            if (!iterator.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(WildcardType wildcardType) {
        this.fBuffer.append("?");
        Type type = wildcardType.getBound();
        if (type != null) {
            if (wildcardType.isUpperBound()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" super ");
            }
            type.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        this.fBuffer.append("while (");
        whileStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        whileStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(WithStatement withStatement) {
        this.fBuffer.append("with (");
        withStatement.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        withStatement.getBody().accept((ASTVisitor)this);
        return false;
    }
}

