/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";

    private Bindings() {
    }

    public static boolean equals(IBinding iBinding, IBinding iBinding2) {
        return iBinding.isEqualTo(iBinding2);
    }

    public static boolean equals(IBinding[] iBindingArray, IBinding[] iBindingArray2) {
        Assert.isNotNull((Object)iBindingArray);
        if (iBindingArray == iBindingArray2) {
            return true;
        }
        if (iBindingArray2 == null) {
            return false;
        }
        if (iBindingArray.length != iBindingArray2.length) {
            return false;
        }
        int n = 0;
        while (n < iBindingArray.length) {
            if (!Bindings.equals(iBindingArray[n], iBindingArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int hashCode(IBinding iBinding) {
        Assert.isNotNull((Object)iBinding);
        String string = iBinding.getKey();
        if (string == null) {
            return iBinding.hashCode();
        }
        return string.hashCode();
    }

    public static String asString(IBinding iBinding) {
        if (iBinding instanceof IMethodBinding) {
            return Bindings.asString((IMethodBinding)iBinding);
        }
        if (iBinding instanceof ITypeBinding) {
            return ((ITypeBinding)iBinding).getQualifiedName();
        }
        if (iBinding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)iBinding);
        }
        return iBinding.toString();
    }

    private static String asString(IVariableBinding iVariableBinding) {
        if (!iVariableBinding.isField()) {
            return iVariableBinding.toString();
        }
        if (iVariableBinding.getDeclaringClass() == null) {
            Assert.isTrue((boolean)iVariableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iVariableBinding.getDeclaringClass().getName());
        stringBuffer.append(':');
        stringBuffer.append(iVariableBinding.getName());
        return stringBuffer.toString();
    }

    private static String asString(IMethodBinding iMethodBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iMethodBinding.getDeclaringClass().getName());
        stringBuffer.append(':');
        stringBuffer.append(iMethodBinding.getName());
        stringBuffer.append('(');
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        int n = iTypeBindingArray.length - 1;
        int n2 = 0;
        while (n2 < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n2];
            stringBuffer.append(iTypeBinding.getName());
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding iTypeBinding) {
        ArrayList arrayList = new ArrayList(5);
        Bindings.createName(iTypeBinding, false, arrayList);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < arrayList.size()) {
            if (n > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append((String)arrayList.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getQualifiedName();
        int n = string.indexOf(60);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getImportName(IBinding iBinding) {
        ITypeBinding iTypeBinding = null;
        switch (iBinding.getKind()) {
            case 2: {
                return Bindings.getRawQualifiedName((ITypeBinding)iBinding);
            }
            case 1: {
                return String.valueOf(iBinding.getName()) + ".*";
            }
            case 4: {
                iTypeBinding = ((IMethodBinding)iBinding).getDeclaringClass();
                break;
            }
            case 3: {
                iTypeBinding = ((IVariableBinding)iBinding).getDeclaringClass();
                if (iTypeBinding != null) break;
                return iBinding.getName();
            }
            default: {
                return iBinding.getName();
            }
        }
        return JavaModelUtil.concatenateName(Bindings.getRawQualifiedName(iTypeBinding), iBinding.getName());
    }

    private static void createName(ITypeBinding iTypeBinding, boolean bl, List list) {
        ITypeBinding iTypeBinding2 = iTypeBinding;
        if (iTypeBinding.isArray()) {
            iTypeBinding2 = iTypeBinding.getElementType();
        }
        if (!iTypeBinding2.isPrimitive() && !iTypeBinding2.isNullType()) {
            ITypeBinding iTypeBinding3 = iTypeBinding2.getDeclaringClass();
            if (iTypeBinding3 != null) {
                Bindings.createName(iTypeBinding3, bl, list);
            } else if (bl && !iTypeBinding2.getPackage().isUnnamed()) {
                String[] stringArray = iTypeBinding2.getPackage().getNameComponents();
                int n = 0;
                while (n < stringArray.length) {
                    list.add(stringArray[n]);
                    ++n;
                }
            }
        }
        if (!iTypeBinding2.isAnonymous()) {
            list.add(iTypeBinding.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String[] getNameComponents(ITypeBinding iTypeBinding) {
        ArrayList arrayList = new ArrayList(5);
        Bindings.createName(iTypeBinding, false, arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding iTypeBinding) {
        ArrayList arrayList = new ArrayList(5);
        Bindings.createName(iTypeBinding, true, arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        while (iTypeBinding2 != null) {
            iTypeBinding = iTypeBinding2;
            iTypeBinding2 = iTypeBinding.getDeclaringClass();
        }
        return iTypeBinding;
    }

    public static boolean isRuntimeException(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null || iTypeBinding.isPrimitive() || iTypeBinding.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(iTypeBinding, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding iTypeBinding, String string) {
        if (iTypeBinding.isPrimitive()) {
            return null;
        }
        IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray[n];
            if (iVariableBinding.getName().equals(string)) {
                return iVariableBinding;
            }
            ++n;
        }
        return null;
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding iTypeBinding, String string) {
        IVariableBinding iVariableBinding = Bindings.findFieldInType(iTypeBinding, string);
        if (iVariableBinding != null) {
            return iVariableBinding;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iVariableBinding = Bindings.findFieldInHierarchy(iTypeBinding2, string)) != null) {
            return iVariableBinding;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            iVariableBinding = Bindings.findFieldInHierarchy(iTypeBindingArray[n], string);
            if (iVariableBinding != null) {
                return iVariableBinding;
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        if (iTypeBinding.isPrimitive()) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (iTypeBindingArray == null ? string.equals(iMethodBindingArray[n].getName()) : Bindings.isEqualMethod(iMethodBindingArray[n], string, iTypeBindingArray)) {
                return iMethodBindingArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        if (iTypeBinding == null) {
            return null;
        }
        IMethodBinding iMethodBinding = Bindings.findMethodInType(iTypeBinding, string, iTypeBindingArray);
        if (iMethodBinding != null) {
            return iMethodBinding;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iMethodBinding = Bindings.findMethodInHierarchy(iTypeBinding2, string, iTypeBindingArray)) != null) {
            return iMethodBinding;
        }
        ITypeBinding[] iTypeBindingArray2 = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray2.length) {
            iMethodBinding = Bindings.findMethodInHierarchy(iTypeBindingArray2[n], string, iTypeBindingArray);
            if (iMethodBinding != null) {
                return iMethodBinding;
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findMethodInType(ITypeBinding iTypeBinding, String string, String[] stringArray) {
        if (iTypeBinding.isPrimitive()) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (stringArray == null ? string.equals(iMethodBindingArray[n].getName()) : Bindings.isEqualMethod(iMethodBindingArray[n], string, stringArray)) {
                return iMethodBindingArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding iTypeBinding, String string, String[] stringArray) {
        IMethodBinding iMethodBinding = Bindings.findMethodInType(iTypeBinding, string, stringArray);
        if (iMethodBinding != null) {
            return iMethodBinding;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iMethodBinding = Bindings.findMethodInHierarchy(iTypeBinding2, string, stringArray)) != null) {
            return iMethodBinding;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            iMethodBinding = Bindings.findMethodInHierarchy(iTypeBindingArray[n], string, stringArray);
            if (iMethodBinding != null) {
                return iMethodBinding;
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInType(ITypeBinding iTypeBinding, IMethodBinding iMethodBinding) {
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (Bindings.isSubsignature(iMethodBinding, iMethodBindingArray[n])) {
                return iMethodBindingArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethodInHierarchy(ITypeBinding iTypeBinding, IMethodBinding iMethodBinding) {
        IMethodBinding iMethodBinding2 = Bindings.findOverriddenMethodInType(iTypeBinding, iMethodBinding);
        if (iMethodBinding2 != null) {
            return iMethodBinding2;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iMethodBinding2 = Bindings.findOverriddenMethodInHierarchy(iTypeBinding2, iMethodBinding)) != null) {
            return iMethodBinding2;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            iMethodBinding2 = Bindings.findOverriddenMethodInHierarchy(iTypeBindingArray[n], iMethodBinding);
            if (iMethodBinding2 != null) {
                return iMethodBinding2;
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findOverriddenMethod(IMethodBinding iMethodBinding, boolean bl) {
        IMethodBinding iMethodBinding2;
        int n = iMethodBinding.getModifiers();
        if (Modifier.isPrivate((int)n) || Modifier.isStatic((int)n) || iMethodBinding.isConstructor()) {
            return null;
        }
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (!(iTypeBinding.getSuperclass() == null || (iMethodBinding2 = Bindings.findOverriddenMethodInHierarchy(iTypeBinding.getSuperclass(), iMethodBinding)) == null || Modifier.isPrivate((int)iMethodBinding2.getModifiers()) || bl && !Bindings.isVisibleInHierarchy(iMethodBinding2, iMethodBinding.getDeclaringClass().getPackage()))) {
            return iMethodBinding2;
        }
        iMethodBinding2 = iTypeBinding.getInterfaces();
        int n2 = 0;
        while (n2 < ((IMethodBinding)iMethodBinding2).length) {
            IMethodBinding iMethodBinding3 = Bindings.findOverriddenMethodInHierarchy((ITypeBinding)iMethodBinding2[n2], iMethodBinding);
            if (iMethodBinding3 != null) {
                return iMethodBinding3;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IMethodBinding iMethodBinding, IPackageBinding iPackageBinding) {
        int n = iMethodBinding.getModifiers();
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (Modifier.isPublic((int)n) || Modifier.isProtected((int)n) || iTypeBinding != null && iTypeBinding.isInterface()) {
            return true;
        }
        if (Modifier.isPrivate((int)n)) {
            return false;
        }
        return iTypeBinding != null && iPackageBinding == iTypeBinding.getPackage();
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding iTypeBinding) {
        HashSet hashSet = new HashSet();
        Bindings.collectSuperTypes(iTypeBinding, hashSet);
        hashSet.remove(iTypeBinding);
        return hashSet.toArray(new ITypeBinding[hashSet.size()]);
    }

    private static void collectSuperTypes(ITypeBinding iTypeBinding, Set set) {
        if (set.add(iTypeBinding)) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                Bindings.collectSuperTypes(iTypeBindingArray[n], set);
                ++n;
            }
            ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
            if (iTypeBinding2 != null) {
                Bindings.collectSuperTypes(iTypeBinding2, set);
            }
        }
    }

    public static boolean visitHierarchy(ITypeBinding iTypeBinding, TypeBindingVisitor typeBindingVisitor) {
        boolean bl = Bindings.visitSuperclasses(iTypeBinding, typeBindingVisitor);
        if (bl) {
            bl = Bindings.visitInterfaces(iTypeBinding, typeBindingVisitor);
        }
        return bl;
    }

    public static boolean visitInterfaces(ITypeBinding iTypeBinding, TypeBindingVisitor typeBindingVisitor) {
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!typeBindingVisitor.visit(iTypeBindingArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean visitSuperclasses(ITypeBinding iTypeBinding, TypeBindingVisitor typeBindingVisitor) {
        while ((iTypeBinding = iTypeBinding.getSuperclass()) != null) {
            if (typeBindingVisitor.visit(iTypeBinding)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMethod(IMethodBinding iMethodBinding, String string, ITypeBinding[] iTypeBindingArray) {
        if (!iMethodBinding.getName().equals(string)) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray2.length != iTypeBindingArray.length) {
            return false;
        }
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (!Bindings.equals((IBinding)iTypeBindingArray2[n].getErasure(), (IBinding)iTypeBindingArray[n].getErasure())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isSubsignature(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        ITypeBinding[] iTypeBindingArray;
        ITypeBinding[] iTypeBindingArray2;
        if (!iMethodBinding.getName().equals(iMethodBinding2.getName())) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray3 = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray3.length != (iTypeBindingArray2 = iMethodBinding2.getParameterTypes()).length) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray4 = iMethodBinding.getTypeParameters();
        if (iTypeBindingArray4.length != (iTypeBindingArray = iMethodBinding2.getTypeParameters()).length && iTypeBindingArray4.length != 0) {
            return false;
        }
        if (iTypeBindingArray.length != 0) {
            Set set;
            int n = 0;
            while (n < iTypeBindingArray4.length) {
                Set set2;
                set = Bindings.getTypeBoundsForSubsignature(iTypeBindingArray4[n]);
                if (!set.equals(set2 = Bindings.getTypeBoundsForSubsignature(iTypeBindingArray[n]))) {
                    return false;
                }
                ++n;
            }
            if (Bindings.equals((IBinding[])iTypeBindingArray2, (IBinding[])iTypeBindingArray3)) {
                return true;
            }
            n = 0;
            while (n < iTypeBindingArray3.length) {
                set = iTypeBindingArray3[n];
                if (Bindings.containsTypeVariables((ITypeBinding)set)) {
                    set = set.getErasure();
                } else if (set.isRawType()) {
                    set = set.getTypeDeclaration();
                }
                if (!Bindings.equals((IBinding)set, (IBinding)iTypeBindingArray2[n].getErasure())) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (Bindings.equals((IBinding[])iTypeBindingArray3, (IBinding[])iTypeBindingArray2)) {
            return true;
        }
        int n = 0;
        while (n < iTypeBindingArray3.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray3[n];
            if (iTypeBinding.isRawType()) {
                iTypeBinding = iTypeBinding.getTypeDeclaration();
            }
            if (!Bindings.equals((IBinding)iTypeBinding, (IBinding)iTypeBindingArray2[n].getErasure())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean containsTypeVariables(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isTypeVariable()) {
            return true;
        }
        if (iTypeBinding.isArray()) {
            return Bindings.containsTypeVariables(iTypeBinding.getElementType());
        }
        if (iTypeBinding.isCapture()) {
            return Bindings.containsTypeVariables(iTypeBinding.getWildcard());
        }
        if (iTypeBinding.isParameterizedType()) {
            return Bindings.containsTypeVariables(iTypeBinding.getTypeArguments());
        }
        if (iTypeBinding.isTypeVariable()) {
            return Bindings.containsTypeVariables(iTypeBinding.getTypeBounds());
        }
        if (iTypeBinding.isWildcardType() && iTypeBinding.getBound() != null) {
            return Bindings.containsTypeVariables(iTypeBinding.getBound());
        }
        return false;
    }

    private static boolean containsTypeVariables(ITypeBinding[] iTypeBindingArray) {
        int n = 0;
        while (n < iTypeBindingArray.length) {
            if (Bindings.containsTypeVariables(iTypeBindingArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Set getTypeBoundsForSubsignature(ITypeBinding iTypeBinding) {
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeBounds();
        int n = iTypeBindingArray.length;
        if (n == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>(iTypeBindingArray.length);
        int n2 = 0;
        while (n2 < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding2 = iTypeBindingArray[n2];
            if (!"java.lang.Object".equals(iTypeBindingArray[0].getQualifiedName())) {
                if (Bindings.containsTypeVariables(iTypeBinding2)) {
                    hashSet.add(iTypeBinding2.getErasure());
                } else if (iTypeBinding2.isRawType()) {
                    hashSet.add(iTypeBinding2.getTypeDeclaration());
                } else {
                    hashSet.add(iTypeBinding2);
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static boolean isEqualMethod(IMethodBinding iMethodBinding, String string, String[] stringArray) {
        if (!iMethodBinding.getName().equals(string)) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray.length != stringArray.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            String string3 = stringArray[n];
            int n2 = string3.indexOf(60);
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            if ((n2 = (string2 = iTypeBindingArray[n].getErasure().getQualifiedName()).indexOf(60)) > 0) {
                string2 = string2.substring(0, n2);
            }
            if (!string3.equals(string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding iTypeBinding, String string) {
        ITypeBinding iTypeBinding2;
        if (iTypeBinding.isArray() || iTypeBinding.isPrimitive()) {
            return null;
        }
        if (string.equals(iTypeBinding.getQualifiedName())) {
            return iTypeBinding;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (iTypeBinding3 != null && (iTypeBinding2 = Bindings.findTypeInHierarchy(iTypeBinding3, string)) != null) {
            return iTypeBinding2;
        }
        iTypeBinding2 = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < ((ITypeBinding)iTypeBinding2).length) {
            ITypeBinding iTypeBinding4 = Bindings.findTypeInHierarchy(iTypeBinding2[n], string);
            if (iTypeBinding4 != null) {
                return iTypeBinding4;
            }
            ++n;
        }
        return null;
    }

    public static IVariableBinding getAssignedVariable(Assignment assignment) {
        Expression expression = assignment.getLeftHandSide();
        switch (expression.getNodeType()) {
            case 42: {
                return (IVariableBinding)((SimpleName)expression).resolveBinding();
            }
            case 40: {
                return (IVariableBinding)((QualifiedName)expression).getName().resolveBinding();
            }
            case 22: {
                return ((FieldAccess)expression).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)expression).resolveFieldBinding();
            }
        }
        return null;
    }

    public static boolean isSuperType(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        if (iTypeBinding2.isArray() || iTypeBinding2.isPrimitive()) {
            return false;
        }
        if (Bindings.equals((IBinding)iTypeBinding2, (IBinding)iTypeBinding)) {
            return true;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding2.getSuperclass();
        if (iTypeBinding3 != null && Bindings.isSuperType(iTypeBinding, iTypeBinding3)) {
            return true;
        }
        if (iTypeBinding.isInterface()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding2.getInterfaces();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                if (Bindings.isSuperType(iTypeBinding, iTypeBindingArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static ICompilationUnit findCompilationUnit(ITypeBinding iTypeBinding, IJavaProject iJavaProject) throws JavaModelException {
        IJavaElement iJavaElement = iTypeBinding.getJavaElement();
        if (iJavaElement instanceof IType) {
            return ((IType)iJavaElement).getCompilationUnit();
        }
        return null;
    }

    public static IMethod findMethod(IMethodBinding iMethodBinding, IType iType) throws JavaModelException {
        iMethodBinding = iMethodBinding.getMethodDeclaration();
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n];
            if (iMethod.getElementName().equals(iMethodBinding.getName()) && Bindings.sameParameters(iMethodBinding, iMethod)) {
                return iMethod;
            }
            ++n;
        }
        return null;
    }

    private static boolean sameParameters(IMethodBinding iMethodBinding, IMethod iMethod) throws JavaModelException {
        String[] stringArray;
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        if (iTypeBindingArray.length != (stringArray = iMethod.getParameterTypes()).length) {
            return false;
        }
        IType iType = iMethod.getDeclaringType();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            String string = stringArray[n];
            if (!Bindings.sameParameter(iTypeBinding, string, iType)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding iTypeBinding, String string, IType iType) throws JavaModelException {
        if (iTypeBinding.getDimensions() != Signature.getArrayCount((String)string)) {
            return false;
        }
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (Signature.getTypeSignatureKind((String)(string = Signature.getElementType((String)string))) == 2 != iTypeBinding.isPrimitive()) {
            return false;
        }
        if (iTypeBinding.isPrimitive() || iTypeBinding.isTypeVariable()) {
            return iTypeBinding.getName().equals(Signature.toString((String)string));
        }
        string = Signature.getTypeErasure((String)string);
        iTypeBinding = iTypeBinding.getErasure();
        if (string.charAt(Signature.getArrayCount((String)string)) == 'L') {
            return Signature.toString((String)string).equals(Bindings.getFullyQualifiedName(iTypeBinding));
        }
        String[][] stringArray = iType.resolveType(Signature.toString((String)string));
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string2 = iTypeBinding.getPackage().isUnnamed() ? "" : iTypeBinding.getPackage().getName();
        String string3 = Bindings.getTypeQualifiedName(iTypeBinding);
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            if (stringArray2[0].equals(string2) && stringArray2[1].equals(string3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static ITypeBinding normalizeTypeBinding(ITypeBinding iTypeBinding) {
        if (iTypeBinding != null && !iTypeBinding.isNullType() && !Bindings.isVoidType(iTypeBinding)) {
            if (iTypeBinding.isAnonymous()) {
                ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
                if (iTypeBindingArray.length > 0) {
                    return iTypeBindingArray[0];
                }
                return iTypeBinding.getSuperclass();
            }
            if (iTypeBinding.isCapture()) {
                return iTypeBinding.getWildcard();
            }
            return iTypeBinding;
        }
        return null;
    }

    public static boolean isVoidType(ITypeBinding iTypeBinding) {
        return "void".equals(iTypeBinding.getName());
    }

    public static ITypeBinding normalizeForDeclarationUse(ITypeBinding iTypeBinding, AST aST) {
        if (iTypeBinding.isNullType()) {
            return aST.resolveWellKnownType("java.lang.Object");
        }
        if (iTypeBinding.isPrimitive()) {
            return iTypeBinding;
        }
        if ((iTypeBinding = Bindings.normalizeTypeBinding(iTypeBinding)) == null || !iTypeBinding.isWildcardType()) {
            return iTypeBinding;
        }
        if (iTypeBinding.isUpperbound()) {
            return iTypeBinding.getBound();
        }
        return aST.resolveWellKnownType("java.lang.Object");
    }

    public static ITypeBinding getBindingOfParentType(ASTNode aSTNode) {
        while (aSTNode != null) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)aSTNode).resolveBinding();
            }
            if (aSTNode instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
            }
            if (aSTNode instanceof CompilationUnit) {
                return ((CompilationUnit)aSTNode).resolveBinding();
            }
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static ITypeBinding getBindingOfParentTypeContext(ASTNode aSTNode) {
        StructuralPropertyDescriptor structuralPropertyDescriptor = null;
        while (aSTNode != null) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
                if (structuralPropertyDescriptor == abstractTypeDeclaration.getBodyDeclarationsProperty()) {
                    return abstractTypeDeclaration.resolveBinding();
                }
                if (abstractTypeDeclaration instanceof EnumDeclaration && structuralPropertyDescriptor == EnumDeclaration.ENUM_CONSTANTS_PROPERTY) {
                    return abstractTypeDeclaration.resolveBinding();
                }
            } else if (aSTNode instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
            }
            structuralPropertyDescriptor = aSTNode.getLocationInParent();
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    public static String getRawName(ITypeBinding iTypeBinding) {
        int n;
        String string = iTypeBinding.getName();
        if ((iTypeBinding.isParameterizedType() || iTypeBinding.isGenericType()) && (n = string.indexOf(60)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getRawQualifiedName(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isAnonymous() || iTypeBinding.isLocal()) {
            return "";
        }
        if (iTypeBinding.isPrimitive() || iTypeBinding.isNullType() || iTypeBinding.isTypeVariable()) {
            return iTypeBinding.getName();
        }
        if (iTypeBinding.isArray()) {
            String string = Bindings.getRawQualifiedName(iTypeBinding.getElementType());
            if (string.length() != 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            return "";
        }
        if (iTypeBinding.isMember()) {
            String string = Bindings.getRawQualifiedName(iTypeBinding.getDeclaringClass());
            if (string.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append('.');
                stringBuffer.append(Bindings.getRawName(iTypeBinding));
                return stringBuffer.toString();
            }
            return "";
        }
        if (iTypeBinding.isTopLevel()) {
            IPackageBinding iPackageBinding = iTypeBinding.getPackage();
            StringBuffer stringBuffer = new StringBuffer();
            if (iPackageBinding != null && iPackageBinding.getName().length() > 0) {
                stringBuffer.append(iPackageBinding.getName()).append('.');
            }
            stringBuffer.append(Bindings.getRawName(iTypeBinding));
            return stringBuffer.toString();
        }
        return "";
    }

    public static boolean isDeclarationBinding(IBinding iBinding) {
        switch (iBinding.getKind()) {
            case 2: {
                return ((ITypeBinding)iBinding).getTypeDeclaration() == iBinding;
            }
            case 3: {
                return ((IVariableBinding)iBinding).getVariableDeclaration() == iBinding;
            }
            case 4: {
                return ((IMethodBinding)iBinding).getMethodDeclaration() == iBinding;
            }
        }
        return true;
    }

    public static IBinding getDeclaration(IBinding iBinding) {
        switch (iBinding.getKind()) {
            case 2: {
                return ((ITypeBinding)iBinding).getTypeDeclaration();
            }
            case 3: {
                return ((IVariableBinding)iBinding).getVariableDeclaration();
            }
            case 4: {
                return ((IMethodBinding)iBinding).getMethodDeclaration();
            }
        }
        return iBinding;
    }

    public static boolean containsSignatureEquivalentConstructor(IMethodBinding[] iMethodBindingArray, IMethodBinding iMethodBinding) {
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (Bindings.isSignatureEquivalentConstructor(iMethodBindingArray[n], iMethodBinding)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isSignatureEquivalentConstructor(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        if (!iMethodBinding.isConstructor() || !iMethodBinding2.isConstructor()) {
            return false;
        }
        if (iMethodBinding.isDefaultConstructor()) {
            return false;
        }
        return Bindings.areSubTypeCompatible(iMethodBinding, iMethodBinding2);
    }

    public static boolean areOverriddenMethods(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        if (!iMethodBinding.getName().equals(iMethodBinding2.getName())) {
            return false;
        }
        return Bindings.areSubTypeCompatible(iMethodBinding, iMethodBinding2);
    }

    private static boolean areSubTypeCompatible(IMethodBinding iMethodBinding, IMethodBinding iMethodBinding2) {
        ITypeBinding[] iTypeBindingArray;
        ITypeBinding[] iTypeBindingArray2;
        if (iMethodBinding.getParameterTypes().length != iMethodBinding2.getParameterTypes().length) {
            return false;
        }
        ITypeBinding iTypeBinding = iMethodBinding.getReturnType();
        ITypeBinding iTypeBinding2 = iMethodBinding2.getReturnType();
        if (iTypeBinding == null || iTypeBinding2 == null) {
            return false;
        }
        if (!iTypeBinding.getErasure().isSubTypeCompatible(iTypeBinding2.getErasure())) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray3 = iMethodBinding.getParameterTypes();
        Assert.isTrue((iTypeBindingArray3.length == (iTypeBindingArray2 = iMethodBinding2.getParameterTypes()).length ? 1 : 0) != 0);
        int n = 0;
        while (n < iTypeBindingArray3.length) {
            ITypeBinding iTypeBinding3;
            iTypeBindingArray = iTypeBindingArray2[n].getErasure();
            if (!iTypeBindingArray.isSubTypeCompatible(iTypeBinding3 = iTypeBindingArray3[n].getErasure()) || !iTypeBindingArray.getKey().equals(iTypeBinding3.getKey())) {
                return false;
            }
            ++n;
        }
        ITypeBinding[] iTypeBindingArray4 = iMethodBinding.getExceptionTypes();
        iTypeBindingArray = iMethodBinding2.getExceptionTypes();
        boolean bl = false;
        int n2 = 0;
        while (n2 < iTypeBindingArray4.length) {
            bl = false;
            int n3 = 0;
            while (n3 < iTypeBindingArray.length) {
                if (iTypeBindingArray4[n2].isSubTypeCompatible(iTypeBindingArray[n3])) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

