/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public class NodeFinder
extends GenericVisitor {
    private int fStart;
    private int fEnd;
    private ASTNode fCoveringNode;
    private ASTNode fCoveredNode;

    public static ASTNode perform(ASTNode aSTNode, int n, int n2) {
        NodeFinder nodeFinder = new NodeFinder(n, n2);
        aSTNode.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode2 = nodeFinder.getCoveredNode();
        if (aSTNode2 == null || aSTNode2.getStartPosition() != n || aSTNode2.getLength() != n2) {
            return nodeFinder.getCoveringNode();
        }
        return aSTNode2;
    }

    public static ASTNode perform(ASTNode aSTNode, ISourceRange iSourceRange) {
        return NodeFinder.perform(aSTNode, iSourceRange.getOffset(), iSourceRange.getLength());
    }

    public static ASTNode perform(ASTNode aSTNode, int n, int n2, ITypeRoot iTypeRoot) throws JavaModelException {
        IBuffer iBuffer;
        NodeFinder nodeFinder = new NodeFinder(n, n2);
        aSTNode.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode2 = nodeFinder.getCoveredNode();
        if (aSTNode2 == null) {
            return null;
        }
        Selection selection = Selection.createFromStartLength(n, n2);
        if (selection.covers(aSTNode2) && (iBuffer = iTypeRoot.getBuffer()) != null) {
            IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            iScanner.setSource(iBuffer.getText(n, n2).toCharArray());
            try {
                int n3;
                int n4 = iScanner.getNextToken();
                if (n4 != 158 && (n3 = iScanner.getCurrentTokenStartPosition()) == aSTNode2.getStartPosition() - n) {
                    iScanner.resetTo(n3 + aSTNode2.getLength(), n2 - 1);
                    n4 = iScanner.getNextToken();
                    if (n4 == 158) {
                        return aSTNode2;
                    }
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return nodeFinder.getCoveringNode();
    }

    public NodeFinder(int n, int n2) {
        super(true);
        this.fStart = n;
        this.fEnd = n + n2;
    }

    protected boolean visitNode(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        if (n2 < this.fStart || this.fEnd < n) {
            return false;
        }
        if (n <= this.fStart && this.fEnd <= n2) {
            this.fCoveringNode = aSTNode;
        }
        if (this.fStart <= n && n2 <= this.fEnd) {
            if (this.fCoveringNode == aSTNode) {
                this.fCoveredNode = aSTNode;
                return true;
            }
            if (this.fCoveredNode == null) {
                this.fCoveredNode = aSTNode;
            }
            return false;
        }
        return true;
    }

    public ASTNode getCoveredNode() {
        return this.fCoveredNode;
    }

    public ASTNode getCoveringNode() {
        return this.fCoveringNode;
    }
}

