/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;

public class ReplaceRewrite {
    protected ASTRewrite fRewrite;
    protected ASTNode[] fToReplace;
    protected StructuralPropertyDescriptor fDescriptor;

    public static ReplaceRewrite create(ASTRewrite aSTRewrite, ASTNode[] aSTNodeArray) {
        return new ReplaceRewrite(aSTRewrite, aSTNodeArray);
    }

    protected ReplaceRewrite(ASTRewrite aSTRewrite, ASTNode[] aSTNodeArray) {
        Assert.isNotNull((Object)aSTRewrite);
        Assert.isNotNull((Object)aSTNodeArray);
        Assert.isTrue((aSTNodeArray.length > 0 ? 1 : 0) != 0);
        this.fRewrite = aSTRewrite;
        this.fToReplace = aSTNodeArray;
        this.fDescriptor = this.fToReplace[0].getLocationInParent();
        if (aSTNodeArray.length > 1) {
            Assert.isTrue((boolean)(this.fDescriptor instanceof ChildListPropertyDescriptor));
        }
    }

    public void replace(ASTNode[] aSTNodeArray, TextEditGroup textEditGroup) {
        if (this.fToReplace.length == 1) {
            if (aSTNodeArray.length == 1) {
                this.handleOneOne(aSTNodeArray, textEditGroup);
            } else {
                this.handleOneMany(aSTNodeArray, textEditGroup);
            }
        } else {
            this.handleManyMany(aSTNodeArray, textEditGroup);
        }
    }

    protected void handleOneOne(ASTNode[] aSTNodeArray, TextEditGroup textEditGroup) {
        this.fRewrite.replace(this.fToReplace[0], aSTNodeArray[0], textEditGroup);
    }

    protected void handleOneMany(ASTNode[] aSTNodeArray, TextEditGroup textEditGroup) {
        this.handleManyMany(aSTNodeArray, textEditGroup);
    }

    protected void handleManyMany(ASTNode[] aSTNodeArray, TextEditGroup textEditGroup) {
        block6: {
            ListRewrite listRewrite;
            block7: {
                block5: {
                    listRewrite = this.fRewrite.getListRewrite(this.fToReplace[0].getParent(), (ChildListPropertyDescriptor)this.fDescriptor);
                    if (this.fToReplace.length != aSTNodeArray.length) break block5;
                    int n = 0;
                    while (n < this.fToReplace.length) {
                        listRewrite.replace(this.fToReplace[n], aSTNodeArray[n], textEditGroup);
                        ++n;
                    }
                    break block6;
                }
                if (this.fToReplace.length >= aSTNodeArray.length) break block7;
                int n = 0;
                while (n < this.fToReplace.length) {
                    listRewrite.replace(this.fToReplace[n], aSTNodeArray[n], textEditGroup);
                    ++n;
                }
                n = this.fToReplace.length;
                while (n < aSTNodeArray.length) {
                    listRewrite.insertAfter(aSTNodeArray[n], aSTNodeArray[n - 1], textEditGroup);
                    ++n;
                }
                break block6;
            }
            if (this.fToReplace.length <= aSTNodeArray.length) break block6;
            int n = this.fToReplace.length - aSTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                listRewrite.remove(this.fToReplace[n2], textEditGroup);
                ++n2;
            }
            n2 = n;
            int n3 = 0;
            while (n2 < this.fToReplace.length) {
                listRewrite.replace(this.fToReplace[n2], aSTNodeArray[n3], textEditGroup);
                ++n2;
                ++n3;
            }
        }
    }
}

