/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;

class Util {
    Util() {
    }

    static boolean rangeIncludesNonWhitespaceOutsideRange(SourceRange sourceRange, SourceRange sourceRange2, IBuffer iBuffer) {
        if (!sourceRange.covers(sourceRange2)) {
            return false;
        }
        if (!Util.isJustWhitespace(sourceRange.getOffset(), sourceRange2.getOffset(), iBuffer)) {
            return true;
        }
        return !Util.isJustWhitespaceOrComment(sourceRange2.getOffset() + sourceRange2.getLength(), sourceRange.getOffset() + sourceRange.getLength(), iBuffer);
    }

    private static boolean isJustWhitespace(int n, int n2, IBuffer iBuffer) {
        if (n == n2) {
            return true;
        }
        Assert.isTrue((n <= n2 ? 1 : 0) != 0);
        return iBuffer.getText(n, n2 - n).trim().length() == 0;
    }

    private static boolean isJustWhitespaceOrComment(int n, int n2, IBuffer iBuffer) {
        if (n == n2) {
            return true;
        }
        Assert.isTrue((n <= n2 ? 1 : 0) != 0);
        String string = iBuffer.getText(n, n2 - n).trim();
        if (string.length() == 0) {
            return true;
        }
        IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null);
        iScanner.setSource(string.toCharArray());
        try {
            return iScanner.getNextToken() == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }
}

