/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class StringFix
implements IFix {
    private final TextEditGroup[] fEditGroups;
    private final String fName;
    private final ICompilationUnit fCompilationUnit;

    public static StringFix createFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation, boolean bl, boolean bl2) throws CoreException {
        Object object;
        TextEdit textEdit = null;
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (bl2) {
            textEdit = NLSUtil.createNLSEdit(iCompilationUnit, iProblemLocation.getOffset());
        }
        ReplaceEdit replaceEdit = null;
        if (bl && (object = iCompilationUnit.getBuffer()) != null) {
            replaceEdit = StringFix.getReplace(iProblemLocation.getOffset(), iProblemLocation.getLength(), object, true);
        }
        if (textEdit != null && replaceEdit != null) {
            object = FixMessages.StringFix_AddRemoveNonNls_description;
            return new StringFix((String)object, compilationUnit, new TextEditGroup[]{new TextEditGroup((String)object, textEdit), new TextEditGroup((String)object, (TextEdit)replaceEdit)});
        }
        if (textEdit != null) {
            object = FixMessages.StringFix_AddNonNls_description;
            return new StringFix((String)object, compilationUnit, new TextEditGroup[]{new TextEditGroup((String)object, textEdit)});
        }
        if (replaceEdit != null) {
            object = FixMessages.StringFix_RemoveNonNls_description;
            return new StringFix((String)object, compilationUnit, new TextEditGroup[]{new TextEditGroup((String)object, (TextEdit)replaceEdit)});
        }
        return null;
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2) throws CoreException, JavaModelException {
        if (!bl && !bl2) {
            return null;
        }
        IProblem[] iProblemArray = compilationUnit.getProblems();
        IProblemLocation[] iProblemLocationArray = new IProblemLocation[iProblemArray.length];
        int n = 0;
        while (n < iProblemArray.length) {
            iProblemLocationArray[n] = new ProblemLocation(iProblemArray[n]);
            ++n;
        }
        return StringFix.createCleanUp(compilationUnit, bl, bl2, iProblemLocationArray);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, boolean bl, boolean bl2) throws CoreException, JavaModelException {
        if (!bl && !bl2) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, bl, bl2, iProblemLocationArray);
    }

    private static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, IProblemLocation[] iProblemLocationArray) throws CoreException, JavaModelException {
        String string;
        IProblemLocation iProblemLocation;
        TextEdit[] textEditArray;
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        ArrayList<CategorizedTextEditGroup> arrayList = new ArrayList<CategorizedTextEditGroup>();
        ArrayList<IProblemLocation> arrayList2 = new ArrayList<IProblemLocation>();
        int n = 0;
        while (n < iProblemLocationArray.length) {
            IProblemLocation iProblemLocation2 = iProblemLocationArray[n];
            if (bl && iProblemLocation2.getProblemId() == 536871173) {
                arrayList2.add(iProblemLocation2);
            }
            if (bl2 && iProblemLocation2.getProblemId() == 536871177 && (textEditArray = iCompilationUnit.getBuffer()) != null && (iProblemLocation = StringFix.getReplace(iProblemLocation2.getOffset(), iProblemLocation2.getLength(), (IBuffer)textEditArray, false)) != null) {
                string = FixMessages.StringFix_RemoveNonNls_description;
                arrayList.add(new CategorizedTextEditGroup(string, (TextEdit)iProblemLocation, new GroupCategorySet(new GroupCategory(string, string, string))));
            }
            ++n;
        }
        if (!arrayList2.isEmpty()) {
            int[] nArray = new int[arrayList2.size()];
            int n2 = 0;
            textEditArray = arrayList2.iterator();
            while (textEditArray.hasNext()) {
                iProblemLocation = (IProblemLocation)textEditArray.next();
                nArray[n2] = iProblemLocation.getOffset();
                ++n2;
            }
            textEditArray = NLSUtil.createNLSEdits(iCompilationUnit, nArray);
            if (textEditArray != null) {
                int n3 = 0;
                while (n3 < textEditArray.length) {
                    string = FixMessages.StringFix_AddNonNls_description;
                    arrayList.add(new CategorizedTextEditGroup(string, textEditArray[n3], new GroupCategorySet(new GroupCategory(string, string, string))));
                    ++n3;
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new StringFix("", compilationUnit, arrayList.toArray(new TextEditGroup[arrayList.size()]));
    }

    private static ReplaceEdit getReplace(int n, int n2, IBuffer iBuffer, boolean bl) {
        String string = new String();
        boolean bl2 = false;
        for (int i = n + n2; i < iBuffer.getLength(); ++i) {
            char c = iBuffer.getChar(i);
            if (IndentManipulation.isIndentChar((char)c)) {
                continue;
            }
            if (IndentManipulation.isLineDelimiterChar((char)c)) {
                n2 = i - n;
                break;
            }
            if (c == '/') {
                if (++i == iBuffer.getLength() || iBuffer.getChar(i) != '/') {
                    string = "//";
                } else {
                    n2 = i - n - 1;
                }
                bl2 = true;
                break;
            }
            string = "//";
            bl2 = true;
            break;
        }
        if (!bl2 && bl) {
            while (n > 0 && IndentManipulation.isIndentChar((char)iBuffer.getChar(n - 1))) {
                --n;
                ++n2;
            }
        }
        if (n2 > 0) {
            ReplaceEdit replaceEdit = new ReplaceEdit(n, n2, string);
            return replaceEdit;
        }
        return null;
    }

    private StringFix(String string, CompilationUnit compilationUnit, TextEditGroup[] textEditGroupArray) {
        this.fName = string;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fEditGroups = textEditGroupArray;
    }

    public TextChange createChange() throws CoreException {
        if (this.fEditGroups == null || this.fEditGroups.length == 0) {
            return null;
        }
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getDescription(), this.getCompilationUnit());
        int n = 0;
        while (n < this.fEditGroups.length) {
            TextEdit[] textEditArray = this.fEditGroups[n].getTextEdits();
            String string = this.fEditGroups[n].getName();
            int n2 = 0;
            while (n2 < textEditArray.length) {
                TextChangeCompatibility.addTextEdit((TextChange)compilationUnitChange, string, textEditArray[n2]);
                ++n2;
            }
            ++n;
        }
        return compilationUnitChange;
    }

    public String getDescription() {
        return this.fName;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

