/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class UnusedCodeFix
extends AbstractFix {
    private final Map fCleanUpOptions;
    static /* synthetic */ Class class$0;

    public static UnusedCodeFix createRemoveUnusedImportFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        ImportDeclaration importDeclaration;
        int n = iProblemLocation.getProblemId();
        if ((n == 268435844 || n == 268435842 || n == 0x10000181 || n == 268435843 || n == 268435846) && (importDeclaration = UnusedCodeFix.getImportDeclaration(iProblemLocation, compilationUnit)) != null) {
            String string = FixMessages.UnusedCodeFix_RemoveImport_description;
            RemoveImportOperation removeImportOperation = new RemoveImportOperation(importDeclaration);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("cleanup.remove_unused_imports", "true");
            return new UnusedCodeFix(string, compilationUnit, new IFixRewriteOperation[]{removeImportOperation}, hashtable);
        }
        return null;
    }

    public static UnusedCodeFix createUnusedMemberFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation, boolean bl) {
        IBinding iBinding;
        SimpleName simpleName;
        int n = iProblemLocation.getProblemId();
        if ((n == 603979894 || n == 603979910 || n == 570425421 || n == 553648135 || n == 536870973 || n == 536870974) && (simpleName = UnusedCodeFix.getUnusedName(compilationUnit, iProblemLocation)) != null && (iBinding = simpleName.resolveBinding()) != null) {
            if (UnusedCodeFix.isFormalParameterInEnhancedForStatement(simpleName)) {
                return null;
            }
            String string = UnusedCodeFix.getDisplayString(simpleName, iBinding, bl);
            RemoveUnusedMemberOperation removeUnusedMemberOperation = new RemoveUnusedMemberOperation(new SimpleName[]{simpleName}, bl);
            return new UnusedCodeFix(string, compilationUnit, new IFixRewriteOperation[]{removeUnusedMemberOperation}, UnusedCodeFix.getCleanUpOptions(iBinding));
        }
        return null;
    }

    public static IFix createRemoveUnusedCastFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        ASTNode aSTNode;
        if (iProblemLocation.getProblemId() != 553648309) {
            return null;
        }
        ASTNode aSTNode2 = aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        while (aSTNode2 instanceof ParenthesizedExpression) {
            aSTNode2 = ((ParenthesizedExpression)aSTNode2).getExpression();
        }
        if (!(aSTNode2 instanceof CastExpression)) {
            return null;
        }
        return new UnusedCodeFix(FixMessages.UnusedCodeFix_RemoveCast_description, compilationUnit, new IFixRewriteOperation[]{new RemoveCastOperation((CastExpression)aSTNode2, aSTNode)});
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        IProblem[] iProblemArray = compilationUnit.getProblems();
        IProblemLocation[] iProblemLocationArray = new IProblemLocation[iProblemArray.length];
        int n = 0;
        while (n < iProblemArray.length) {
            iProblemLocationArray[n] = new ProblemLocation(iProblemArray[n]);
            ++n;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, iProblemLocationArray, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        IProblemLocation iProblemLocation;
        ArrayList<AbstractFix.AbstractFixRewriteOperation> arrayList = new ArrayList<AbstractFix.AbstractFixRewriteOperation>();
        Hashtable hashtable = new Hashtable();
        HashSet<IBinding> hashSet = new HashSet<IBinding>();
        int n = 0;
        while (n < iProblemLocationArray.length) {
            IBinding iBinding;
            ImportDeclaration importDeclaration;
            iProblemLocation = iProblemLocationArray[n];
            int n2 = iProblemLocation.getProblemId();
            if (bl6 && (n2 == 268435844 || n2 == 268435842 || n2 == 0x10000181 || n2 == 268435843 || n2 == 268435846) && (importDeclaration = UnusedCodeFix.getImportDeclaration(iProblemLocation, compilationUnit)) != null) {
                arrayList.add(new RemoveImportOperation(importDeclaration));
            }
            if ((bl && n2 == 603979894 || bl2 && n2 == 603979910 || bl4 && n2 == 553648135) && (importDeclaration = UnusedCodeFix.getUnusedName(compilationUnit, iProblemLocation)) != null && (iBinding = importDeclaration.resolveBinding()) != null) {
                arrayList.add(new RemoveUnusedMemberOperation(new SimpleName[]{importDeclaration}, false));
            }
            if ((bl5 && n2 == 536870973 || bl3 && n2 == 570425421) && (importDeclaration = UnusedCodeFix.getUnusedName(compilationUnit, iProblemLocation)) != null && (iBinding = importDeclaration.resolveBinding()) != null && !UnusedCodeFix.isFormalParameterInEnhancedForStatement((SimpleName)importDeclaration) && UnusedCodeFix.isSideEffectFree((SimpleName)importDeclaration, compilationUnit)) {
                VariableDeclarationFragment variableDeclarationFragment;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((variableDeclarationFragment = (VariableDeclarationFragment)ASTNodes.getParent((ASTNode)importDeclaration, clazz)) != null) {
                    ASTNode aSTNode = variableDeclarationFragment.getParent();
                    if (!hashtable.containsKey(aSTNode)) {
                        hashtable.put(aSTNode, new ArrayList());
                    }
                    ((List)hashtable.get(aSTNode)).add(importDeclaration);
                } else {
                    arrayList.add(new RemoveUnusedMemberOperation(new SimpleName[]{importDeclaration}, false));
                }
            }
            if (bl7 && n2 == 553648309) {
                importDeclaration = iProblemLocation.getCoveringNode(compilationUnit);
                iBinding = importDeclaration;
                while (iBinding instanceof ParenthesizedExpression) {
                    iBinding = ((ParenthesizedExpression)iBinding).getExpression();
                }
                if (iBinding instanceof CastExpression) {
                    hashSet.add(iBinding);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            iProblemLocation = (ASTNode)iterator.next();
            List list = (List)hashtable.get(iProblemLocation);
            arrayList.add(new RemoveUnusedMemberOperation(list.toArray(new SimpleName[list.size()]), false));
        }
        if (hashSet.size() > 0) {
            arrayList.add(new RemoveAllCastOperation(hashSet));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return new UnusedCodeFix(FixMessages.UnusedCodeFix_change_name, compilationUnit, arrayList.toArray(new IFixRewriteOperation[arrayList.size()]));
    }

    private static boolean isFormalParameterInEnhancedForStatement(SimpleName simpleName) {
        return simpleName.getParent() instanceof SingleVariableDeclaration && simpleName.getParent().getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY;
    }

    private static boolean isSideEffectFree(SimpleName simpleName, CompilationUnit compilationUnit) {
        SimpleName simpleName2 = (SimpleName)NodeFinder.perform((ASTNode)compilationUnit, simpleName.getStartPosition(), simpleName.getLength());
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding((ASTNode)compilationUnit, simpleName2.resolveBinding());
        int n = 0;
        while (n < simpleNameArray.length) {
            if (UnusedCodeFix.hasSideEffect(simpleNameArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean hasSideEffect(SimpleName simpleName) {
        Object object;
        ASTNode aSTNode = simpleName.getParent();
        while (aSTNode instanceof QualifiedName) {
            aSTNode = aSTNode.getParent();
        }
        if (aSTNode instanceof FieldAccess) {
            aSTNode = aSTNode.getParent();
        }
        Expression expression = null;
        int n = aSTNode.getNodeType();
        if (n == 7) {
            object = (Assignment)aSTNode;
            expression = object.getRightHandSide();
        } else if (n == 44) {
            object = (SingleVariableDeclaration)aSTNode;
            expression = object.getInitializer();
            if (expression == null) {
                return false;
            }
        } else if (n == 59) {
            expression = aSTNode;
        } else {
            return false;
        }
        object = new ArrayList();
        expression.accept((ASTVisitor)new SideEffectFinder((ArrayList)object));
        return ((ArrayList)object).size() > 0;
    }

    private static SimpleName getUnusedName(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode instanceof MethodDeclaration) {
            return ((MethodDeclaration)aSTNode).getName();
        }
        if (aSTNode instanceof SimpleName) {
            return (SimpleName)aSTNode;
        }
        return null;
    }

    private static String getDisplayString(SimpleName simpleName, IBinding iBinding, boolean bl) {
        String string = simpleName.getIdentifier();
        switch (iBinding.getKind()) {
            case 2: {
                return Messages.format(FixMessages.UnusedCodeFix_RemoveType_description, string);
            }
            case 4: {
                if (((IMethodBinding)iBinding).isConstructor()) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveConstructor_description, string);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveMethod_description, string);
            }
            case 3: {
                if (bl) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocalWithInitializer_description, string);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_description, string);
            }
        }
        return "";
    }

    private static Map getCleanUpOptions(IBinding iBinding) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("cleanup.remove_unused_private_members", "true");
        switch (iBinding.getKind()) {
            case 2: {
                hashtable.put("cleanup.remove_unused_private_types", "true");
                break;
            }
            case 4: {
                if (((IMethodBinding)iBinding).isConstructor()) {
                    hashtable.put("cleanup.remove_private_constructors", "true");
                    break;
                }
                hashtable.put("cleanup.remove_unused_private_methods", "true");
                break;
            }
            case 3: {
                hashtable.put("cleanup.remove_unused_private_fields", "true");
                hashtable.put("cleanup.remove_unused_local_variables", "true");
            }
        }
        return hashtable;
    }

    private static ImportDeclaration getImportDeclaration(IProblemLocation iProblemLocation, CompilationUnit compilationUnit) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode2 != null && (aSTNode = ASTNodes.getParent(aSTNode2, 26)) instanceof ImportDeclaration) {
            return (ImportDeclaration)aSTNode;
        }
        return null;
    }

    private UnusedCodeFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        this(string, compilationUnit, iFixRewriteOperationArray, null);
    }

    private UnusedCodeFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray, Map map) {
        super(string, compilationUnit, iFixRewriteOperationArray);
        this.fCleanUpOptions = map == null ? new Hashtable() : map;
    }

    public UnusedCodeCleanUp getCleanUp() {
        return new UnusedCodeCleanUp(this.fCleanUpOptions);
    }

    private static class RemoveAllCastOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final HashSet fUnnecessaryCasts;

        public RemoveAllCastOperation(HashSet hashSet) {
            this.fUnnecessaryCasts = hashSet;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description);
            list.add(textEditGroup);
            while (this.fUnnecessaryCasts.size() > 0) {
                CastExpression castExpression = (CastExpression)this.fUnnecessaryCasts.iterator().next();
                this.fUnnecessaryCasts.remove(castExpression);
                CastExpression castExpression2 = castExpression;
                while (this.fUnnecessaryCasts.contains(castExpression2.getExpression())) {
                    castExpression2 = (CastExpression)castExpression2.getExpression();
                    this.fUnnecessaryCasts.remove(castExpression2);
                }
                ASTNode aSTNode = aSTRewrite.createMoveTarget((ASTNode)castExpression2.getExpression());
                CastExpression castExpression3 = castExpression;
                while (this.fUnnecessaryCasts.contains(castExpression3.getParent())) {
                    castExpression3 = (CastExpression)castExpression3.getParent();
                    this.fUnnecessaryCasts.remove(castExpression3);
                }
                aSTRewrite.replace((ASTNode)castExpression3, aSTNode, textEditGroup);
            }
        }
    }

    private static class RemoveCastOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final CastExpression fCast;
        private final ASTNode fSelectedNode;

        public RemoveCastOperation(CastExpression castExpression, ASTNode aSTNode) {
            this.fCast = castExpression;
            this.fSelectedNode = aSTNode;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description);
            list.add(textEditGroup);
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            CastExpression castExpression = this.fCast;
            Expression expression = castExpression.getExpression();
            ASTNode aSTNode = aSTRewrite.createCopyTarget((ASTNode)expression);
            if (ASTNodes.needsParentheses(expression)) {
                aSTRewrite.replace((ASTNode)this.fCast, aSTNode, textEditGroup);
            } else {
                aSTRewrite.replace(this.fSelectedNode, aSTNode, textEditGroup);
            }
        }
    }

    private static class RemoveImportOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ImportDeclaration fImportDeclaration;

        public RemoveImportOperation(ImportDeclaration importDeclaration) {
            this.fImportDeclaration = importDeclaration;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ImportDeclaration importDeclaration = this.fImportDeclaration;
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveImport_description);
            compilationUnitRewrite.getASTRewrite().remove((ASTNode)importDeclaration, textEditGroup);
            list.add(textEditGroup);
        }
    }

    private static class RemoveUnusedMemberOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final SimpleName[] fUnusedNames;
        private boolean fForceRemove;
        private int fRemovedAssignmentsCount;
        private int fAlteredAssignmentsCount;

        public RemoveUnusedMemberOperation(SimpleName[] simpleNameArray, boolean bl) {
            this.fUnusedNames = simpleNameArray;
            this.fForceRemove = bl;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            int n = 0;
            while (n < this.fUnusedNames.length) {
                this.removeUnusedName(compilationUnitRewrite.getASTRewrite(), this.fUnusedNames[n], compilationUnitRewrite.getRoot(), list);
                ++n;
            }
        }

        private void removeUnusedName(ASTRewrite aSTRewrite, SimpleName simpleName, CompilationUnit compilationUnit, List list) {
            IBinding iBinding = simpleName.resolveBinding();
            CompilationUnit compilationUnit2 = (CompilationUnit)simpleName.getRoot();
            String string = this.getDisplayString(iBinding);
            TextEditGroup textEditGroup = this.createTextEditGroup(string);
            list.add(textEditGroup);
            if (iBinding.getKind() == 4) {
                IMethodBinding iMethodBinding = ((IMethodBinding)iBinding).getMethodDeclaration();
                ASTNode aSTNode = compilationUnit2.findDeclaringNode((IBinding)iMethodBinding);
                aSTRewrite.remove(aSTNode, textEditGroup);
            } else if (iBinding.getKind() == 2) {
                ITypeBinding iTypeBinding = ((ITypeBinding)iBinding).getTypeDeclaration();
                ASTNode aSTNode = compilationUnit2.findDeclaringNode((IBinding)iTypeBinding);
                if (aSTNode.getParent() instanceof TypeDeclarationStatement) {
                    aSTNode = aSTNode.getParent();
                }
                aSTRewrite.remove(aSTNode, textEditGroup);
            } else if (iBinding.getKind() == 3) {
                SimpleName simpleName2 = (SimpleName)NodeFinder.perform((ASTNode)compilationUnit, simpleName.getStartPosition(), simpleName.getLength());
                SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding((ASTNode)compilationUnit, simpleName2.resolveBinding());
                int n = 0;
                while (n < simpleNameArray.length) {
                    this.removeVariableReferences(aSTRewrite, simpleNameArray[n], textEditGroup);
                    ++n;
                }
                IVariableBinding iVariableBinding = ((IVariableBinding)simpleName2.resolveBinding()).getVariableDeclaration();
                ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iVariableBinding);
                if (aSTNode instanceof SingleVariableDeclaration) {
                    this.removeParamTag(aSTRewrite, (SingleVariableDeclaration)aSTNode, textEditGroup);
                }
            }
        }

        private String getDisplayString(IBinding iBinding) {
            switch (iBinding.getKind()) {
                case 2: {
                    return FixMessages.UnusedCodeFix_RemoveUnusedType_description;
                }
                case 4: {
                    if (((IMethodBinding)iBinding).isConstructor()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedConstructor_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedPrivateMethod_description;
                }
                case 3: {
                    if (((IVariableBinding)iBinding).isField()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedField_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedVariabl_description;
                }
            }
            return "";
        }

        private void removeParamTag(ASTRewrite aSTRewrite, SingleVariableDeclaration singleVariableDeclaration, TextEditGroup textEditGroup) {
            TagElement tagElement;
            Javadoc javadoc;
            if (singleVariableDeclaration.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)singleVariableDeclaration.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, singleVariableDeclaration.getName().getIdentifier())) != null) {
                aSTRewrite.remove((ASTNode)tagElement, textEditGroup);
            }
        }

        private void removeVariableReferences(ASTRewrite aSTRewrite, SimpleName simpleName, TextEditGroup textEditGroup) {
            int n;
            ASTNode aSTNode = simpleName.getParent();
            while (aSTNode instanceof QualifiedName) {
                aSTNode = aSTNode.getParent();
            }
            if (aSTNode instanceof FieldAccess) {
                aSTNode = aSTNode.getParent();
            }
            if ((n = aSTNode.getNodeType()) == 7) {
                Assignment assignment = (Assignment)aSTNode;
                Expression expression = assignment.getRightHandSide();
                ASTNode aSTNode2 = assignment.getParent();
                if (aSTNode2.getNodeType() == 21 && expression.getNodeType() != 7) {
                    this.removeVariableWithInitializer(aSTRewrite, (ASTNode)expression, aSTNode2, textEditGroup);
                } else {
                    aSTRewrite.replace((ASTNode)assignment, aSTRewrite.createCopyTarget((ASTNode)expression), textEditGroup);
                }
            } else if (n == 44) {
                aSTRewrite.remove(aSTNode, textEditGroup);
            } else if (n == 59) {
                boolean bl;
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode;
                ASTNode aSTNode3 = variableDeclarationFragment.getParent();
                List list = aSTNode3 instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)aSTNode3).fragments() : (aSTNode3 instanceof FieldDeclaration ? ((FieldDeclaration)aSTNode3).fragments() : ((VariableDeclarationStatement)aSTNode3).fragments());
                Expression expression = variableDeclarationFragment.getInitializer();
                boolean bl2 = bl = expression instanceof MethodInvocation || expression instanceof ClassInstanceCreation;
                if (list.size() == this.fUnusedNames.length) {
                    if (this.fForceRemove) {
                        aSTRewrite.remove(aSTNode3, textEditGroup);
                        return;
                    }
                    if (aSTNode.getParent() instanceof FieldDeclaration) {
                        aSTRewrite.remove(aSTNode3, textEditGroup);
                        return;
                    }
                    if (bl) {
                        Expression expression2 = (Expression)aSTRewrite.createMoveTarget((ASTNode)expression);
                        ExpressionStatement expressionStatement = aSTRewrite.getAST().newExpressionStatement(expression2);
                        aSTRewrite.replace(aSTNode3, (ASTNode)expressionStatement, textEditGroup);
                    } else {
                        aSTRewrite.remove(aSTNode3, textEditGroup);
                    }
                } else {
                    if (this.fForceRemove) {
                        aSTRewrite.remove((ASTNode)variableDeclarationFragment, textEditGroup);
                        return;
                    }
                    ASTNode aSTNode4 = aSTNode.getParent();
                    if (aSTNode4 instanceof FieldDeclaration) {
                        aSTRewrite.remove((ASTNode)variableDeclarationFragment, textEditGroup);
                        return;
                    }
                    if (aSTNode4 instanceof VariableDeclarationStatement) {
                        ASTNode aSTNode5 = aSTNode4.getParent();
                        if (aSTNode5 instanceof Block) {
                            this.splitUpDeclarations(aSTRewrite, textEditGroup, variableDeclarationFragment, aSTNode5, (VariableDeclarationStatement)aSTNode4);
                        }
                        aSTRewrite.remove((ASTNode)variableDeclarationFragment, textEditGroup);
                        return;
                    }
                    if (aSTNode4 instanceof VariableDeclarationExpression && !bl) {
                        aSTRewrite.remove((ASTNode)variableDeclarationFragment, textEditGroup);
                    }
                }
            }
        }

        private void splitUpDeclarations(ASTRewrite aSTRewrite, TextEditGroup textEditGroup, VariableDeclarationFragment variableDeclarationFragment, ASTNode aSTNode, VariableDeclarationStatement variableDeclarationStatement) {
            Expression expression = variableDeclarationFragment.getInitializer();
            if (expression instanceof MethodInvocation || expression instanceof ClassInstanceCreation) {
                Expression expression2 = (Expression)aSTRewrite.createMoveTarget((ASTNode)expression);
                ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode, Block.STATEMENTS_PROPERTY);
                ExpressionStatement expressionStatement = aSTRewrite.getAST().newExpressionStatement(expression2);
                listRewrite.insertAfter((ASTNode)expressionStatement, (ASTNode)variableDeclarationStatement, textEditGroup);
                VariableDeclarationStatement variableDeclarationStatement2 = null;
                List list = variableDeclarationStatement.fragments();
                int n = list.indexOf(variableDeclarationFragment);
                ListIterator listIterator = list.listIterator(n + 1);
                while (listIterator.hasNext()) {
                    VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)listIterator.next();
                    VariableDeclarationFragment variableDeclarationFragment3 = (VariableDeclarationFragment)aSTRewrite.createMoveTarget((ASTNode)variableDeclarationFragment2);
                    if (variableDeclarationStatement2 == null) {
                        variableDeclarationStatement2 = aSTRewrite.getAST().newVariableDeclarationStatement(variableDeclarationFragment3);
                        Type type = (Type)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationStatement.getType());
                        variableDeclarationStatement2.setType(type);
                        continue;
                    }
                    variableDeclarationStatement2.fragments().add(variableDeclarationFragment3);
                }
                if (variableDeclarationStatement2 != null) {
                    listRewrite.insertAfter(variableDeclarationStatement2, (ASTNode)expressionStatement, textEditGroup);
                }
                if (variableDeclarationStatement.fragments().size() == variableDeclarationStatement2.fragments().size() + 1) {
                    aSTRewrite.remove((ASTNode)variableDeclarationStatement, textEditGroup);
                }
            }
        }

        private void removeVariableWithInitializer(ASTRewrite aSTRewrite, ASTNode aSTNode, ASTNode aSTNode2, TextEditGroup textEditGroup) {
            ASTNode aSTNode3;
            boolean bl = this.fForceRemove;
            if (!bl) {
                aSTNode3 = new ArrayList();
                aSTNode.accept((ASTVisitor)new SideEffectFinder((ArrayList)aSTNode3));
                bl = aSTNode3.isEmpty();
            }
            if (bl) {
                if (ASTNodes.isControlStatementBody(aSTNode2.getLocationInParent())) {
                    aSTRewrite.replace(aSTNode2, (ASTNode)aSTRewrite.getAST().newBlock(), textEditGroup);
                } else {
                    aSTRewrite.remove(aSTNode2, textEditGroup);
                }
                ++this.fRemovedAssignmentsCount;
            } else {
                aSTNode3 = aSTRewrite.createMoveTarget(aSTNode);
                ExpressionStatement expressionStatement = aSTRewrite.getAST().newExpressionStatement((Expression)aSTNode3);
                aSTRewrite.replace(aSTNode2, (ASTNode)expressionStatement, null);
                ++this.fAlteredAssignmentsCount;
            }
        }

        public String getAdditionalInfo() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fRemovedAssignmentsCount > 0) {
                stringBuffer.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_RemovedAssignments_preview, String.valueOf(this.fRemovedAssignmentsCount)));
            }
            if (this.fAlteredAssignmentsCount > 0) {
                stringBuffer.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_AlteredAssignments_preview, String.valueOf(this.fAlteredAssignmentsCount)));
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return null;
        }
    }

    private static class SideEffectFinder
    extends ASTVisitor {
        private final ArrayList fSideEffectNodes;

        public SideEffectFinder(ArrayList arrayList) {
            this.fSideEffectNodes = arrayList;
        }

        public boolean visit(Assignment assignment) {
            this.fSideEffectNodes.add(assignment);
            return false;
        }

        public boolean visit(PostfixExpression postfixExpression) {
            this.fSideEffectNodes.add(postfixExpression);
            return false;
        }

        public boolean visit(PrefixExpression prefixExpression) {
            PrefixExpression.Operator operator = prefixExpression.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add(prefixExpression);
            }
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            this.fSideEffectNodes.add(methodInvocation);
            return false;
        }

        public boolean visit(ClassInstanceCreation classInstanceCreation) {
            this.fSideEffectNodes.add(classInstanceCreation);
            return false;
        }

        public boolean visit(SuperMethodInvocation superMethodInvocation) {
            this.fSideEffectNodes.add(superMethodInvocation);
            return false;
        }
    }
}

